/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.image.Layer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageHelper {
    private static final Logger log = LoggerFactory.getLogger(ImageHelper.class);

    public static Rectangle getCropRect(String rectCSV, String path) {
        block3: {
            if (rectCSV != null && rectCSV.length() > 0) {
                try {
                    String[] cords = rectCSV.split(",");
                    int x1 = Integer.parseInt(cords[0]);
                    int y1 = Integer.parseInt(cords[1]);
                    int x2 = Integer.parseInt(cords[2]);
                    int y2 = Integer.parseInt(cords[3]);
                    return new Rectangle(x1, y1, x2 - x1, y2 - y1);
                }
                catch (Exception e) {
                    if (path == null) break block3;
                    log.warn("cropRect at {} is not valid: {}", (Object)path, (Object)e.toString());
                }
            }
        }
        return null;
    }

    public static Layer createLayer(Node node, String imageName, String refName) throws RepositoryException, IOException {
        if (node.hasNode(imageName)) {
            return ImageHelper.createLayer((Item)node.getNode(imageName));
        }
        String imageRef = node.hasProperty(refName) ? node.getProperty(refName).getString() : "";
        return ImageHelper.createLayer(node.getSession(), imageRef);
    }

    public static Layer createLayer(Session session, String path) throws RepositoryException, IOException {
        if (path.length() > 0 && session.itemExists(path)) {
            return ImageHelper.createLayer(session.getItem(path));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Layer createLayer(Resource resource) {
        if (resource == null) {
            return null;
        }
        InputStream in = (InputStream)resource.adaptTo(InputStream.class);
        if (in != null) {
            try {
                Layer layer = new Layer(in);
                return layer;
            }
            catch (IOException e) {
                log.error("Error while creating layer.");
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            log.warn("Given resource not adaptable to stream: " + resource.getPath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Layer createLayer(Item item) throws RepositoryException, IOException {
        InputStream in = null;
        if (item.isNode()) {
            Node node = (Node)item;
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            if (node.hasProperty("jcr:data")) {
                in = node.getProperty("jcr:data").getStream();
            }
        } else {
            in = ((Property)item).getStream();
        }
        try {
            Layer layer = in == null ? null : new Layer(in);
            return layer;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int parseFontStyle(String ... styles) {
        int style = 0;
        for (String s : styles) {
            for (String st : s.split("[, |]+")) {
                if ((st = st.toLowerCase()).equals("bold")) {
                    style |= 1;
                    continue;
                }
                if (st.equals("italic")) {
                    style |= 2;
                    continue;
                }
                if (st.equals("underline")) {
                    style |= 4;
                    continue;
                }
                if (!st.equals("strikeout")) continue;
                style |= 8;
            }
        }
        return style;
    }

    public static Layer resize(Layer layer, Dimension d, Dimension min, Dimension max) {
        int maxHeight;
        int width = d == null ? 0 : (int)d.getWidth();
        int height = d == null ? 0 : (int)d.getHeight();
        int minWidth = min == null ? 0 : (int)min.getWidth();
        int minHeight = min == null ? 0 : (int)min.getHeight();
        int maxWidth = max == null ? 0 : (int)max.getWidth();
        int n = maxHeight = max == null ? 0 : (int)max.getHeight();
        if (maxWidth == 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        if (maxHeight == 0) {
            maxHeight = Integer.MAX_VALUE;
        }
        int ratioW = layer.getWidth();
        int ratioH = layer.getHeight();
        int loopProtect = 32;
        while (loopProtect-- > 0) {
            if (width == 0 && height == 0) {
                width = layer.getWidth();
                height = layer.getHeight();
                continue;
            }
            if (width == 0) {
                if (height < minHeight) {
                    height = minHeight;
                } else if (height > maxHeight) {
                    height = maxHeight;
                }
                width = height * ratioW / ratioH;
                continue;
            }
            if (height == 0) {
                if (width < minWidth) {
                    width = minWidth;
                } else if (width > maxWidth) {
                    width = maxWidth;
                }
                height = width * ratioH / ratioW;
                continue;
            }
            ratioW = width;
            ratioH = height;
            if (width < minWidth) {
                width = minWidth;
                height = 0;
                continue;
            }
            if (width > maxWidth) {
                width = maxWidth;
                height = 0;
                continue;
            }
            if (height < minHeight) {
                height = minHeight;
                width = 0;
                continue;
            }
            if (height <= maxHeight) break;
            height = maxHeight;
            width = 0;
        }
        if (loopProtect > 0 && (width != layer.getWidth() || height != layer.getHeight())) {
            layer.resize(width, height);
        }
        return layer;
    }

    public static Color parseColor(String s) {
        try {
            int i = Integer.decode(s);
            return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, i >> 24 & 0xFF);
        }
        catch (NumberFormatException e) {
            return new Color(0, 0, 0, 0);
        }
    }

    public static Color parseColor(String s, int alpha) {
        try {
            int i = Integer.decode(s);
            return new Color(i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF, alpha);
        }
        catch (NumberFormatException e) {
            return new Color(0, 0, 0, 0);
        }
    }
}

