/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsHelper {
    private static final String REQ_ATTR_GLOBAL_LOAD_RSRC = "cq5.form.loadmap";
    private static final String REQ_ATTR_CLIENT_VALIDATION = "cq5.form.clientvalidation";
    private static final String REQ_ATTR_FORMID = "cq5.form.id";
    private static final String REQ_ATTR_WRITTEN_JAVASCRIPT = "cq5.form.javascript";
    private static final String REQ_ATTR_FORWARD_PATH = "cq5.form.forward.path";
    private static final String REQ_ATTR_IS_INIT = "cq5.form.init";

    private FormsHelper() {
    }

    public static void startForm(SlingHttpServletRequest req, SlingHttpServletResponse response, JspWriter out) throws IOException, ServletException {
        Resource resource = req.getResource();
        FormsHelper.initialize(req, resource, response, out);
        FormsHelper.writeJavaScript(req, response, resource, out);
    }

    private static void initialize(SlingHttpServletRequest request, Resource formResource, SlingHttpServletResponse response, JspWriter out) throws IOException, ServletException {
        String actionType;
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        Boolean clientValidation = (Boolean)properties.get("clientValidation", (Object)Boolean.FALSE);
        request.setAttribute(REQ_ATTR_CLIENT_VALIDATION, (Object)clientValidation);
        request.setAttribute(REQ_ATTR_FORMID, properties.get("formid", (Object)"new_form"));
        request.setAttribute(REQ_ATTR_IS_INIT, (Object)"true");
        if (response != null && (actionType = (String)properties.get("actionType", (Object)"foundation/components/form/actions/store")).length() != 0) {
            out.flush();
            String rt = actionType;
            if (actionType.indexOf(47) == -1) {
                rt = "foundation/components/form/actions/" + rt;
            }
            ResourceWrapper includeResource = new ResourceWrapper(formResource, rt, "foundation/components/form/defaults/action");
            FormsHelper.includeResource(request, response, includeResource, "init");
        }
        if (request.getAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC) == null) {
            Resource loadResource = null;
            String loadPath = (String)properties.get("loadPath", (Object)"");
            if (loadPath.length() > 0) {
                loadResource = formResource.getResourceResolver().getResource(loadPath);
            }
            FormsHelper.setFormLoadResource(request, loadResource);
        }
    }

    private static void checkInit(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR_IS_INIT) == null) {
            Resource formStart = FormsHelper.searchFormStart(request.getResource());
            try {
                FormsHelper.initialize(request, formStart, null, null);
            }
            catch (IOException e) {
            }
            catch (ServletException servletException) {
                // empty catch block
            }
        }
    }

    private static Resource searchFormStart(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            if (!current.getResourceType().equals("foundation/components/form/start")) continue;
            return current;
        }
        return FormsHelper.searchFormStart(parent);
    }

    public static void endForm(SlingHttpServletRequest req) {
        FormsHelper.setFormLoadResource(req, null);
        req.removeAttribute(REQ_ATTR_CLIENT_VALIDATION);
        req.removeAttribute(REQ_ATTR_FORMID);
        req.removeAttribute(REQ_ATTR_IS_INIT);
    }

    public static void setForwardPath(SlingHttpServletRequest req, String path) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, (Object)path);
    }

    public static String getForwardPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_FORWARD_PATH);
    }

    public static void setFormLoadResource(SlingHttpServletRequest req, Resource rsrc) {
        req.removeAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC);
        if (rsrc != null) {
            ValueMap map = ResourceUtil.getValueMap((Resource)rsrc);
            req.setAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC, (Object)map);
        }
    }

    public static String getFormsPreCheckMethodName(SlingHttpServletRequest req) {
        return "cq5forms_preCheck_" + FormsHelper.getFormId(req);
    }

    private static void writeJavaScript(SlingHttpServletRequest req, SlingHttpServletResponse response, Resource formResource, JspWriter out) throws IOException, ServletException {
        if (FormsHelper.doClientValidation(req)) {
            if (req.getAttribute(REQ_ATTR_WRITTEN_JAVASCRIPT) == null) {
                req.setAttribute(REQ_ATTR_WRITTEN_JAVASCRIPT, (Object)true);
                out.println("<script type=\"text/javascript\">");
                out.println("  function cq5forms_showMsg(fid, field, msg) {    alert(msg);    document.forms[fid].elements[field].focus();  }");
                out.println("</script>");
            }
            out.println("<script type=\"text/javascript\">");
            out.println("  function " + FormsHelper.getFormsPreCheckMethodName(req) + "(submitid) {");
            out.println("    var dMsgs = \"Please fill out the required field.\";");
            Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
            while (iter.hasNext()) {
                Resource element = iter.next();
                out.flush();
                FormsHelper.includeResource(req, response, element, "clientvalidation");
            }
            out.println("    return true;");
            out.println("  }");
            out.println("</script>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeResource(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, String selectorString) throws IOException, ServletException {
        Object oldValue = request.getAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
        try {
            request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, (Object)"true");
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setReplaceSelectors(selectorString);
            request.getRequestDispatcher(resource, options).include((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (oldValue == null) {
                request.removeAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
            } else {
                request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, oldValue);
            }
        }
    }

    public static ValueMap getGlobalFormValues(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (ValueMap)req.getAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC);
    }

    public static boolean doClientValidation(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        Boolean value = (Boolean)req.getAttribute(REQ_ATTR_CLIENT_VALIDATION);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public static String getFormId(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (String)req.getAttribute(REQ_ATTR_FORMID);
    }

    public static String getParameterName(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
        String name = (String)properties.get("name", (Object)"");
        if (name.length() == 0) {
            name = ResourceUtil.getName((Resource)rsrc);
            name = FormsHelper.filterElementName(name);
        }
        return name;
    }

    public static Iterator<Resource> getFormElements(Resource formResource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)formResource));
        while (!((Resource)iter.next()).getPath().equals(formResource.getPath())) {
        }
        FormsHelper.collectFormElements(list, iter);
        return list.iterator();
    }

    public static Iterator<String> getContentRequestParameterNames(SlingHttpServletRequest req) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (name.startsWith(":") || name.equals("_charset_")) continue;
            names.add(name);
        }
        return names.iterator();
    }

    private static boolean collectFormElements(List<Resource> list, Iterator<Resource> iter) {
        Resource n;
        boolean stop = false;
        while (!stop && iter.hasNext() && !"foundation/components/form/end".equals((n = iter.next()).getResourceType()) && !"foundation/components/form/end".equals(n.getResourceSuperType())) {
            if (n.getResourceType().startsWith("foundation/components/form/") || n.getResourceSuperType() != null && n.getResourceSuperType().startsWith("foundation/components/form/")) {
                list.add(n);
                continue;
            }
            Iterator cI = ResourceUtil.listChildren((Resource)n);
            if (cI == null) continue;
            stop = FormsHelper.collectFormElements(list, cI);
        }
        return stop;
    }

    private static String filterElementName(String nodeName) {
        StringBuffer sb = new StringBuffer();
        int lastAdded = 0;
        nodeName = nodeName.toLowerCase();
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            int toAdd = c;
            if ("abcdefghijklmnopqrstuvwxyz0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZ./:-".indexOf(c) < 0) {
                if (lastAdded == 95) continue;
                toAdd = 95;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append('_');
            }
            sb.append((char)toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    public static String getValue(SlingHttpServletRequest request, Resource elementResource) {
        String[] values = FormsHelper.getValues(request, elementResource);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static String[] getValues(SlingHttpServletRequest request, Resource elementResource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)elementResource);
        String name = FormsHelper.getParameterName(elementResource);
        ValidationInfo info = ValidationInfo.getValidationInfo((HttpServletRequest)request);
        if (info != null) {
            return info.getValues(name);
        }
        ValueMap globalFormValues = FormsHelper.getGlobalFormValues(request);
        String[] defaultValues = null;
        String loadPath = (String)properties.get("loadPath", (Object)"");
        if (loadPath.length() > 0) {
            Resource rsrc = request.getResourceResolver().getResource(loadPath);
            if (rsrc != null) {
                defaultValues = (String[])rsrc.adaptTo(String[].class);
            } else if (globalFormValues != null && globalFormValues.get((Object)loadPath) != null) {
                defaultValues = (String[])globalFormValues.get(loadPath, String[].class);
            }
        } else if (globalFormValues != null && globalFormValues.get((Object)name) != null) {
            defaultValues = (String[])globalFormValues.get(name, String[].class);
        }
        if (defaultValues == null) {
            defaultValues = (String[])properties.get("defaultValue", String[].class);
        }
        return defaultValues;
    }

    public static List<String> getValuesAsList(SlingHttpServletRequest request, Resource elementResource) {
        String[] values = FormsHelper.getValues(request, elementResource);
        if (values == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(values);
    }

    public static Map<String, String> getOptions(SlingHttpServletRequest request, Resource elementResource) {
        Resource rsrc;
        ValueMap properties = ResourceUtil.getValueMap((Resource)elementResource);
        String[] options = null;
        String loadPath = (String)properties.get("optionsLoadPath", (Object)"");
        if (loadPath.length() > 0 && (rsrc = request.getResourceResolver().getResource(loadPath)) != null) {
            options = (String[])rsrc.adaptTo(String[].class);
        }
        if (options == null) {
            options = (String[])properties.get("options", String[].class);
        }
        if (options == null) {
            return null;
        }
        LinkedHashMap<String, String> splitValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < options.length; ++i) {
            String t;
            String v;
            String value = options[i].trim();
            if (value.length() <= 0) continue;
            boolean endLoop = true;
            int pos = -1;
            int start = 0;
            do {
                if ((pos = value.indexOf(61, start)) > 0 && value.charAt(pos - 1) == '\\') {
                    start = pos + 1;
                    endLoop = false;
                    continue;
                }
                endLoop = true;
            } while (!endLoop);
            if (pos == -1) {
                v = value;
                t = value;
            } else {
                v = value.substring(0, pos);
                t = value.substring(pos + 1);
            }
            v = v.replace("\\=", "=");
            t = t.replace("\\=", "=");
            splitValues.put(v, t);
        }
        if (splitValues.size() == 0) {
            return null;
        }
        return splitValues;
    }

    public static boolean isRequired(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("required", (Object)Boolean.FALSE);
    }

    public static String getTitle(Resource formElement, String defaultTitle) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (String)properties.get("jcr:title", (Object)defaultTitle);
    }

    public static boolean hasMultiSelection(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("multiSelection", (Object)Boolean.FALSE);
    }

    public static void redirectToReferrer(SlingHttpServletRequest req, SlingHttpServletResponse res, Map<String, String[]> params) throws IOException {
        String referrer;
        String string = referrer = req.getHeader("Referer") != null ? req.getHeader("Referer") : req.getHeader("Referrer");
        if (params != null && params.size() > 0) {
            StringBuffer buffer = new StringBuffer(referrer);
            boolean hasParams = referrer.indexOf(63) > 0;
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                for (String value : entry.getValue()) {
                    buffer.append(hasParams ? (char)'&' : '?');
                    hasParams = true;
                    buffer.append(entry.getKey());
                    buffer.append('=');
                    buffer.append(URLEncoder.encode(value, "utf-8"));
                }
            }
            res.sendRedirect(buffer.toString());
        } else {
            res.sendRedirect(referrer);
        }
    }
}

