/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class ValidationHelper {
    private static final String REQ_ATTR_VALIDATION_INFO = "cq5.form.validationinfo";

    private ValidationHelper() {
    }

    public static ValidationInfo getValidationInfo(SlingHttpServletRequest request) {
        ValidationInfo info = (ValidationInfo)request.getAttribute(REQ_ATTR_VALIDATION_INFO);
        if (info == null) {
            info = new ValidationInfo(FormsHelper.getFormId(request), request.getParameterMap());
            request.setAttribute(REQ_ATTR_VALIDATION_INFO, (Object)info);
        }
        return info;
    }

    public static boolean hasValidationInfo(HttpServletRequest request) {
        ValidationInfo info = (ValidationInfo)request.getAttribute(REQ_ATTR_VALIDATION_INFO);
        return info != null;
    }

    public static String getRequiredMessage(Resource resource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String msg = (String)properties.get("requiredMessage", (Object)"");
        if (msg.length() == 0) {
            msg = "Field is required.";
        }
        return msg;
    }

    public static String getConstraintMessage(Resource resource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String msg = (String)properties.get("constraintMessage", (Object)"");
        if (msg.length() == 0) {
            msg = "Field is not valid.";
        }
        return msg;
    }

    public static boolean checkRequired(SlingHttpServletRequest request, Resource resource) {
        boolean isEmpty;
        String name = FormsHelper.getParameterName(resource);
        String value = request.getParameter(name);
        boolean bl = isEmpty = value == null || value.trim().length() == 0;
        if (FormsHelper.isRequired(resource) && isEmpty) {
            ValidationHelper.getValidationInfo(request).addErrorMessage(name, ValidationHelper.getRequiredMessage(resource));
            return false;
        }
        return true;
    }

    public static void checkConstraint(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) throws IOException, ServletException {
        String constraint;
        boolean isEmpty;
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String name = FormsHelper.getParameterName(resource);
        String value = request.getParameter(name);
        boolean bl = isEmpty = value == null || value.trim().length() == 0;
        if (!isEmpty && (constraint = (String)properties.get("constraintType", (Object)"")).length() > 0) {
            String rt = constraint;
            if (constraint.indexOf(47) == -1) {
                rt = "foundation/components/form/constraints/" + rt;
            }
            ResourceWrapper includeResource = new ResourceWrapper(resource, rt, "foundation/components/form/defaults/constraint");
            FormsHelper.includeResource(request, response, includeResource, "servervalidation");
        }
    }

    public static void writeRequiredCheck(SlingHttpServletRequest request, Resource resource, JspWriter out) throws IOException {
        String formId = FormsHelper.getFormId(request);
        String name = FormsHelper.getParameterName(resource);
        if (FormsHelper.isRequired(resource)) {
            out.print("if (");
            out.print(ValidationHelper.getFormElementQualifier(request, resource));
            out.print(".value.length==0) {");
            out.print(" cq5forms_showMsg('");
            out.print(formId);
            out.print("','");
            out.print(name);
            out.print("','");
            out.print(ValidationHelper.getRequiredMessage(resource));
            out.print("'); return false; }");
        }
    }

    public static String getFormElementQualifier(SlingHttpServletRequest request, Resource resource) {
        String formId = FormsHelper.getFormId(request);
        String name = FormsHelper.getParameterName(resource);
        return "document.forms[\"" + formId + "\"].elements[\"" + name + "\"]";
    }

    public static void writeConstraintCheck(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, JspWriter out) throws IOException, ServletException {
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String constraint = (String)properties.get("constraintType", (Object)"");
        if (constraint.length() > 0) {
            out.flush();
            String rt = constraint;
            if (constraint.indexOf(47) == -1) {
                rt = "foundation/components/form/constraints/" + rt;
            }
            ResourceWrapper includeResource = new ResourceWrapper(resource, rt, "foundation/components/form/defaults/constraint");
            FormsHelper.includeResource(request, response, includeResource, "clientvalidation");
        }
    }

    public static void writeRegexpText(SlingHttpServletRequest request, Resource resource, String regexp, JspWriter out) throws IOException {
        String id = ValidationHelper.getFormElementQualifier(request, resource);
        String name = FormsHelper.getParameterName(resource);
        out.println("{ var result=false;");
        out.print("var pattern = ");
        out.print(regexp);
        out.print("; var t = pattern.exec(");
        out.print(id);
        out.print(".value);");
        out.println("if (t) {");
        out.println("var len = ");
        out.print(id);
        out.print(".value.length;");
        out.println("var pattlen = t[0].length;");
        out.println("result = (pattlen == len); ");
        out.println("}");
        out.println("if ( !result ) {");
        out.print("cq5forms_showMsg('");
        out.print(FormsHelper.getFormId(request));
        out.print("','");
        out.print(name);
        out.print("','");
        out.print(ValidationHelper.getConstraintMessage(resource));
        out.print("');");
        out.println("return false; } }");
    }
}

