/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import com.day.cq.wcm.foundation.impl.HTTPAuthHandler;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.auth.AuthenticationInfo;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoAuthenticationHandler
extends HTTPAuthHandler {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String PROPERTY_HEADERS = "headers";
    public static final String PROPERTY_COOKIES = "cookies";
    public static final String PROPERTY_PARAMETERS = "parameters";
    public static final String PROPERTY_FORMAT = "format";
    public static final String PROPERTY_TRUSTED_CREDENTIALS_ATTRIBUTE = "trustedCredentialsAttribute";
    private static final String FORMAT_BASIC = "Basic";
    private static final String FORMAT_REGEX = "Regex";
    private static final String FORMAT_ASIS = "AsIs";
    private static final String DEFAULT_FORMAT = "Basic";
    private static final String DEFAULT_TRUSTED_CREDENTIALS_ATTRIBUTE = "TrustedInfo";
    private String[] headerNames;
    private String[] cookieNames;
    private String[] parameterNames;
    private String format;
    private Pattern pattern;
    private String trustedCredentialsAttribute;

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        this.headerNames = this.getConfigValues(componentContext, PROPERTY_HEADERS);
        this.cookieNames = this.getConfigValues(componentContext, PROPERTY_COOKIES);
        this.parameterNames = this.getConfigValues(componentContext, PROPERTY_PARAMETERS);
        this.format = OsgiUtil.toString(componentContext.getProperties().get(PROPERTY_FORMAT), (String)"Basic");
        this.trustedCredentialsAttribute = OsgiUtil.toString(componentContext.getProperties().get(PROPERTY_TRUSTED_CREDENTIALS_ATTRIBUTE), (String)DEFAULT_TRUSTED_CREDENTIALS_ATTRIBUTE);
        if (this.format.trim().length() == 0) {
            this.format = "Basic";
        }
        if (this.format.equals(FORMAT_ASIS)) {
            this.format = FORMAT_ASIS;
        } else if (this.format.equals("Basic")) {
            this.format = "Basic";
        } else {
            try {
                this.pattern = Pattern.compile(this.format);
                this.format = FORMAT_REGEX;
            }
            catch (PatternSyntaxException pse) {
                this.logger.error("Unable to parse regexp: - defaulting to basic format!" + this.format, (Throwable)pse);
                this.format = "Basic";
            }
        }
        this.logger.debug("SSO Authentication Handler configured with header names: {}, cookie names: {}, parameter names: {}, header format: {}, trusted credential attribute: {}", new Object[]{Arrays.toString(this.headerNames), Arrays.toString(this.cookieNames), Arrays.toString(this.parameterNames), this.format == FORMAT_REGEX ? "Regex: " + this.pattern.pattern() : this.format, this.trustedCredentialsAttribute});
    }

    protected void deactivate(ComponentContext componentContext) {
        this.headerNames = null;
        this.cookieNames = null;
        this.parameterNames = null;
    }

    private String[] getConfigValues(ComponentContext componentContext, String propName) {
        String[] values = OsgiUtil.toStringArray(componentContext.getProperties().get(propName));
        if (values != null && values.length == 1 && values[0].trim().length() == 0) {
            values = null;
        }
        return values;
    }

    public AuthenticationInfo authenticate(HttpServletRequest request, HttpServletResponse response) {
        SSOInfo ssoInfo = this.getSsoUid(request);
        if (ssoInfo != null) {
            String uid = ssoInfo.ssoUid;
            if (this.format == "Basic") {
                String[] values = this.decodeAuthorizationHeader(uid);
                if (values == null || values.length == 0) {
                    this.log.info("Unable to decode authorization header {}", (Object)uid);
                    return null;
                }
                uid = values[0];
            } else if (this.format == FORMAT_REGEX) {
                Matcher matcher = this.pattern.matcher(uid);
                if (matcher.matches()) {
                    uid = matcher.group(matcher.groupCount() > 0 ? 1 : 0);
                } else {
                    this.log.info("Value {} does not match expression {}.", (Object)uid, (Object)this.pattern.pattern());
                    return null;
                }
            }
            this.log.debug("accepting trusted credentials, uid={} found in {}", (Object)uid, (Object)ssoInfo.providerId);
            SimpleCredentials credentials = new SimpleCredentials(uid, "no_password_needed".toCharArray());
            credentials.setAttribute(this.trustedCredentialsAttribute, (Object)ssoInfo.providerId);
            AuthenticationInfo info = new AuthenticationInfo("SSO", (Credentials)credentials);
            return info;
        }
        return super.authenticate(request, response);
    }

    private SSOInfo getSsoUid(HttpServletRequest request) {
        SSOInfo ssoInfo = this.getSsoUidFromHeader(request);
        if (ssoInfo != null) {
            return ssoInfo;
        }
        ssoInfo = this.getSsoUidFromCookie(request);
        if (ssoInfo != null) {
            return ssoInfo;
        }
        ssoInfo = this.getSsoUidFromParameter(request);
        if (ssoInfo != null) {
            return ssoInfo;
        }
        return null;
    }

    private SSOInfo getSsoUidFromHeader(HttpServletRequest request) {
        if (this.headerNames != null) {
            for (int i = 0; i < this.headerNames.length; ++i) {
                String value = request.getHeader(this.headerNames[i]);
                if (value == null) continue;
                this.log.debug("found header {}={}", (Object)this.headerNames[i], (Object)value);
                return new SSOInfo(value, "header", this.headerNames[i]);
            }
        }
        return null;
    }

    private SSOInfo getSsoUidFromParameter(HttpServletRequest request) {
        if (this.parameterNames != null) {
            for (int i = 0; i < this.parameterNames.length; ++i) {
                String value = request.getParameter(this.parameterNames[i]);
                if (value == null) continue;
                this.log.debug("found parameter {}={}", (Object)this.parameterNames[i], (Object)value);
                return new SSOInfo(value, "parameter", this.parameterNames[i]);
            }
        }
        return null;
    }

    private SSOInfo getSsoUidFromCookie(HttpServletRequest request) {
        Cookie[] cookies;
        if (this.cookieNames != null && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < this.cookieNames.length; ++i) {
                for (int j = 0; j < cookies.length; ++j) {
                    if (!this.cookieNames[i].equalsIgnoreCase(cookies[j].getName())) continue;
                    this.log.debug("found cookie {}={}", (Object)this.cookieNames[i], (Object)cookies[j].getValue());
                    String value = cookies[j].getValue();
                    try {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                    return new SSOInfo(value, "cookie", this.cookieNames[i]);
                }
            }
        }
        return null;
    }

    private String[] decodeAuthorizationHeader(String authHeader) {
        String decoded;
        String[] parts = Text.explode((String)authHeader, (int)32);
        if (parts.length < 2) {
            this.log.info("decodeAuthorizationHeader: Not a valid Authorization header {}", (Object)authHeader);
            return null;
        }
        String authType = parts[0];
        String authInfo = parts[1];
        if (!authType.equalsIgnoreCase("Basic")) {
            this.log.info("decodeAuthorizationHeader: Unsupported HTTP authentication scheme {}", (Object)authType);
            return null;
        }
        try {
            byte[] encoded = authInfo.getBytes("ISO-8859-1");
            byte[] bytes = Base64.decodeBase64((byte[])encoded);
            decoded = new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            this.log.error("decodeAuthorizationHeader: Cannot en/decode authentication info", (Throwable)uee);
            return null;
        }
        if (decoded.indexOf(58) == -1) {
            return new String[]{decoded};
        }
        return Text.explode((String)decoded, (int)58, (boolean)true);
    }

    protected static final class SSOInfo {
        public String ssoUid;
        public String providerId;

        public SSOInfo(String id, String provider, String name) {
            this.ssoUid = id;
            this.providerId = provider + ':' + name;
        }
    }
}

