/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.search.Hit;
import com.day.cq.search.Search;
import com.day.cq.search.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.foundation.ParagraphSystem;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List {
    public static final Logger log = LoggerFactory.getLogger(ParagraphSystem.class);
    public static final String URL_EXTENSION = ".html";
    public static final String QUERY_PROPERTY_NAME = "query";
    public static final String SEARCH_IN_PROPERTY_NAME = "searchIn";
    public static final String LIMIT_PROPERTY_NAME = "limit";
    public static final String ORDERED_PROPERTY_NAME = "ordered";
    private Search search = null;
    private String query = "";
    private String searchIn = "";
    private long limit = 100L;
    private boolean ordered = false;

    public List(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        this.search = (Search)resource.adaptTo(Search.class);
        this.query = (String)properties.get(QUERY_PROPERTY_NAME, (Object)"");
        this.searchIn = (String)properties.get(SEARCH_IN_PROPERTY_NAME, (Object)Text.getAbsoluteParent((String)resource.getPath(), (int)1));
        this.limit = ((Integer)properties.get(LIMIT_PROPERTY_NAME, (Object)100)).intValue();
        this.ordered = (Boolean)properties.get(ORDERED_PROPERTY_NAME, (Object)false);
    }

    public java.util.List<Item> getItems(String searchQuery) {
        this.search.setQuery(searchQuery != null ? searchQuery : this.query);
        this.search.setSearchIn(this.searchIn);
        this.search.setHitsPerPage(this.limit);
        try {
            ArrayList<Item> items = new ArrayList<Item>();
            SearchResult result = this.search.getResult();
            for (Hit hit : result.getHits()) {
                items.add(new Item(hit));
            }
            return Collections.unmodifiableList(items);
        }
        catch (RepositoryException re) {
            log.error("error building list items", (Throwable)re);
            return null;
        }
    }

    public java.util.List<Item> getItems() {
        return this.getItems(null);
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public class Item {
        Resource resource = null;
        ValueMap properties = null;
        String path = "";
        String title = "";
        String description = "";
        String icon = null;

        public Item(Hit hit) {
            try {
                this.resource = hit.getResource();
                this.properties = ((Page)this.resource.adaptTo(Page.class)).getProperties();
                this.path = hit.getPath();
                this.title = hit.getTitle();
                this.description = hit.getExcerpt();
            }
            catch (RepositoryException re) {
                log.error("error building list item", (Throwable)re);
            }
        }

        public Resource getResource() {
            return this.resource;
        }

        public ValueMap getProperties() {
            return this.properties;
        }

        public String getUrl() {
            return this.path + List.URL_EXTENSION;
        }

        public String getPath() {
            return this.path;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

