/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.search.ResultPage;
import com.day.cq.search.SearchResult;
import com.day.cq.search.Trends;
import com.day.cq.search.facets.Facet;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Search {
    public static final String QUERY_PARAM_NAME = "q";
    public static final String START_PARAM_NAME = "start";
    public static final String LANGUAGE_FACET_PARAM_NAME = "language";
    public static final String TAG_FACET_PARAM_NAME = "tag";
    public static final String MIME_TYPE_FACET_PARAM_NAME = "mimeType";
    public static final String FROM_FACET_PARAM_NAME = "from";
    public static final String TO_FACET_PARAM_NAME = "to";
    private static final String HTML_EXT = "html";
    private final SlingHttpServletRequest request;
    private final com.day.cq.search.Search search;
    private final Resource resource;
    private Result result;
    private List<Page> resultPages;

    public Search(SlingHttpServletRequest request) {
        this.request = request;
        this.resource = request.getResource();
        this.search = (com.day.cq.search.Search)this.resource.adaptTo(com.day.cq.search.Search.class);
        if (request.getParameter(QUERY_PARAM_NAME) != null) {
            try {
                this.search.setQuery(new String(request.getParameter(QUERY_PARAM_NAME).getBytes("ISO-8859-1"), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (request.getParameter(START_PARAM_NAME) != null) {
            try {
                this.search.setStart(Long.parseLong(request.getParameter(START_PARAM_NAME)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.search.setFacetFilterClause(this.getFacetFilterClause());
        if (request.getParameter(LANGUAGE_FACET_PARAM_NAME) != null) {
            String lang = request.getParameter(LANGUAGE_FACET_PARAM_NAME);
            this.search.setSearchIn(Text.getAbsoluteParent((String)this.resource.getPath(), (int)1) + "/" + lang);
        }
    }

    public Trends getTrends() {
        return this.search.getTrends();
    }

    public Result getResult() throws RepositoryException {
        if (this.result == null && this.search.getResult() != null) {
            this.result = new Result(this.search.getResult());
        }
        return this.result;
    }

    public List<String> getRelatedQueries() throws RepositoryException {
        return this.search.getRelatedQueries();
    }

    public String getQuery() {
        return this.search.getQuery();
    }

    public void setQuery(String query) {
        this.search.setQuery(query);
    }

    public String getExcerptPropertyNames() {
        return this.search.getExcerptPropertyNames();
    }

    public void setExcerptPropertyNames(String properties) {
        this.search.setExcerptPropertyNames(properties);
    }

    public long getHitsPerPage() {
        return this.search.getHitsPerPage();
    }

    public void setHitsPerPage(long num) {
        this.search.setHitsPerPage(num);
    }

    public String getSearchIn() {
        return this.search.getSearchIn();
    }

    public void setSearchIn(String searchIn) {
        this.search.setSearchIn(searchIn);
    }

    public String getSearchProperties() {
        return this.search.getSearchProperties();
    }

    public void setSearchProperties(String properties) {
        this.search.setSearchProperties(properties);
    }

    private static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private String getIconPath(String extension) {
        Component c = WCMUtils.getComponent((Resource)this.resource);
        if (c == null) {
            return null;
        }
        Resource icon = c.getLocalResource("resources/" + extension + ".gif");
        if (icon == null) {
            icon = c.getLocalResource("resources/default.gif");
        }
        return icon == null ? null : icon.getPath();
    }

    private String getFacetFilterClause() {
        try {
            StringBuffer buffer = new StringBuffer();
            this.appendFacetFilters(buffer);
            return buffer.toString();
        }
        catch (RepositoryException e) {
            return "";
        }
    }

    private void appendFacetFilters(StringBuffer stmt) throws RepositoryException {
        Calendar cal;
        ValueFactory vf;
        this.appendConstraints(stmt, "jcr:content/@cq:tags", this.request.getParameterValues(TAG_FACET_PARAM_NAME));
        this.appendConstraints(stmt, "jcr:content/@jcr:mimeType", this.request.getParameterValues(MIME_TYPE_FACET_PARAM_NAME));
        if (this.request.getParameter(FROM_FACET_PARAM_NAME) != null) {
            vf = ((Node)this.resource.adaptTo(Node.class)).getSession().getValueFactory();
            try {
                long from = Long.parseLong(this.request.getParameter(FROM_FACET_PARAM_NAME));
                cal = vf.createValue(from).getDate();
                stmt.append(" and ");
                stmt.append("jcr:content").append("/@");
                stmt.append("cq:lastModified").append(" >= xs:dateTime('");
                stmt.append(vf.createValue(cal).getString());
                stmt.append("')");
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.request.getParameter(TO_FACET_PARAM_NAME) != null) {
            vf = ((Node)this.resource.adaptTo(Node.class)).getSession().getValueFactory();
            try {
                long to = Long.parseLong(this.request.getParameter(TO_FACET_PARAM_NAME));
                cal = vf.createValue(to).getDate();
                stmt.append(" and ");
                stmt.append("jcr:content").append("/@");
                stmt.append("cq:lastModified").append(" < xs:dateTime('");
                stmt.append(vf.createValue(cal).getString());
                stmt.append("')");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void appendConstraints(StringBuffer stmt, String relPath, String[] values) {
        if (values != null) {
            for (String v : values) {
                stmt.append(" and ");
                stmt.append(relPath).append(" = '");
                stmt.append(v).append("'");
            }
        }
    }

    public final class Page {
        private final ResultPage rp;

        private Page(ResultPage rp) {
            this.rp = rp;
        }

        public boolean isCurrentPage() {
            return this.rp.isCurrentPage();
        }

        public long getIndex() {
            return this.rp.getIndex();
        }

        public String getURL() {
            StringBuffer url = new StringBuffer();
            url.append(Search.this.request.getRequestURI());
            url.append("?").append(Search.QUERY_PARAM_NAME);
            url.append("=").append(Search.encodeURL(Search.this.search.getQuery()));
            url.append("&").append(Search.START_PARAM_NAME);
            url.append("=").append(this.rp.getStart());
            return url.toString();
        }
    }

    public final class Hit {
        private final com.day.cq.search.Hit hit;

        private Hit(com.day.cq.search.Hit hit) {
            this.hit = hit;
        }

        public String getTitle() throws RepositoryException {
            return this.hit.getTitle();
        }

        public String getExcerpt() throws RepositoryException {
            return this.hit.getExcerpt();
        }

        public String getURL() throws RepositoryException {
            String url = Search.this.request.getContextPath() + this.hit.getPath();
            int idx = url.indexOf(46, url.lastIndexOf(47));
            if (idx == -1) {
                url = url + ".html";
            }
            return url;
        }

        public String getSimilarURL() throws RepositoryException {
            StringBuffer url = new StringBuffer();
            url.append(Search.this.request.getRequestURI());
            url.append("?").append(Search.QUERY_PARAM_NAME);
            url.append("=").append("related:");
            url.append(Search.encodeURL(this.hit.getPath()));
            return url.toString();
        }

        public String getIcon() throws RepositoryException {
            String url = this.getURL();
            int idx = url.lastIndexOf(46);
            if (idx == -1) {
                return "";
            }
            String ext = url.substring(idx + 1);
            if (ext.equals(Search.HTML_EXT)) {
                return "";
            }
            String path = Search.this.getIconPath(ext);
            if (path == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<img src='");
            sb.append(Search.this.request.getContextPath());
            sb.append(path).append("'/>");
            return sb.toString();
        }

        public Map getProperties() throws RepositoryException {
            return this.hit.getProperties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Result {
        private final SearchResult result;
        private final List<Hit> hits;

        private Result(SearchResult result) {
            this.result = result;
            this.hits = new ArrayList<Hit>();
            for (com.day.cq.search.Hit h : result.getHits()) {
                this.hits.add(new Hit(h));
            }
        }

        public List<Page> getResultPages() throws RepositoryException {
            if (Search.this.resultPages == null) {
                Search.this.resultPages = new ArrayList();
                for (ResultPage rp : Search.this.search.getResult().getResultPages()) {
                    Search.this.resultPages.add(new Page(rp));
                }
            }
            return Search.this.resultPages;
        }

        public Page getPreviousPage() throws RepositoryException {
            ResultPage previous = Search.this.search.getResult().getPreviousPage();
            if (previous != null) {
                return new Page(previous);
            }
            return null;
        }

        public Page getNextPage() throws RepositoryException {
            ResultPage next = Search.this.search.getResult().getNextPage();
            if (next != null) {
                return new Page(next);
            }
            return null;
        }

        public String getTrackerScript() {
            StringBuffer sb = new StringBuffer();
            String contextPath = Search.this.request.getContextPath();
            sb.append("<script type='text/javascript'>");
            if (!Search.this.search.getQuery().startsWith("related:")) {
                sb.append("var trackim=new Image();");
                sb.append("trackim.src='").append(contextPath);
                sb.append("/bin/statistics/tracker/query");
                sb.append("?q=").append(Search.encodeURL(Search.this.search.getQuery()));
                sb.append("&nr=").append(this.getTotalMatches());
                sb.append("&et=").append(this.getExecutionTimeMillis());
                sb.append("&").append(System.currentTimeMillis()).append("';\n");
            }
            sb.append("function trackSelectedResult(obj, position, query) {\n");
            sb.append("  var trackim=new Image();\n");
            sb.append("  var regExp = /^((\\w+):\\/\\/\\/?)?((\\w+):?(\\w+)?@)?([^\\/\\?:]+):?(\\d+)?(\\/?[^\\?#;\\|]+)?([;\\|])?([^\\?#]+)?\\??([^#]+)?#?(\\w*)/;\n");
            sb.append("  var uri = regExp.exec(obj.href);\n");
            sb.append("  var imgSrc = '").append(contextPath).append("/bin/statistics/tracker/result?p=';\n");
            sb.append("  imgSrc += encodeURIComponent(uri[8].substring(");
            sb.append(contextPath.length()).append(", uri[8].lastIndexOf('.')));\n");
            sb.append("  imgSrc += '&po=' + position + '&q=");
            sb.append(Search.encodeURL(Search.this.search.getQuery()));
            sb.append("&' + Math.random();\n");
            sb.append("  trackim.src = imgSrc;\n");
            sb.append("}");
            sb.append("</script>");
            return sb.toString();
        }

        public String getSpellcheck() {
            return this.result.getSpellcheck();
        }

        public long getStartIndex() {
            return this.result.getStartIndex();
        }

        public long getTotalMatches() {
            return this.result.getTotalMatches();
        }

        public String getExecutionTime() {
            return this.result.getExecutionTime();
        }

        public long getExecutionTimeMillis() {
            return this.result.getExecutionTimeMillis();
        }

        public Map<String, Facet> getFacets() throws RepositoryException {
            return this.result.getFacets();
        }

        public List<Hit> getHits() {
            return this.hits;
        }
    }
}

