/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsHandlingServlet
extends SlingAllMethodsServlet
implements OptingServlet {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "form";

    public boolean accepts(SlingHttpServletRequest request) {
        return EXTENSION.equals(request.getRequestPathInfo().getExtension()) && SELECTOR.equals(request.getRequestPathInfo().getSelectorString());
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String actionType;
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            this.logger.debug("Received fake request!");
            response.setStatus(500);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)request.getResource().getPath());
        }
        ValidationInfo info = this.validate(request, response, request.getResource());
        ValueMap properties = ResourceUtil.getValueMap((Resource)request.getResource());
        String string = actionType = properties == null ? "" : (String)properties.get("actionType", (Object)"");
        if (actionType.length() == 0) {
            ValidationHelper.getValidationInfo(request).addErrorMessage(null, "Unable to process the form.");
            info = ValidationHelper.getValidationInfo(request);
        }
        if (info != null) {
            this.logger.debug("Form {} is not valid: {}", (Object)request.getResource().getPath(), (Object)info);
            response.sendRedirect(ValidationInfo.getValidationInfoUri(request.getHeader("Referer"), info));
            return;
        }
        String rt = actionType;
        if (actionType.indexOf(47) == -1) {
            rt = "foundation/components/form/actions/" + rt;
        }
        ResourceWrapper includeResource = new ResourceWrapper(request.getResource(), rt, "foundation/components/form/defaults/action");
        FormsHelper.includeResource(request, response, includeResource, "forward");
        String forwardPath = FormsHelper.getForwardPath(request);
        if (forwardPath != null && forwardPath.length() > 0) {
            Resource forwardResource;
            if (forwardPath.endsWith("/")) {
                forwardPath = forwardPath + '*';
            }
            if ((forwardResource = request.getResourceResolver().resolve(forwardPath)) == null) {
                forwardResource = new NonExistingResource(request.getResourceResolver(), forwardPath);
            }
            request.getRequestDispatcher(forwardResource).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        FormsHelper.includeResource(request, response, includeResource, "post");
    }

    private ValidationInfo validate(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource formResource) throws ServletException, IOException {
        Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
        while (iter.hasNext()) {
            Resource element = iter.next();
            FormsHelper.includeResource(request, response, element, "servervalidation");
        }
        return ValidationHelper.hasValidationInfo((HttpServletRequest)request) ? ValidationHelper.getValidationInfo(request) : null;
    }
}

