/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.foundation.TableCSVBuilder;
import com.day.cq.wcm.foundation.TableXMLBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private LinkedList<Row> rows = new LinkedList();
    private LinkedList<Column> cols = new LinkedList();
    private Cell[][] data = new Cell[8][8];
    private Tag caption;
    private List<ColTag> colTags = new LinkedList<ColTag>();
    private Attributes attributes = new Attributes();

    public List<ColTag> getColTags() {
        return this.colTags;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Table setAttribute(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    public Tag getCaption() {
        return this.caption;
    }

    public Tag setCaption(String text) {
        if (this.caption == null) {
            this.caption = new Tag("caption");
        }
        this.caption.setInnerHtml(text);
        return this.caption;
    }

    public Cell getCell(int row, int col, boolean create) {
        Cell cell = null;
        if (row >= this.rows.size() || col >= this.cols.size()) {
            if (create) {
                this.setSize(Math.max(row + 1, this.rows.size()), Math.max(col + 1, this.cols.size()));
                cell = this.data[row][col];
            }
        } else {
            cell = this.data[row][col];
        }
        return cell;
    }

    public int[][] getIntData(int rowStart, int numRows, int colStart, int numCols) {
        if (rowStart + numRows > this.rows.size()) {
            numRows = this.rows.size() - rowStart;
        }
        if (colStart + numCols > this.cols.size()) {
            numCols = this.cols.size() - colStart;
        }
        int[][] ret = new int[numRows][numCols];
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                ret[r][c] = this.data[r + rowStart][c + colStart].getIntValue();
            }
        }
        return ret;
    }

    public int[][] getIntData() {
        return this.getIntData(0, this.rows.size(), 0, this.cols.size());
    }

    public double[][] getDoubleData(int rowStart, int numRows, int colStart, int numCols) {
        if (rowStart + numRows > this.rows.size()) {
            numRows = this.rows.size() - rowStart;
        }
        if (colStart + numCols > this.cols.size()) {
            numCols = this.cols.size() - colStart;
        }
        double[][] ret = new double[numRows][numCols];
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                ret[r][c] = this.data[r + rowStart][c + colStart].getDoubleValue();
            }
        }
        return ret;
    }

    public double[][] getDoubleData() {
        return this.getDoubleData(0, this.rows.size(), 0, this.cols.size());
    }

    public void setSize(int numRows, int numCols) {
        if (numRows >= this.data.length || numCols >= this.data[0].length) {
            Cell[][] newData = new Cell[this.data.length * 2][this.data[0].length * 2];
            for (int r = 0; r < this.rows.size(); ++r) {
                System.arraycopy(this.data[r], 0, newData[r], 0, this.cols.size());
            }
            this.data = newData;
        }
        while (this.rows.size() < numRows) {
            Row row = new Row(this.rows.size());
            this.rows.add(row);
            for (Column col : this.cols) {
                this.data[((Row)row).nr][((Column)col).nr] = new Cell(row, col);
            }
        }
        while (this.rows.size() > numRows) {
            this.rows.removeLast();
        }
        while (this.cols.size() < numCols) {
            Column col = new Column(this.cols.size());
            this.cols.add(col);
            for (Row row : this.rows) {
                this.data[((Row)row).nr][((Column)col).nr] = new Cell(row, col);
            }
        }
        while (this.cols.size() > numCols) {
            this.cols.removeLast();
        }
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.cols);
    }

    public Row getRow(int nr) {
        return nr < this.rows.size() ? null : this.rows.get(nr);
    }

    public Column getColumn(int nr) {
        return nr < this.cols.size() ? null : this.cols.get(nr);
    }

    public int getNumCols() {
        return this.cols.size();
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public void clear() {
        this.rows.clear();
        this.cols.clear();
    }

    public static Table fromXML(String s) {
        try {
            return Table.fromXML(new StringReader(s));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Table fromXML(Reader r) throws IOException {
        return new TableXMLBuilder().parse(r);
    }

    public static Table fromCSV(String s) {
        return new TableCSVBuilder().parse(s);
    }

    public static Table fromCSV(String s, char delim) {
        return new TableCSVBuilder(delim).parse(s);
    }

    public void toHtml(Writer out) throws IOException {
        out.write("<table");
        this.attributes.toHtml(out);
        out.write(">\n");
        if (this.caption != null) {
            this.caption.toHtml(out);
            out.write("\n");
        }
        for (ColTag cg : this.colTags) {
            cg.toHtml(out);
            out.write("\n");
        }
        for (Row row : this.rows) {
            out.write("<tr>");
            for (Column col : this.cols) {
                Cell cell = this.data[row.nr][col.nr];
                if (cell.getSpanSource() != null) continue;
                this.data[row.nr][col.nr].toHtml(out);
            }
            out.write("</tr>\n");
        }
        out.write("</table>\n");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attributes
    extends HashMap<String, String> {
        public void toHtml(Writer out) throws IOException {
            for (Map.Entry e : this.entrySet()) {
                out.write(" ");
                out.write((String)e.getKey());
                out.write("=\"");
                StringEscapeUtils.escapeHtml((Writer)out, (String)((String)e.getValue()));
                out.write("\"");
            }
        }
    }

    public static class ColTag
    extends Tag {
        public ColTag() {
            super("col");
        }

        public Tag setInnerHtml(String innerHtml) {
            return this;
        }
    }

    public static class Tag {
        protected final String name;
        protected final Attributes attrs = new Attributes();
        protected String innerHtml;

        public Tag(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getInnerHtml() {
            return this.innerHtml;
        }

        public Tag setInnerHtml(String innerHtml) {
            this.innerHtml = innerHtml;
            return this;
        }

        public Tag appendInnerHtml(char[] ch, int offset, int len) {
            this.innerHtml = this.innerHtml == null ? new String(ch, offset, len) : this.innerHtml + new String(ch, offset, len);
            return this;
        }

        public Attributes getAttributes() {
            return this.attrs;
        }

        public Tag setAttribute(String name, String value) {
            if (value == null) {
                this.attrs.remove(name);
            } else {
                this.attrs.put(name, value);
            }
            return this;
        }

        public void toHtml(Writer out) throws IOException {
            out.write("<");
            out.write(this.name);
            if (this.attrs != null) {
                this.attrs.toHtml(out);
            }
            out.write(">");
            if (this.innerHtml != null) {
                out.write(this.innerHtml);
                out.write("</");
                out.write(this.name);
                out.write(">");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cell {
        private Row row;
        private Column col;
        private String text;
        private Attributes attributes;
        private boolean header;
        private int colSpan = 1;
        private int rowSpan = 1;
        private Cell spanSource;

        private Cell(Row row, Column col) {
            this.row = row;
            this.col = col;
        }

        public Row getRow() {
            return this.row;
        }

        public Column getCol() {
            return this.col;
        }

        public Cell getSpanSource() {
            return this.spanSource;
        }

        public String getText() {
            return this.text;
        }

        public Cell appendText(char[] ch, int offset, int len) {
            this.text = this.text == null ? new String(ch, offset, len) : this.text + new String(ch, offset, len);
            return this;
        }

        public int getIntValue() {
            try {
                return this.text == null ? 0 : Integer.parseInt(this.text);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public double getDoubleValue() {
            try {
                return this.text == null ? 0.0 : Double.parseDouble(this.text);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }

        public int getColSpan() {
            return this.colSpan;
        }

        public boolean isInSpan() {
            return this.spanSource != null;
        }

        private Table getTable() {
            return this.row.getTable();
        }

        public Cell setColSpan(int colSpan) {
            if (colSpan == 0) {
                colSpan = 1;
            }
            this.internalSetSpans(this.rowSpan, colSpan);
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (colSpan > 1) {
                this.attributes.put("colspan", String.valueOf(this.colSpan));
            } else {
                this.attributes.remove("colspan");
            }
            return this;
        }

        public int getRowSpan() {
            return this.rowSpan;
        }

        public Cell setRowSpan(int rowSpan) {
            if (rowSpan == 0) {
                rowSpan = 1;
            }
            this.internalSetSpans(rowSpan, this.colSpan);
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (rowSpan > 1) {
                this.attributes.put("rowspan", String.valueOf(this.rowSpan));
            } else {
                this.attributes.remove("rowspan");
            }
            return this;
        }

        private void internalSetSpans(int rSpan, int cSpan) {
            int c;
            int r;
            Table table = this.getTable();
            int rowNr = this.row.getNr();
            int colNr = this.col.getNr();
            for (r = 0; r < this.rowSpan; ++r) {
                for (c = 0; c < this.colSpan; ++c) {
                    table.getCell((int)(rowNr + r), (int)(colNr + c), (boolean)false).spanSource = null;
                }
            }
            this.rowSpan = rSpan;
            this.colSpan = cSpan;
            for (r = 0; r < this.rowSpan; ++r) {
                for (c = 0; c < this.colSpan; ++c) {
                    if (r + c <= 0) continue;
                    table.getCell((int)(rowNr + r), (int)(colNr + c), (boolean)true).spanSource = this;
                }
            }
        }

        public Cell setText(CharSequence text) {
            this.text = ((Object)text).toString();
            return this;
        }

        public boolean isHeader() {
            return this.header;
        }

        public Cell setHeader(boolean header) {
            this.header = header;
            return this;
        }

        public String getAttribute(String name) {
            if (this.attributes == null) {
                return null;
            }
            return (String)this.attributes.get(name);
        }

        public Cell setAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            this.attributes.put(name, value);
            if (name.equalsIgnoreCase("colspan")) {
                this.setColSpan(Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("rowspan")) {
                this.setRowSpan(Integer.parseInt(value));
            }
            return this;
        }

        public Cell clearAttributes() {
            this.attributes = null;
            this.internalSetSpans(1, 1);
            return this;
        }

        public Map<String, String> getAttributes() {
            if (this.attributes == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.attributes);
        }

        public void toHtml(Writer out) throws IOException {
            String tag = this.header ? "th" : "td";
            out.write("<");
            out.write(tag);
            if (this.attributes != null) {
                this.attributes.toHtml(out);
            }
            out.write(">");
            if (this.text != null) {
                out.write(this.text);
            }
            out.write("</");
            out.write(tag);
            out.write(">");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Column {
        private int nr;

        private Column(int nr) {
            this.nr = nr;
        }

        public int getNr() {
            return this.nr;
        }

        public boolean isFirst() {
            return this.nr == 0;
        }

        public boolean isLast() {
            return this.nr == Table.this.cols.size() - 1;
        }

        public Table getTable() {
            return Table.this;
        }

        public List<Cell> getCells() {
            ArrayList<Cell> cells = new ArrayList<Cell>(Table.this.rows.size());
            for (int r = 0; r < Table.this.rows.size(); ++r) {
                Cell cell = Table.this.data[r][this.nr];
                if (cell.isInSpan()) continue;
                cells.add(cell);
            }
            return cells;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Row {
        private int nr;

        private Row(int nr) {
            this.nr = nr;
        }

        public int getNr() {
            return this.nr;
        }

        public boolean isFirst() {
            return this.nr == 0;
        }

        public boolean isLast() {
            return this.nr == Table.this.rows.size() - 1;
        }

        public Table getTable() {
            return Table.this;
        }

        public List<Cell> getCells() {
            ArrayList<Cell> cells = new ArrayList<Cell>(Table.this.cols.size());
            for (int c = 0; c < Table.this.cols.size(); ++c) {
                Cell cell = Table.this.data[this.nr][c];
                if (cell.isInSpan()) continue;
                cells.add(cell);
            }
            return cells;
        }

        public Row setHeader(boolean header) {
            for (Cell c : this.getCells()) {
                c.setHeader(header);
            }
            return this;
        }
    }
}

