/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)FormsHelper.class.getName());
    public static final String REQ_ATTR_GLOBAL_LOAD_RSRC = "cq.form.loadmap";
    public static final String REQ_ATTR_CLIENT_VALIDATION = "cq.form.clientvalidation";
    public static final String REQ_ATTR_FORMID = "cq.form.id";
    public static final String REQ_ATTR_WRITTEN_JAVASCRIPT = "cq.form.javascript";
    public static final String REQ_ATTR_FORWARD_PATH = "cq.form.forward.path";
    public static final String REQ_ATTR_IS_INIT = "cq.form.init";

    private FormsHelper() {
    }

    public static void startForm(SlingHttpServletRequest req, SlingHttpServletResponse response, JspWriter out) throws IOException, ServletException {
        Resource resource = req.getResource();
        FormsHelper.initialize(req, resource, response, out);
        FormsHelper.writeJavaScript(req, response, resource, out);
        String formId = FormsHelper.getFormId(req);
        PageManager pageManager = (PageManager)req.getResourceResolver().adaptTo(PageManager.class);
        Page resourcePage = pageManager.getContainingPage(resource);
        out.print("<form method=\"POST\" action=\"");
        out.print(resourcePage.getPath());
        for (String sel : req.getRequestPathInfo().getSelectors()) {
            out.print('.');
            out.print(sel);
        }
        if (req.getRequestPathInfo().getExtension() != null) {
            out.print('.');
            out.print(req.getRequestPathInfo().getExtension());
        }
        out.print("\" id=\"");
        out.print(formId);
        out.print("\" name=\"");
        out.print(formId);
        out.print("\" enctype=\"multipart/form-data\">");
        out.print("<input type=\"hidden\" name=\"");
        out.print(":formid");
        out.print("\" value=\"");
        out.print(formId);
        out.print("\"/>");
        out.print("<input type=\"hidden\" name=\"");
        out.print(":formstart");
        out.print("\" value=\"");
        out.print(resource.getPath().substring(resourcePage.getPath().length() + 1));
        out.print("\"/>");
        out.print("<input type=\"hidden\" name=\"_charset_\" value=\"UTF-8\"/>");
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String redirect = (String)properties.get("redirect", (Object)"");
        if (redirect.length() > 0) {
            int lastSlash;
            if (redirect.startsWith("/") && req.getContextPath() != null && req.getContextPath().length() > 0 && !redirect.startsWith(req.getContextPath())) {
                redirect = req.getContextPath() + redirect;
            }
            if (redirect.indexOf(46, lastSlash = redirect.lastIndexOf(47)) == -1) {
                redirect = redirect + ".html";
            }
            out.print("<input type=\"hidden\" name=\":redirect\" value=\"");
            out.print(redirect);
            out.print("\"/>");
        }
    }

    private static void initialize(SlingHttpServletRequest request, Resource formResource, SlingHttpServletResponse response, JspWriter out) throws IOException, ServletException {
        String actionType;
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        Boolean clientValidation = (Boolean)properties.get("clientValidation", (Object)Boolean.FALSE);
        request.setAttribute(REQ_ATTR_CLIENT_VALIDATION, (Object)clientValidation);
        request.setAttribute(REQ_ATTR_FORMID, properties.get("formid", (Object)"new_form"));
        request.setAttribute(REQ_ATTR_IS_INIT, (Object)"true");
        if (response != null && (actionType = (String)properties.get("actionType", (Object)"foundation/components/form/actions/store")).length() != 0) {
            out.flush();
            String rt = actionType;
            if (actionType.indexOf(47) == -1) {
                rt = "foundation/components/form/actions/" + rt;
            }
            ResourceWrapper includeResource = new ResourceWrapper(formResource, rt, "foundation/components/form/defaults/action");
            FormsHelper.includeResource(request, response, includeResource, "init");
        }
        if (request.getAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC) == null) {
            Resource loadResource = null;
            String loadPath = (String)properties.get("loadPath", (Object)"");
            if (loadPath.length() > 0) {
                loadResource = formResource.getResourceResolver().getResource(loadPath);
            }
            FormsHelper.setFormLoadResource(request, loadResource);
        }
    }

    private static void checkInit(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR_IS_INIT) == null) {
            Resource formStart = FormsHelper.searchFormStart(request.getResource());
            try {
                FormsHelper.initialize(request, formStart, null, null);
            }
            catch (IOException e) {
            }
            catch (ServletException servletException) {
                // empty catch block
            }
        }
    }

    private static Resource searchFormStart(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (FormsHelper.checkResourceType(resource, "foundation/components/form/start")) {
            return resource;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            if (!FormsHelper.checkResourceType(current, "foundation/components/form/start")) continue;
            return current;
        }
        return FormsHelper.searchFormStart(parent);
    }

    private static boolean checkResourceType(Resource resource, String type) {
        return type.equals(resource.getResourceType()) || type.equals(resource.getResourceSuperType());
    }

    public static void endForm(SlingHttpServletRequest req) {
        FormsHelper.setFormLoadResource(req, null);
        req.removeAttribute(REQ_ATTR_CLIENT_VALIDATION);
        req.removeAttribute(REQ_ATTR_FORMID);
        req.removeAttribute(REQ_ATTR_IS_INIT);
    }

    public static void setForwardPath(SlingHttpServletRequest req, String path) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, (Object)path);
    }

    public static String getForwardPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_FORWARD_PATH);
    }

    public static void setFormLoadResource(SlingHttpServletRequest req, Resource rsrc) {
        req.removeAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC);
        if (rsrc != null) {
            ValueMap map = ResourceUtil.getValueMap((Resource)rsrc);
            req.setAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC, (Object)map);
        }
    }

    public static String getFormsPreCheckMethodName(SlingHttpServletRequest req) {
        return "cq5forms_preCheck_" + FormsHelper.getFormId(req);
    }

    private static void writeJavaScript(SlingHttpServletRequest req, SlingHttpServletResponse response, Resource formResource, JspWriter out) throws IOException, ServletException {
        if (FormsHelper.doClientValidation(req)) {
            if (req.getAttribute(REQ_ATTR_WRITTEN_JAVASCRIPT) == null) {
                req.setAttribute(REQ_ATTR_WRITTEN_JAVASCRIPT, (Object)true);
                out.println("<script type=\"text/javascript\">");
                out.println("  function cq5forms_showMsg(fid, field, msg) {    alert(msg);    document.forms[fid].elements[field].focus();  }");
                out.println("</script>");
            }
            out.println("<script type=\"text/javascript\">");
            out.println("  function " + FormsHelper.getFormsPreCheckMethodName(req) + "(submitid) {");
            out.println("    var dMsgs = \"Please fill out the required field.\";");
            Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
            while (iter.hasNext()) {
                Resource element = iter.next();
                out.flush();
                FormsHelper.includeResource(req, response, element, "clientvalidation");
            }
            out.println("    return true;");
            out.println("  }");
            out.println("</script>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeResource(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, String selectorString) throws IOException, ServletException {
        Object oldValue = request.getAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
        try {
            request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, (Object)"true");
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setReplaceSelectors(selectorString);
            request.getRequestDispatcher(resource, options).include((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (oldValue == null) {
                request.removeAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
            } else {
                request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, oldValue);
            }
        }
    }

    public static ValueMap getGlobalFormValues(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (ValueMap)req.getAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC);
    }

    public static boolean doClientValidation(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        Boolean value = (Boolean)req.getAttribute(REQ_ATTR_CLIENT_VALIDATION);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public static String getFormId(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (String)req.getAttribute(REQ_ATTR_FORMID);
    }

    public static String getParameterName(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
        String name = (String)properties.get("name", (Object)"");
        if (name.length() == 0) {
            name = ResourceUtil.getName((Resource)rsrc);
            name = FormsHelper.filterElementName(name);
        }
        return name;
    }

    public static Iterator<Resource> getFormElements(Resource formResource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)formResource));
        while (!((Resource)iter.next()).getPath().equals(formResource.getPath())) {
        }
        FormsHelper.collectFormElements(list, iter);
        return list.iterator();
    }

    public static Iterator<String> getContentRequestParameterNames(SlingHttpServletRequest req) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (name.startsWith(":") || name.equals("_charset_")) continue;
            names.add(name);
        }
        return names.iterator();
    }

    private static boolean collectFormElements(List<Resource> list, Iterator<Resource> iter) {
        Resource n;
        boolean stop = false;
        while (!stop && iter.hasNext() && !FormsHelper.checkResourceType(n = iter.next(), "foundation/components/form/end")) {
            if (n.getResourceType().startsWith("foundation/components/form/") || n.getResourceSuperType() != null && n.getResourceSuperType().startsWith("foundation/components/form/")) {
                list.add(n);
                continue;
            }
            Iterator cI = ResourceUtil.listChildren((Resource)n);
            if (cI == null) continue;
            stop = FormsHelper.collectFormElements(list, cI);
        }
        return stop;
    }

    private static String filterElementName(String nodeName) {
        StringBuilder sb = new StringBuilder();
        int lastAdded = 0;
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            int toAdd = c;
            if ("abcdefghijklmnopqrstuvwxyz0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZ./:-".indexOf(c) < 0) {
                if (lastAdded == 95) continue;
                toAdd = 95;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append('_');
            }
            sb.append((char)toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    public static String getValue(SlingHttpServletRequest request, Resource elementResource) {
        String[] values = FormsHelper.getValues(request, elementResource);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public static String[] getValues(SlingHttpServletRequest request, Resource elementResource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)elementResource);
        String name = FormsHelper.getParameterName(elementResource);
        ValidationInfo info = ValidationInfo.getValidationInfo((HttpServletRequest)request);
        if (info != null) {
            return info.getValues(name);
        }
        ValueMap globalFormValues = FormsHelper.getGlobalFormValues(request);
        String[] defaultValues = null;
        String loadPath = (String)properties.get("loadPath", (Object)"");
        if (loadPath.length() > 0) {
            Resource rsrc = request.getResourceResolver().getResource(loadPath);
            if (rsrc != null) {
                defaultValues = (String[])rsrc.adaptTo(String[].class);
            } else if (globalFormValues != null && globalFormValues.get((Object)loadPath) != null) {
                defaultValues = (String[])globalFormValues.get(loadPath, String[].class);
            }
        } else if (globalFormValues != null && globalFormValues.get((Object)name) != null) {
            defaultValues = (String[])globalFormValues.get(name, String[].class);
        }
        if (defaultValues == null) {
            defaultValues = (String[])properties.get("defaultValue", String[].class);
        }
        return defaultValues;
    }

    public static List<String> getValuesAsList(SlingHttpServletRequest request, Resource elementResource) {
        String[] values = FormsHelper.getValues(request, elementResource);
        if (values == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(values);
    }

    public static Map<String, String> getOptions(SlingHttpServletRequest request, Resource elementResource) {
        Resource rsrc;
        ValueMap properties = ResourceUtil.getValueMap((Resource)elementResource);
        String[] options = null;
        String loadPath = (String)properties.get("optionsLoadPath", (Object)"");
        if (loadPath.length() > 0 && (rsrc = request.getResourceResolver().getResource(loadPath)) != null) {
            options = (String[])rsrc.adaptTo(String[].class);
        }
        if (options == null) {
            options = (String[])properties.get("options", String[].class);
        }
        if (options == null) {
            return null;
        }
        LinkedHashMap<String, String> splitValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < options.length; ++i) {
            String value = options[i].trim();
            if (value.length() > 0) {
                String t;
                String v;
                boolean endLoop = true;
                int pos = -1;
                int start = 0;
                do {
                    if ((pos = value.indexOf(61, start)) > 0 && value.charAt(pos - 1) == '\\') {
                        start = pos + 1;
                        endLoop = false;
                        continue;
                    }
                    endLoop = true;
                } while (!endLoop);
                if (pos == -1) {
                    v = value;
                    t = value;
                } else {
                    v = value.substring(0, pos);
                    t = value.substring(pos + 1);
                }
                v = v.replace("\\=", "=");
                t = t.replace("\\=", "=");
                splitValues.put(v, t);
                continue;
            }
            splitValues.put("", "");
        }
        if (splitValues.size() == 0) {
            return null;
        }
        return splitValues;
    }

    public static boolean isRequired(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("required", (Object)Boolean.FALSE);
    }

    public static String getTitle(Resource formElement, String defaultTitle) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (String)properties.get("jcr:title", (Object)defaultTitle);
    }

    public static boolean hasMultiSelection(Resource formElement) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)formElement);
        return (Boolean)properties.get("multiSelection", (Object)Boolean.FALSE);
    }

    public static void redirectToReferrer(SlingHttpServletRequest req, SlingHttpServletResponse res, Map<String, String[]> params) throws IOException {
        String referrer;
        String string = referrer = req.getHeader("Referer") != null ? req.getHeader("Referer") : req.getHeader("Referrer");
        if (params != null && params.size() > 0) {
            StringBuilder buffer = new StringBuilder(referrer);
            boolean hasParams = referrer.indexOf(63) > 0;
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                for (String value : entry.getValue()) {
                    buffer.append(hasParams ? (char)'&' : '?');
                    hasParams = true;
                    buffer.append(entry.getKey());
                    buffer.append('=');
                    buffer.append(URLEncoder.encode(value, "utf-8"));
                }
            }
            res.sendRedirect(buffer.toString());
        } else {
            res.sendRedirect(referrer);
        }
    }

    public static void redirectToReferrer(SlingHttpServletRequest request, SlingHttpServletResponse res) throws IOException {
        String referrer = request.getHeader("Referer") != null ? request.getHeader("Referer") : request.getHeader("Referrer");
        int pos = referrer.indexOf(63);
        if (pos > 0) {
            referrer = referrer.substring(0, pos);
        }
        StringBuilder buffer = new StringBuilder(referrer);
        RequestParameterMap params = request.getRequestParameterMap();
        if (params.entrySet().size() > 0) {
            buffer.append("?");
            boolean first = true;
            for (Map.Entry current : params.entrySet()) {
                RequestParameter[] values = (RequestParameter[])current.getValue();
                for (int i = 0; i < values.length; ++i) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append("&");
                    }
                    buffer.append((String)current.getKey());
                    buffer.append("=");
                    buffer.append(values[i].getString());
                }
            }
        }
        res.sendRedirect(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource checkFormStructure(Resource rsrc) {
        Resource formStart;
        if (FormsHelper.checkResourceType(rsrc, "foundation/components/form/start")) {
            Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
            while (!((Resource)iter.next()).getPath().equals(rsrc.getPath())) {
            }
            Resource formEnd = null;
            Resource nextPar = null;
            while (iter.hasNext() && formEnd == null) {
                Resource current = (Resource)iter.next();
                if (nextPar == null) {
                    nextPar = current;
                }
                if (!FormsHelper.checkResourceType(current, "foundation/components/form/end")) continue;
                formEnd = current;
            }
            if (formEnd == null) {
                Node parent2 = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
                if (parent2 != null) {
                    try {
                        String nodeName = "form_end_" + System.currentTimeMillis();
                        Node node = parent2.addNode(nodeName);
                        ValueMap props = ResourceUtil.getValueMap((Resource)rsrc);
                        String resourceType = "foundation/components/form/end";
                        if (props != null) {
                            resourceType = (String)props.get("endResourceType", (Object)resourceType);
                        }
                        node.setProperty("sling:resourceType", resourceType);
                        if (!resourceType.equals("foundation/components/form/end")) {
                            node.setProperty("sling:resourceSuperType", "foundation/components/form/end");
                        }
                        if (nextPar != null) {
                            parent2.orderBefore(node.getName(), ResourceUtil.getName((Resource)nextPar));
                        }
                        parent2.save();
                        Iterator i = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
                        while (true) {
                            if (!i.hasNext()) break;
                            Resource r = (Resource)i.next();
                            if (!nodeName.equals(ResourceUtil.getName((Resource)r))) continue;
                            Resource resource = r;
                            return resource;
                        }
                    }
                    catch (RepositoryException re) {
                        LOGGER.error("Unable to create missing form end element for form start " + rsrc, (Throwable)re);
                    }
                    finally {
                        try {
                            if (parent2.getSession().hasPendingChanges()) {
                                parent2.getSession().refresh(false);
                            }
                        }
                        catch (RepositoryException re) {}
                    }
                } else {
                    LOGGER.error("Resource is not adaptable to node - unable to add missing form end element for " + rsrc);
                }
            }
        } else if (FormsHelper.checkResourceType(rsrc, "foundation/components/form/end") && (formStart = FormsHelper.searchFormStart(rsrc)) == null) {
            Node node = (Node)rsrc.adaptTo(Node.class);
            Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
            if (node != null && parent != null) {
                try {
                    node.remove();
                    parent.save();
                    Resource parent2 = rsrc;
                    return parent2;
                }
                catch (RepositoryException re) {
                    LOGGER.error("Unable to create missing form end element for form start " + rsrc, (Throwable)re);
                }
                finally {
                    try {
                        if (node.getSession().hasPendingChanges()) {
                            node.getSession().refresh(false);
                        }
                    }
                    catch (RepositoryException re) {}
                }
            }
            LOGGER.error("Resource is not adaptable to node - unable to remove form element " + rsrc);
        }
        return null;
    }

    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static String decodeValue(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }
}

