/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.foundation.DiffService;
import org.apache.sling.api.resource.Resource;

public class DiffInfo {
    private final Resource content;
    private final TYPE type;

    public DiffInfo(Resource c, TYPE l) {
        this.content = c;
        this.type = l;
    }

    public Resource getContent() {
        return this.content;
    }

    public TYPE getType() {
        return this.type;
    }

    public static String getDiffOutput(DiffService service, DiffInfo diffInfo, String origText, boolean isRichText, String diffText) {
        if (service != null) {
            if (diffInfo.getType() == TYPE.ADDED) {
                return service.diff(origText, null, isRichText);
            }
            if (diffInfo.getType() == TYPE.REMOVED) {
                return service.diff(null, origText, isRichText);
            }
            return service.diff(origText, diffText, isRichText);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        ADDED,
        REMOVED,
        MOVED,
        SAME;

    }
}

