/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.profile;

import com.day.cq.security.User;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.util.SecurityUtil;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileUtil {
    private static final String ATTRIBUTE_PROFILE = "com.day.cq.security.profile";
    private static final String PARAM_AUTHORIZABLE = "authorizable";
    private static final String PROPERTY_AUTHORIZABLE = "profile";
    private static final String VARIABLE_ME = "~";
    private static final Logger log = LoggerFactory.getLogger(ProfileUtil.class);

    public static Profile fromRequest(SlingHttpServletRequest request) {
        Profile profile = (Profile)request.getAttribute(ATTRIBUTE_PROFILE);
        if (profile == null) {
            ValueMap properties = (ValueMap)request.getResource().adaptTo(ValueMap.class);
            String auth = (String)properties.get(PROPERTY_AUTHORIZABLE, String.class);
            if (auth == null) {
                if (request.getParameter(PARAM_AUTHORIZABLE) != null) {
                    auth = request.getRequestParameter(PARAM_AUTHORIZABLE).getString();
                } else if (request.getRequestPathInfo().getSuffix() != null && (auth = request.getRequestPathInfo().getSuffix()).indexOf(".") > -1) {
                    auth = auth.substring(1, auth.indexOf("."));
                }
            }
            if (auth == null) {
                return null;
            }
            ResourceResolver resourceResolver = request.getResourceResolver();
            if (VARIABLE_ME.equals(auth)) {
                profile = ((User)resourceResolver.adaptTo(User.class)).getProfile();
            } else {
                try {
                    profile = SecurityUtil.getProfile((String)auth, (Session)((Session)resourceResolver.adaptTo(Session.class)));
                }
                catch (RepositoryException e) {
                    log.error("Could not resolve Profile for {} with session {}", (Object)auth, (Object)request.getRemoteUser());
                }
            }
            if (profile != null) {
                request.setAttribute(ATTRIBUTE_PROFILE, (Object)profile);
            }
        }
        return profile;
    }
}

