/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.stencil;

import com.day.cq.wcm.foundation.stencil.impl.StencilResource;
import com.day.cq.wcm.foundation.stencil.impl.StencilResourceResolver;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

public class StencilRequestWrapper
extends SlingHttpServletRequestWrapper {
    private final Resource stencil;
    private final String realm;

    public StencilRequestWrapper(Resource stencil, SlingHttpServletRequest wrappedRequest) {
        super(wrappedRequest);
        this.stencil = stencil;
        this.realm = wrappedRequest.getResource().getPath();
    }

    public Resource getResource() {
        String type = null;
        Resource resource = super.getResource();
        if (resource instanceof ResourceWrapper) {
            type = resource.getResourceType();
            resource = ((ResourceWrapper)resource).getResource();
        }
        if (resource instanceof StencilResource) {
            if (type == null) {
                return resource;
            }
            return new WrappedResource(resource, type);
        }
        Resource newResource = this.getResourceResolver().getResource(resource.getPath());
        if (newResource != null && type != null) {
            return new WrappedResource(newResource, type);
        }
        return newResource;
    }

    public ResourceResolver getResourceResolver() {
        ResourceResolver resolver = super.getResourceResolver();
        if (resolver instanceof StencilResourceResolver) {
            return resolver;
        }
        return new StencilResourceResolver(this.stencil, this.realm);
    }

    private static class WrappedResource
    extends ResourceWrapper {
        private final String type;

        public WrappedResource(Resource resource, String type) {
            super(resource);
            this.type = type;
        }

        public String getResourceType() {
            return this.type;
        }
    }
}

