/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.Paragraph;
import com.day.cq.wcm.foundation.ParagraphSystem;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.commons.json.JSONException;

public class ParagraphList
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 2156140435583248698L;
    public static final String QUERY = "query";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        long count = 0L;
        try {
            Resource content;
            StringWriter writer = new StringWriter();
            TidyJSONWriter json = new TidyJSONWriter((Writer)writer);
            json.object();
            json.key("hits");
            json.array();
            Page page = null;
            try {
                String path = request.getRequestParameter(QUERY).getString().replace("path:", "");
                page = (Page)request.getResourceResolver().getResource(path).adaptTo(Page.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (page != null && (content = page.getContentResource()) != null) {
                try {
                    ParagraphWriter pw = new ParagraphWriter(request, response, json);
                    pw.writeParagraphSystems(content);
                    count = pw.count;
                }
                catch (JSONException e) {
                    throw new ServletException("Failed to produce JSON output", (Throwable)e);
                }
            }
            json.endArray();
            json.key("results").value(0L);
            json.endObject();
            if ("json".equals(request.getRequestPathInfo().getExtension())) {
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
            }
            response.getWriter().write(writer.toString());
        }
        catch (JSONException e) {
            throw new ServletException("Failed to produce JSON output", (Throwable)e);
        }
    }

    void writeEmptyJSON(SlingHttpServletResponse response) throws ServletException, IOException {
    }

    private static class ParagraphWriter {
        private final TidyJSONWriter json;
        private final SlingHttpServletRequest request;
        private final SlingHttpServletResponse response;
        private long count = 0L;

        public ParagraphWriter(SlingHttpServletRequest request, SlingHttpServletResponse response, TidyJSONWriter json) {
            this.request = request;
            this.response = response;
            this.json = json;
        }

        public long getCount() {
            return this.count;
        }

        public void writeParagraphSystems(Resource content) throws JSONException, IOException {
            WCMMode.DISABLED.toRequest((ServletRequest)this.request);
            Iterator iterator = content.getResourceResolver().listChildren(content);
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                Component component = WCMUtils.getComponent((Resource)resource);
                if (component == null || !component.isContainer()) continue;
                this.writeParagraphs(resource);
            }
        }

        public void writeParagraphs(Resource container) throws JSONException {
            ParagraphSystem system = new ParagraphSystem(container);
            for (Paragraph paragraph : system.paragraphs()) {
                if (paragraph.getType() != Paragraph.Type.NORMAL) continue;
                this.json.object();
                this.json.key("path").value((Object)paragraph.getPath());
                this.json.key("excerpt").value((Object)this.render(paragraph.getPath()));
                this.json.endObject();
                ++this.count;
            }
        }

        public String render(String path) {
            try {
                final StringWriter buffer = new StringWriter();
                final ServletOutputStream stream = new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        buffer.append((char)b);
                    }
                };
                SlingHttpServletResponseWrapper wrapper = new SlingHttpServletResponseWrapper(this.response){

                    public ServletOutputStream getOutputStream() {
                        return stream;
                    }

                    public PrintWriter getWriter() throws IOException {
                        return new PrintWriter(buffer);
                    }

                    public SlingHttpServletResponse getSlingResponse() {
                        return super.getSlingResponse();
                    }
                };
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(path + ".html");
                dispatcher.include((ServletRequest)this.request, (ServletResponse)wrapper);
                return ((Object)buffer).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }
    }
}

