/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.search.Predicate;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.Trends;
import com.day.cq.search.facets.Facet;
import com.day.cq.search.result.ResultPage;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.RowIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Search {
    private static final String QUERY_PARAM_NAME = "q";
    private static final String START_PARAM_NAME = "start";
    private static final String LANGUAGE_FACET_PARAM_NAME = "language";
    private static final String TAG_FACET_PARAM_NAME = "tag";
    private static final String MIME_TYPE_FACET_PARAM_NAME = "mimeType";
    private static final String FROM_FACET_PARAM_NAME = "from";
    private static final String TO_FACET_PARAM_NAME = "to";
    private static final String HTML_EXT = "html";
    private static final String SPELLCHECK_QUERY = "/jcr:root[rep:spellcheck('${query}')]/(rep:spellcheck())";
    private final SlingHttpServletRequest request;
    private final SimpleSearch search;
    private final Resource resource;
    private Result result;
    private List<Page> resultPages;

    public Search(SlingHttpServletRequest request) {
        this.request = request;
        this.resource = request.getResource();
        this.search = (SimpleSearch)this.resource.adaptTo(SimpleSearch.class);
        if (request.getParameter(QUERY_PARAM_NAME) != null) {
            try {
                this.search.setQuery(new String(request.getParameter(QUERY_PARAM_NAME).getBytes("ISO-8859-1"), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (request.getParameter(START_PARAM_NAME) != null) {
            try {
                this.search.setStart(Long.parseLong(request.getParameter(START_PARAM_NAME)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Predicate languagePredicate = new Predicate("languages", LANGUAGE_FACET_PARAM_NAME);
        languagePredicate.set(LANGUAGE_FACET_PARAM_NAME, request.getParameter(LANGUAGE_FACET_PARAM_NAME));
        this.search.addPredicate(languagePredicate);
        Predicate tagPredicate = new Predicate("tags", "tagid");
        tagPredicate.set("property", "jcr:content/cq:tags");
        tagPredicate.set("tagid", request.getParameter(TAG_FACET_PARAM_NAME));
        this.search.addPredicate(tagPredicate);
        Predicate mimeTypePredicate = new Predicate("mimeTypes", "property");
        mimeTypePredicate.set("property", "jcr:content/jcr:mimeType");
        mimeTypePredicate.set("value", request.getParameter(MIME_TYPE_FACET_PARAM_NAME));
        this.search.addPredicate(mimeTypePredicate);
        Predicate lastModPredicate = new Predicate("lastModified", "daterange");
        lastModPredicate.set("property", "jcr:content/cq:lastModified");
        lastModPredicate.set("lowerBound", request.getParameter(FROM_FACET_PARAM_NAME));
        lastModPredicate.set("upperBound", request.getParameter(TO_FACET_PARAM_NAME));
        this.search.addPredicate(lastModPredicate);
    }

    public Trends getTrends() {
        return this.search.getTrends();
    }

    public Result getResult() throws RepositoryException {
        if (this.result == null && this.search.getResult() != null) {
            this.result = new Result(this.search.getResult());
        }
        return this.result;
    }

    public List<String> getRelatedQueries() throws RepositoryException {
        return this.search.getRelatedQueries();
    }

    public String getQuery() {
        return this.search.getQuery();
    }

    public void setQuery(String query) {
        this.search.setQuery(query);
    }

    public String getExcerptPropertyNames() {
        return this.search.getExcerptPropertyNames();
    }

    public void setExcerptPropertyNames(String properties) {
        this.search.setExcerptPropertyNames(properties);
    }

    public long getHitsPerPage() {
        return this.search.getHitsPerPage();
    }

    public void setHitsPerPage(long num) {
        this.search.setHitsPerPage(num);
    }

    public String getSearchIn() {
        return this.search.getSearchIn();
    }

    public void setSearchIn(String searchIn) {
        this.search.setSearchIn(searchIn);
    }

    public String getSearchProperties() {
        return this.search.getSearchProperties();
    }

    public void setSearchProperties(String properties) {
        this.search.setSearchProperties(properties);
    }

    private static String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    private String getIconPath(String extension) {
        Component c = WCMUtils.getComponent((Resource)this.resource);
        if (c == null) {
            return null;
        }
        Resource icon = c.getLocalResource("resources/" + extension + ".gif");
        if (icon == null) {
            icon = c.getLocalResource("resources/default.gif");
        }
        return icon == null ? null : icon.getPath();
    }

    public final class Page {
        private final ResultPage rp;

        private Page(ResultPage rp) {
            this.rp = rp;
        }

        public boolean isCurrentPage() {
            return this.rp.isCurrentPage();
        }

        public long getIndex() {
            return this.rp.getIndex();
        }

        public String getURL() {
            StringBuffer url = new StringBuffer();
            url.append(Search.this.request.getRequestURI());
            url.append("?").append(Search.QUERY_PARAM_NAME);
            url.append("=").append(Search.encodeURL(Search.this.search.getQuery()));
            url.append("&").append(Search.START_PARAM_NAME);
            url.append("=").append(this.rp.getStart());
            return url.toString();
        }
    }

    public final class Hit {
        private final com.day.cq.search.result.Hit hit;

        private Hit(com.day.cq.search.result.Hit hit) {
            this.hit = hit;
        }

        public String getTitle() throws RepositoryException {
            return this.hit.getTitle();
        }

        public String getExcerpt() throws RepositoryException {
            return this.hit.getExcerpt();
        }

        public String getURL() throws RepositoryException {
            String url = Search.this.request.getContextPath() + this.hit.getPath();
            int idx = url.indexOf(46, url.lastIndexOf(47));
            if (idx == -1) {
                url = url + ".html";
            }
            return url;
        }

        public String getSimilarURL() throws RepositoryException {
            StringBuffer url = new StringBuffer();
            url.append(Search.this.request.getRequestURI());
            url.append("?").append(Search.QUERY_PARAM_NAME);
            url.append("=").append(Search.encodeURL("related:"));
            url.append(Search.encodeURL(this.hit.getPath()));
            return url.toString();
        }

        public String getIcon() throws RepositoryException {
            String url = this.getURL();
            int idx = url.lastIndexOf(46);
            if (idx == -1) {
                return "";
            }
            String ext = url.substring(idx + 1);
            if (ext.equals(Search.HTML_EXT)) {
                return "";
            }
            String path = Search.this.getIconPath(ext);
            if (path == null) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            sb.append("<img src='");
            sb.append(Search.this.request.getContextPath());
            sb.append(path).append("'/>");
            return sb.toString();
        }

        public Map getProperties() throws RepositoryException {
            return this.hit.getProperties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Result {
        private final SearchResult result;
        private final List<Hit> hits;
        private String spellSuggestion;

        private Result(SearchResult result) {
            this.result = result;
            this.hits = new ArrayList<Hit>();
            for (com.day.cq.search.result.Hit h : result.getHits()) {
                this.hits.add(new Hit(h));
            }
        }

        public List<Page> getResultPages() throws RepositoryException {
            if (Search.this.resultPages == null) {
                Search.this.resultPages = new ArrayList();
                for (ResultPage rp : Search.this.search.getResult().getResultPages()) {
                    Search.this.resultPages.add(new Page(rp));
                }
            }
            return Search.this.resultPages;
        }

        public Page getPreviousPage() throws RepositoryException {
            ResultPage previous = Search.this.search.getResult().getPreviousPage();
            if (previous != null) {
                return new Page(previous);
            }
            return null;
        }

        public Page getNextPage() throws RepositoryException {
            ResultPage next = Search.this.search.getResult().getNextPage();
            if (next != null) {
                return new Page(next);
            }
            return null;
        }

        public String getTrackerScript() {
            StringBuffer sb = new StringBuffer();
            String contextPath = Search.this.request.getContextPath();
            sb.append("<script type='text/javascript'>");
            if (!Search.this.search.getQuery().startsWith("related:")) {
                sb.append("var trackim=new Image();");
                sb.append("trackim.src='").append(contextPath);
                sb.append("/bin/statistics/tracker/query");
                sb.append("?q=").append(Search.encodeURL(Search.this.search.getQuery()));
                sb.append("&nr=").append(this.getTotalMatches());
                sb.append("&et=").append(this.getExecutionTimeMillis());
                sb.append("&").append(System.currentTimeMillis()).append("';\n");
            }
            sb.append("function trackSelectedResult(obj, position, query) {\n");
            sb.append("  var trackim=new Image();\n");
            sb.append("  var regExp = /^((\\w+):\\/\\/\\/?)?((\\w+):?(\\w+)?@)?([^\\/\\?:]+):?(\\d+)?(\\/?[^\\?#;\\|]+)?([;\\|])?([^\\?#]+)?\\??([^#]+)?#?(\\w*)/;\n");
            sb.append("  var uri = regExp.exec(obj.href);\n");
            sb.append("  var imgSrc = '").append(contextPath).append("/bin/statistics/tracker/result?p=';\n");
            sb.append("  imgSrc += encodeURIComponent(uri[8].substring(");
            sb.append(contextPath.length()).append(", uri[8].lastIndexOf('.')));\n");
            sb.append("  imgSrc += '&po=' + position + '&q=");
            sb.append(Search.encodeURL(Search.this.search.getQuery().toLowerCase()));
            sb.append("&' + Math.random();\n");
            sb.append("  trackim.src = imgSrc;\n");
            sb.append("}");
            sb.append("</script>");
            return sb.toString();
        }

        public String getSpellcheck() {
            if (this.spellSuggestion == null) {
                try {
                    Value v;
                    Session session = (Session)Search.this.request.getResourceResolver().adaptTo(Session.class);
                    RowIterator rows = session.getWorkspace().getQueryManager().createQuery(Search.SPELLCHECK_QUERY.replaceAll("\\$\\{query\\}", Search.this.getQuery()), "xpath").execute().getRows();
                    String suggestion = null;
                    if (rows.hasNext() && (v = rows.nextRow().getValue("rep:spellcheck()")) != null) {
                        suggestion = v.getString();
                    }
                    if (suggestion == null) {
                        return null;
                    }
                    Search search = new Search(Search.this.request);
                    search.setQuery(suggestion);
                    search.setSearchIn(Search.this.getSearchIn());
                    search.setSearchProperties(Search.this.getSearchProperties());
                    this.spellSuggestion = search.getResult().getTotalMatches() > 0L ? suggestion : "";
                }
                catch (RepositoryException e) {
                    this.spellSuggestion = "";
                }
            }
            if (this.spellSuggestion.length() == 0) {
                return null;
            }
            return this.spellSuggestion;
        }

        public long getStartIndex() {
            return this.result.getStartIndex();
        }

        public long getTotalMatches() {
            return this.result.getTotalMatches();
        }

        public String getExecutionTime() {
            return this.result.getExecutionTime();
        }

        public long getExecutionTimeMillis() {
            return this.result.getExecutionTimeMillis();
        }

        public Map<String, Facet> getFacets() throws RepositoryException {
            return this.result.getFacets();
        }

        public List<Hit> getHits() {
            return this.hits;
        }
    }
}

