/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FormsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsManagerImpl
implements FormsManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<EventListenerWrapper> listeners = new ArrayList<EventListenerWrapper>();
    private String[] searchPaths;
    private SlingRepository repository;
    private JcrResourceResolverFactory resolverFactory;
    private Map<String, FormsManager.ComponentDescription> actions;
    private Map<String, FormsManager.ComponentDescription> constraints;
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<FormsManager.ComponentDescription> getActions() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            if (this.actions == null) {
                this.searchFormElements();
            }
            return this.actions.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<FormsManager.ComponentDescription> getConstraints() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            if (this.constraints == null) {
                this.searchFormElements();
            }
            return this.constraints.values().iterator();
        }
    }

    @Override
    public String getDialogPathForAction(String resourceType) {
        if (resourceType == null) {
            return null;
        }
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        for (String path : this.searchPaths) {
            String dialogPath = path + '/' + resourceType + "/dialog";
            if (resourceResolver.getResource(dialogPath) == null) continue;
            return dialogPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws RepositoryException {
        this.session = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        this.searchPaths = resourceResolver.getSearchPath();
        for (int i = 0; i < this.searchPaths.length; ++i) {
            this.searchPaths[i] = this.searchPaths[i].substring(0, this.searchPaths[i].length() - 1);
        }
        for (String path : this.searchPaths) {
            EventListenerWrapper wrapper = new EventListenerWrapper(this);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)wrapper, 31, path, true, null, null, true);
            this.listeners.add(wrapper);
        }
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.searchFormElements();
        }
        this.logger.info("FormsManager service started");
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.session != null) {
            for (EventListenerWrapper listener : this.listeners) {
                try {
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
                }
                catch (RepositoryException e) {}
            }
            this.listeners.clear();
            this.session.logout();
            this.session = null;
        }
        this.actions = null;
        this.logger.info("FormsManager service shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearActions() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.actions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearConstraints() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.constraints = null;
        }
    }

    private Map<String, FormsManager.ComponentDescription> search(String type) {
        HashMap<String, FormsManager.ComponentDescription> map = new HashMap<String, FormsManager.ComponentDescription>();
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        for (String path : this.searchPaths) {
            StringBuilder buffer = new StringBuilder("/jcr:root");
            buffer.append(path);
            buffer.append("//* [@");
            buffer.append("sling:resourceType");
            buffer.append("='");
            buffer.append(type);
            buffer.append("']");
            this.logger.debug("Query: {}", (Object)buffer.toString());
            Iterator i = resourceResolver.findResources(buffer.toString(), "xpath");
            while (i.hasNext()) {
                Resource rsrc = (Resource)i.next();
                ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
                final String rt = rsrc.getPath().substring(path.length() + 1);
                if (((Boolean)properties.get("enabled", (Object)Boolean.TRUE)).booleanValue()) {
                    if (map.containsKey(rt)) continue;
                    final String title = (String)properties.get("jcr:title", (Object)ResourceUtil.getName((Resource)rsrc));
                    map.put(rt, new FormsManager.ComponentDescription(){

                        public String getResourceType() {
                            return rt;
                        }

                        public String getTitle() {
                            return title;
                        }
                    });
                    continue;
                }
                if (!map.containsKey(rt)) continue;
                map.remove(rt);
            }
        }
        return map;
    }

    private void searchFormElements() {
        if (this.actions == null) {
            this.actions = this.search("foundation/components/form/action");
        }
        if (this.constraints == null) {
            this.constraints = this.search("foundation/components/form/constraint");
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    public static final class EventListenerWrapper
    implements EventListener {
        private final FormsManagerImpl delegatee;

        public EventListenerWrapper(FormsManagerImpl listener) {
            this.delegatee = listener;
        }

        public void onEvent(EventIterator i) {
            this.delegatee.clearActions();
            this.delegatee.clearConstraints();
        }
    }
}

