/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.stencil.impl;

import com.day.cq.wcm.foundation.stencil.impl.StencilResource;
import com.day.text.Text;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StencilResourceResolver
implements ResourceResolver {
    private static final Iterator<Resource> EMPTY = Collections.emptySet().iterator();
    private final Resource stencil;
    private final ResourceResolver delegatee;
    private String realm;

    public StencilResourceResolver(Resource stencil, String root) {
        this.stencil = stencil;
        this.delegatee = stencil.getResourceResolver();
        this.realm = root;
    }

    public Resource getResource(Resource base, String path) {
        String absPath = base.getPath() + "/" + path;
        return this.buildResource(absPath);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        Resource stencil = null;
        if (Text.isDescendant((String)this.realm, (String)parent.getPath())) {
            String relPath = this.getStencilPath(parent.getPath());
            stencil = this.delegatee.getResource(this.stencil, relPath);
            if (stencil == null) {
                return EMPTY;
            }
        } else if (this.realm.equals(parent.getPath())) {
            stencil = this.stencil;
        }
        if (stencil == null) {
            return this.delegatee.listChildren(parent);
        }
        return new StenciledChildren(parent, this.delegatee.listChildren(stencil));
    }

    public Resource getResource(String path) {
        if (path.startsWith("/")) {
            path = ResourceUtil.normalize((String)path);
            return this.buildResource(path);
        }
        for (String prefix : this.delegatee.getSearchPath()) {
            Resource result = this.buildResource(prefix + path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Iterator<Map<String, Object>> queryResources(String query, String language) {
        return this.delegatee.queryResources(query, language);
    }

    public Iterator<Resource> findResources(String query, String language) {
        return this.delegatee.findResources(query, language);
    }

    public Resource resolve(HttpServletRequest request, String absPath) {
        Resource target = this.delegatee.resolve(request, absPath);
        if (Text.isDescendantOrEqual((String)this.realm, (String)target.getPath())) {
            String relPath = this.getStencilPath(target.getPath());
            Resource newStencil = this.delegatee.getResource(this.stencil, relPath);
            if (newStencil == null) {
                return new NonExistingResource((ResourceResolver)this, target.getPath());
            }
            return new StencilResource(target, newStencil);
        }
        return target;
    }

    public Resource resolve(String absPath) {
        return this.delegatee.resolve(absPath);
    }

    public String map(String resourcePath) {
        return this.delegatee.map(resourcePath);
    }

    public String map(HttpServletRequest request, String resourcePath) {
        return this.delegatee.map(request, resourcePath);
    }

    public String[] getSearchPath() {
        return this.delegatee.getSearchPath();
    }

    @Deprecated
    public Resource resolve(HttpServletRequest request) {
        return this.delegatee.resolve(request);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return (AdapterType)this.delegatee.adaptTo(type);
    }

    private Resource buildResource(String path) {
        if (Text.isDescendantOrEqual((String)this.realm, (String)path)) {
            String relPath = this.getStencilPath(path);
            Resource newStencil = this.delegatee.getResource(this.stencil, relPath);
            if (newStencil == null) {
                newStencil = this.delegatee.resolve(this.stencil.getPath() + "/" + relPath);
            }
            if (newStencil != null) {
                Resource newTarget = this.delegatee.getResource(path);
                if (newTarget == null) {
                    return new StencilResource(path, newStencil);
                }
                return new StencilResource(newTarget, newStencil);
            }
            return null;
        }
        return this.delegatee.getResource(path);
    }

    private String getStencilPath(String resourcePath) {
        return resourcePath.substring(this.realm.length() + 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StenciledChildren
    implements Iterator<Resource> {
        private final Resource target;
        private final Iterator<Resource> stencil;
        private Resource next;

        private StenciledChildren(Resource target, Iterator<Resource> stencil) {
            this.target = target;
            this.stencil = stencil;
        }

        private void seek() {
            while (this.next == null && this.stencil.hasNext()) {
                Resource stenChild = this.stencil.next();
                String name = Text.getName((String)stenChild.getPath());
                Resource newTarget = StencilResourceResolver.this.delegatee.getResource(this.target, name);
                if (newTarget == null) {
                    this.next = new StencilResource(this.target.getPath() + "/" + name, stenChild);
                    continue;
                }
                this.next = new StencilResource(newTarget, stenChild);
            }
        }

        @Override
        public boolean hasNext() {
            this.seek();
            return this.next != null;
        }

        @Override
        public Resource next() {
            Resource ret = this.next;
            this.next = null;
            return ret;
        }

        @Override
        public void remove() {
            this.stencil.remove();
        }
    }
}

