/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.foundation.DiffInfo;
import com.day.cq.wcm.foundation.Paragraph;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphSystem {
    public static final Logger log = LoggerFactory.getLogger(ParagraphSystem.class);
    public static final String COL_CTL_TYPE = "controlType";
    public static final String COL_CTL_LAYOUT = "layout";
    private final Resource resource;
    private final ResourceResolver resolver;
    private String colCtrlResourceType;
    private String colCtrlSuffix = "/colctrl";
    private String defaultLayout = "1;cq-colctrl-default";
    private List<Paragraph> paras;
    private final String versionLabel;

    public ParagraphSystem(Resource resource) {
        this(resource, null);
    }

    public ParagraphSystem(Resource resource, String versionLabel) {
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        String type = resource.getResourceType() + this.colCtrlSuffix;
        if (type.startsWith("/")) {
            for (String sp : this.resolver.getSearchPath()) {
                if (!type.startsWith(sp)) continue;
                type = type.substring(sp.length());
                break;
            }
        }
        this.colCtrlResourceType = type;
        this.versionLabel = versionLabel != null && versionLabel.trim().length() > 0 ? versionLabel : null;
    }

    public String getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(String defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public List<Paragraph> paragraphs() {
        this.initParas();
        return this.paras;
    }

    private void initParas() {
        if (this.paras != null) {
            return;
        }
        Resource versionResource = null;
        if (this.resource.adaptTo(Node.class) == null) {
            try {
                String path = this.resource.getPath();
                int idx = path.lastIndexOf(47);
                String parentPath = path.substring(0, idx);
                String name = path.substring(idx + 1);
                Session s = (Session)this.resolver.adaptTo(Session.class);
                Node parentNode = (Node)s.getItem(parentPath);
                Node parNode = parentNode.addNode(name);
                parNode.setProperty("sling:resourceType", this.resource.getResourceType());
                parentNode.save();
            }
            catch (Exception e) {
                log.warn("Could not create missing {} node.", (Object)this.resource.getPath(), (Object)e);
            }
        } else if (this.versionLabel != null) {
            Node currentNode = (Node)this.resource.adaptTo(Node.class);
            try {
                Node versionNode = this.getVersionedNode(currentNode, this.versionLabel);
                if (versionNode != null) {
                    versionResource = this.resolver.getResource(versionNode.getPath());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while trying to get versioned node for path " + this.resource.getPath() + ", version " + this.versionLabel, (Throwable)e);
            }
        }
        this.paras = this.collectParagraphs(this.resource, true);
        if (versionResource != null) {
            List<Paragraph> versionedParas = this.collectParagraphs(versionResource, false);
            this.compare(this.paras, versionedParas);
        }
    }

    private List<Paragraph> collectParagraphs(Resource resource, boolean fixStructure) {
        LinkedList<Paragraph> paragraphs = new LinkedList<Paragraph>();
        int colNum = 0;
        int numCols = 0;
        String layout = "default";
        LinkedList<Paragraph> toRemove = new LinkedList<Paragraph>();
        LinkedList<Paragraph> toCreate = new LinkedList<Paragraph>();
        Resource lastStartResource = null;
        int lastStartIndex = 0;
        Resource followingLastStartResource = null;
        Iterator iter = this.resolver.listChildren(resource);
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            if (lastStartResource != null && followingLastStartResource == null) {
                followingLastStartResource = res;
            }
            if (res.getResourceType().endsWith(this.colCtrlSuffix)) {
                ValueMap resProps = (ValueMap)res.adaptTo(ValueMap.class);
                Paragraph.Type type = null;
                try {
                    type = Paragraph.Type.valueOf(((String)resProps.get(COL_CTL_TYPE, (Object)"start")).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (type == Paragraph.Type.START) {
                    if (numCols > 0) {
                        Paragraph para;
                        while (colNum < numCols - 1) {
                            para = new Paragraph(followingLastStartResource, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                            if (followingLastStartResource != null) {
                                paragraphs.add(++lastStartIndex, para);
                            } else {
                                paragraphs.add(para);
                            }
                            toCreate.add(para);
                        }
                        para = new Paragraph(followingLastStartResource, Paragraph.Type.END, colNum, layout, numCols);
                        if (followingLastStartResource != null) {
                            paragraphs.add(++lastStartIndex, para);
                        } else {
                            paragraphs.add(para);
                        }
                        toCreate.add(para);
                    }
                    colNum = 0;
                    numCols = 1;
                    layout = (String)resProps.get(COL_CTL_LAYOUT, (Object)this.defaultLayout);
                    int i = layout.indexOf(59);
                    if (i > 0) {
                        try {
                            numCols = Integer.parseInt(layout.substring(0, i));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        layout = layout.substring(i + 1);
                    }
                    Paragraph toInsert = new Paragraph(res, type, colNum, layout, numCols);
                    paragraphs.add(toInsert);
                    lastStartResource = res;
                    lastStartIndex = paragraphs.indexOf(toInsert);
                    followingLastStartResource = null;
                    continue;
                }
                if (type == Paragraph.Type.BREAK) {
                    Paragraph para = new Paragraph(res, type, ++colNum, layout, numCols);
                    if (numCols > 0) {
                        if (colNum >= numCols) {
                            toRemove.add(para);
                            continue;
                        }
                        paragraphs.add(para);
                        continue;
                    }
                    toRemove.add(para);
                    continue;
                }
                if (type == Paragraph.Type.END) {
                    if (numCols > 0) {
                        while (colNum < numCols - 1) {
                            Paragraph para = new Paragraph(res, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                            paragraphs.add(para);
                            toCreate.add(para);
                        }
                        numCols = 0;
                        colNum = 0;
                        paragraphs.add(new Paragraph(res, Paragraph.Type.END, colNum, layout, numCols));
                        continue;
                    }
                    Paragraph para = new Paragraph(res, Paragraph.Type.END);
                    toRemove.add(para);
                    continue;
                }
                Paragraph para = new Paragraph(res, Paragraph.Type.END);
                toRemove.add(para);
                continue;
            }
            if (fixStructure && ResourceUtil.isA((Resource)res, (String)"foundation/components/form/start")) {
                paragraphs.add(new Paragraph(res, Paragraph.Type.NORMAL, colNum, layout, numCols));
                Resource newFormsEnd = FormsHelper.checkFormStructure(res);
                if (newFormsEnd == null) continue;
                paragraphs.add(new Paragraph(newFormsEnd, Paragraph.Type.NORMAL, colNum, layout, numCols));
                continue;
            }
            if (fixStructure && ResourceUtil.isA((Resource)res, (String)"foundation/components/form/end")) {
                if (FormsHelper.checkFormStructure(res) != null) continue;
                paragraphs.add(new Paragraph(res, Paragraph.Type.NORMAL, colNum, layout, numCols));
                continue;
            }
            paragraphs.add(new Paragraph(res, Paragraph.Type.NORMAL, colNum, layout, numCols));
        }
        if (numCols > 0) {
            Paragraph para;
            while (colNum < numCols - 1) {
                para = new Paragraph(followingLastStartResource, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                if (followingLastStartResource != null) {
                    paragraphs.add(++lastStartIndex, para);
                } else {
                    paragraphs.add(para);
                }
                toCreate.add(para);
            }
            para = new Paragraph(followingLastStartResource, Paragraph.Type.END, colNum, layout, numCols);
            if (followingLastStartResource != null) {
                paragraphs.add(++lastStartIndex, para);
            } else {
                paragraphs.add(para);
            }
            toCreate.add(para);
        }
        if (fixStructure) {
            try {
                this.fixStructure(toRemove, toCreate);
            }
            catch (RepositoryException e) {
                log.error("Error while fixing paragraph system structure.", (Throwable)e);
            }
        }
        return paragraphs;
    }

    private void fixStructure(List<Paragraph> toRemove, List<Paragraph> toCreate) throws RepositoryException {
        Node parent = (Node)this.resource.adaptTo(Node.class);
        for (Paragraph p : toRemove) {
            Node pn = p.adaptTo(Node.class);
            if (pn == null) continue;
            pn.remove();
        }
        int nr = 0;
        for (Paragraph p : toCreate) {
            String type = p.getType().toString().toLowerCase();
            Node node = parent.addNode("col_" + type + System.currentTimeMillis() + nr++);
            node.setProperty("sling:resourceType", this.colCtrlResourceType);
            node.setProperty(COL_CTL_TYPE, type);
            if (p.getResource() != null) {
                String beforeName = Text.getName((String)p.getResource().getPath());
                parent.orderBefore(node.getName(), beforeName);
            }
            p.setResource(this.resolver.getResource(node.getPath()));
        }
        if (!toCreate.isEmpty() || !toRemove.isEmpty()) {
            try {
                parent.save();
            }
            catch (RepositoryException e) {
                parent.refresh(false);
                throw e;
            }
        }
    }

    private Node getVersionedNode(Node node, String versionTag) throws RepositoryException {
        Version versionNode;
        String path = node.getPath();
        while (node != null && !node.isNodeType("mix:versionable")) {
            if (node.getDepth() > 0) {
                node = node.getParent();
                continue;
            }
            node = null;
        }
        if (node == null) {
            log.debug("getVersionedNode: No versionable node exists at path '{}'", (Object)path);
            return null;
        }
        try {
            versionNode = node.getVersionHistory().getVersion(versionTag);
        }
        catch (VersionException ve) {
            try {
                versionNode = node.getVersionHistory().getVersionByLabel(versionTag);
            }
            catch (VersionException ve2) {
                versionNode = null;
            }
        }
        if (versionNode == null) {
            log.debug("getVersionedNode: Version '{}' not found for path '{}'", (Object)versionTag, (Object)path);
            return null;
        }
        if (!node.getPath().equals(path)) {
            String childPath;
            Session session = node.getSession();
            if (!session.itemExists(childPath = versionNode.getPath() + "/" + "jcr:frozenNode" + path.substring(node.getPath().length()))) {
                log.debug("getVersionedNode: Version '{}' not found for path '{}'", (Object)versionTag, (Object)path);
                return null;
            }
            versionNode = (Node)session.getItem(childPath);
        } else if (versionNode.hasNode("jcr:frozenNode")) {
            versionNode = versionNode.getNode("jcr:frozenNode");
        } else {
            log.debug("getVersionedNode: Frozen node not found in version '{}' for path '{}'", (Object)versionTag, (Object)path);
            return null;
        }
        return versionNode;
    }

    private void removeColumnLayoutParagraphs(List<Paragraph> list) {
        Iterator<Paragraph> i = list.iterator();
        while (i.hasNext()) {
            Paragraph p = i.next();
            if (p.getType() == Paragraph.Type.NORMAL) continue;
            i.remove();
        }
    }

    private void compare(List<Paragraph> orig, List<Paragraph> versioned) {
        Paragraph inP;
        Paragraph value;
        Paragraph outP;
        int j;
        int i;
        ArrayList<Paragraph> current = new ArrayList<Paragraph>(orig);
        this.removeColumnLayoutParagraphs(current);
        this.removeColumnLayoutParagraphs(versioned);
        int M = current.size();
        int N = versioned.size();
        ArrayList<Paragraph> out = new ArrayList<Paragraph>();
        ArrayList<Paragraph> in = new ArrayList<Paragraph>();
        ArrayList<Paragraph> moved = new ArrayList<Paragraph>();
        int[][] opt = new int[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = ResourceUtil.getName((Resource)((Resource)current.get(i))).equals(ResourceUtil.getName((Resource)versioned.get(j))) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < M && j < N) {
            if (ResourceUtil.getName((Resource)((Resource)current.get(i))).equals(ResourceUtil.getName((Resource)versioned.get(j)))) {
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                if ((outP = this.search(out, value = (Paragraph)current.get(i++))) == null) {
                    in.add(value);
                    continue;
                }
                moved.add(value);
                out.remove(outP);
                continue;
            }
            if ((inP = this.search(in, value = versioned.get(j++))) == null) {
                out.add(value);
                continue;
            }
            moved.add(inP);
            in.remove(inP);
        }
        while (i < M || j < N) {
            if (i == M) {
                if ((inP = this.search(in, value = versioned.get(j++))) == null) {
                    out.add(value);
                    continue;
                }
                moved.add(inP);
                in.remove(inP);
                continue;
            }
            if (j != N) continue;
            if ((outP = this.search(out, value = (Paragraph)current.get(i++))) == null) {
                in.add(value);
                continue;
            }
            moved.add(value);
            out.remove(outP);
        }
        for (Paragraph v : in) {
            v.setDiffInfo(new DiffInfo(null, DiffInfo.TYPE.ADDED));
        }
        for (Paragraph v : out) {
            int pos;
            v.setDiffInfo(new DiffInfo(null, DiffInfo.TYPE.REMOVED));
            for (pos = versioned.indexOf(v) + 1; pos < versioned.size(); ++pos) {
                Paragraph nextPara = this.search(orig, versioned.get(pos));
                if (nextPara == null) continue;
                int index = orig.indexOf(nextPara);
                orig.add(index, v);
                break;
            }
            if (pos != versioned.size()) continue;
            orig.add(v);
        }
        for (Paragraph v : moved) {
            v.setDiffInfo(new DiffInfo(this.search(versioned, v), DiffInfo.TYPE.MOVED));
        }
        for (Paragraph v : current) {
            if (v.adaptTo(DiffInfo.class) != null) continue;
            v.setDiffInfo(new DiffInfo(this.search(versioned, v), DiffInfo.TYPE.SAME));
        }
    }

    private Paragraph search(List<Paragraph> paras, Paragraph rsrc) {
        String title = ResourceUtil.getName((Resource)rsrc);
        for (Paragraph p : paras) {
            if (!ResourceUtil.getName((Resource)p).equals(title)) continue;
            return p;
        }
        return null;
    }
}

