/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FormsConstants;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.FormsHandlingRequest;
import com.day.cq.wcm.foundation.forms.impl.FormsHandlingResponse;
import com.day.cq.wcm.foundation.forms.impl.RedirectRequest;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsHandlingServlet
extends SlingAllMethodsServlet
implements OptingServlet,
Filter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "form";
    protected static final String ATTR_RESOURCE = FormsHandlingServlet.class.getName() + "/resource";

    public boolean accepts(SlingHttpServletRequest request) {
        return EXTENSION.equals(request.getRequestPathInfo().getExtension());
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String actionType;
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource()) || request.getAttribute(ATTR_RESOURCE) == null) {
            this.logger.debug("Received fake request!");
            response.setStatus(500);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)request.getResource().getPath());
        }
        FormsHandlingRequest formsRequest = new FormsHandlingRequest((SlingHttpServletRequest)request);
        FormsHandlingResponse formsResponse = new FormsHandlingResponse(response);
        Resource formResource = request.getResource();
        FormsHelper.getFormId(request);
        ValidationInfo info = this.validate((SlingHttpServletRequest)formsRequest, (SlingHttpServletResponse)formsResponse, formResource);
        ValueMap properties = ResourceUtil.getValueMap((Resource)formResource);
        String string = actionType = properties == null ? "" : (String)properties.get("actionType", (Object)"");
        if (actionType.length() == 0) {
            ValidationHelper.getValidationInfo(request).addErrorMessage(null, "Unable to process the form.");
            info = ValidationHelper.getValidationInfo(request);
        }
        if (info != null) {
            this.logger.debug("Form {} is not valid: {}", (Object)formResource.getPath(), (Object)info);
            Resource rsrc = (Resource)request.getAttribute(ATTR_RESOURCE);
            request.removeAttribute(ATTR_RESOURCE);
            request.getRequestDispatcher(rsrc).forward((ServletRequest)formsRequest, (ServletResponse)response);
            return;
        }
        String rt = actionType;
        if (actionType.indexOf(47) == -1) {
            rt = "foundation/components/form/actions/" + rt;
        }
        ResourceWrapper includeResource = new ResourceWrapper(formResource, rt, "foundation/components/form/defaults/action");
        FormsHelper.includeResource((SlingHttpServletRequest)formsRequest, (SlingHttpServletResponse)formsResponse, includeResource, "forward");
        String forwardPath = FormsHelper.getForwardPath(request);
        if (forwardPath != null && forwardPath.length() > 0) {
            Resource forwardResource;
            if ("true".equals(request.getAttribute(FormsConstants.REQUEST_ATTR_REDIRECT_TO_REFERRER)) && request.getParameter(":redirect") == null) {
                String referer = request.getHeader("Referer");
                request = new RedirectRequest((SlingHttpServletRequest)request, referer);
            }
            if (forwardPath.endsWith("/")) {
                forwardPath = forwardPath + '*';
            }
            if ((forwardResource = request.getResourceResolver().resolve(forwardPath)) == null) {
                forwardResource = new NonExistingResource(request.getResourceResolver(), forwardPath);
            }
            request.getRequestDispatcher(forwardResource).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        FormsHelper.includeResource(request, response, includeResource, "post");
    }

    private ValidationInfo validate(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource formResource) throws ServletException, IOException {
        Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
        while (iter.hasNext()) {
            Resource element = iter.next();
            FormsHelper.includeResource(request, response, element, "servervalidation");
        }
        return ValidationHelper.hasValidationInfo((HttpServletRequest)request) ? ValidationHelper.getValidationInfo(request) : null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest req;
        if (request instanceof SlingHttpServletRequest && "POST".equalsIgnoreCase((req = (SlingHttpServletRequest)request).getMethod()) && req.getParameter(":formstart") != null) {
            req.setAttribute(ATTR_RESOURCE, (Object)req.getResource());
            StringBuilder sb = new StringBuilder();
            sb.append(req.getResource().getPath());
            sb.append('/');
            sb.append(req.getParameter(":formstart"));
            sb.append('.');
            sb.append(SELECTOR);
            sb.append('.');
            sb.append(EXTENSION);
            String forwardPath = sb.toString();
            req.getRequestDispatcher(forwardPath).forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
    }
}

