/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import com.day.cq.rewriter.htmlparser.AttributeList;
import com.day.cq.rewriter.htmlparser.DocumentHandler;
import com.day.cq.rewriter.htmlparser.HtmlParser;
import com.day.cq.wcm.foundation.External;
import com.day.cq.wcm.foundation.impl.EncodingScanner;
import com.day.text.Text;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rewriter
implements DocumentHandler {
    private static final Logger log = LoggerFactory.getLogger(Rewriter.class);
    private final String pagePath;
    private final String resourcePath;
    private final String target;
    private final String targetParamName;
    private External.Limit limit = External.Limit.NO;
    private String identifier;
    private URI targetURL;
    private PrintWriter writer;
    private boolean respectTypeAttribute;
    private String hostPrefix;
    private Map<String, String> extraParams = new HashMap<String, String>();
    private boolean passInput;
    private int soTimeout = 60000;
    private int connectionTimeout = 5000;

    public Rewriter(String pagePath, String resourcePath, String target, String targetParamName) {
        this.pagePath = pagePath;
        this.resourcePath = resourcePath;
        this.target = target;
        this.targetParamName = targetParamName;
    }

    public void setPassInput(boolean passInput) {
        this.passInput = passInput;
    }

    public void addExtraParameter(String name, String value) {
        this.extraParams.put(name, value);
    }

    public void setLimit(External.Limit limit) {
        this.limit = limit;
    }

    public void setRespectTypeAttribute(boolean respectTypeAttribute) {
        this.respectTypeAttribute = respectTypeAttribute;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void onStart() throws IOException {
    }

    public void onStartElement(String name, AttributeList attList, char[] ch, int off, int len, boolean endSlash) {
        String suffix = null;
        String upperName = name.toUpperCase();
        if (this.limit != External.Limit.OFF) {
            if (upperName.equals("A")) {
                boolean spool = this.respectTypeAttribute && attList.containsAttribute("type");
                this.rewriteRef(attList, "HREF", spool);
            } else if (upperName.equals("AREA")) {
                this.rewriteRef(attList, "HREF", false);
            } else if (upperName.equals("BASE")) {
                this.rewriteBase(attList);
            } else if (upperName.equals("FORM")) {
                suffix = this.rewriteForm(attList);
            } else if (upperName.equals("FRAME")) {
                this.rewriteRef(attList, "SRC", true);
            } else if (upperName.equals("IFRAME")) {
                this.rewriteRef(attList, "SRC", true);
            } else if (upperName.equals("IMG")) {
                this.rewriteRef(attList, "SRC", true);
            } else if (upperName.equals("INPUT")) {
                this.rewriteRef(attList, "SRC", true);
            } else if (upperName.equals("LINK")) {
                this.rewriteRef(attList, "HREF", true);
            } else if (upperName.equals("SCRIPT")) {
                this.rewriteRef(attList, "SRC", true);
            } else if (upperName.equals("TABLE")) {
                this.rewriteRef(attList, "BACKGROUND", true);
            } else if (upperName.equals("TD")) {
                this.rewriteRef(attList, "BACKGROUND", true);
            } else if (upperName.equals("TR")) {
                this.rewriteRef(attList, "BACKGROUND", true);
            }
        }
        if (attList.isModified()) {
            this.writer.write(this.serialize(name, attList, endSlash));
        } else {
            this.writer.write(ch, off, len);
        }
        if (suffix != null) {
            this.writer.write(suffix);
        }
    }

    private String serialize(String name, AttributeList attList, boolean endSlash) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("<");
        buffer.append(name);
        Iterator attNames = attList.attributeNames();
        while (attNames.hasNext()) {
            String attName = (String)attNames.next();
            String attValue = attList.getQuotedValue(attName);
            buffer.append(" ");
            buffer.append(attName);
            if (attValue == null) continue;
            buffer.append('=');
            buffer.append(attValue);
        }
        if (endSlash) {
            buffer.append(" /");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public void characters(char[] ch, int off, int len) throws IOException {
        this.writer.write(ch, off, len);
    }

    public void onEndElement(String name, char[] ch, int off, int len) {
        this.writer.write(ch, off, len);
    }

    public void onEnd() throws IOException {
    }

    private String getAbsoluteURL(String relativeURI) {
        if (relativeURI.startsWith("http:") || relativeURI.startsWith("https:")) {
            return relativeURI;
        }
        StringBuffer result = new StringBuffer(256);
        result.append(this.targetURL.getScheme());
        result.append("://");
        result.append(this.targetURL.getHost());
        if (this.targetURL.getPort() != -1) {
            result.append(':');
            result.append(Integer.toString(this.targetURL.getPort()));
        }
        if (relativeURI.startsWith("/")) {
            result.append(relativeURI);
        } else {
            String targetURI = this.targetURL.getPath();
            int lastSep = targetURI.lastIndexOf(47);
            targetURI = lastSep != -1 ? targetURI.substring(0, targetURI.lastIndexOf(47) + 1) : "/";
            result.append(targetURI);
            result.append(relativeURI);
        }
        return result.toString();
    }

    private void rewriteBase(AttributeList attList) {
        String href = attList.getValue("HREF");
        if (href != null && (this.limit != External.Limit.HOST || this.sameHost(href))) {
            try {
                this.targetURL = new URI(href);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            attList.setValue("HREF", "");
        }
    }

    private String rewriteForm(AttributeList attList) {
        String action = attList.getValue("ACTION");
        if (action != null && (this.limit != External.Limit.HOST || this.sameHost(action))) {
            action = this.getAbsoluteURL(action);
            attList.setValue("ACTION", this.pagePath + ".html");
            StringBuffer hidden = new StringBuffer();
            hidden.append("<input type=\"hidden\" name=\"");
            hidden.append(this.targetParamName);
            if (this.identifier != null) {
                hidden.append('_');
                hidden.append(this.identifier);
            }
            hidden.append("\" value=\"");
            hidden.append(action);
            hidden.append("\">");
            return hidden.toString();
        }
        return null;
    }

    private void rewriteRef(AttributeList attList, String attName, boolean appendSelector) {
        String ref = attList.getValue(attName);
        if (ref != null && (this.limit != External.Limit.HOST || this.sameHost(ref))) {
            attList.setValue(attName, this.rewriteURL(ref, appendSelector));
        }
    }

    private String rewriteURL(String url, boolean appendSelector) {
        StringBuffer newValue = new StringBuffer();
        if (appendSelector) {
            newValue.append(this.resourcePath);
            newValue.append("?");
        } else {
            newValue.append(this.pagePath);
            newValue.append(".html?");
        }
        newValue.append(this.targetParamName);
        if (!appendSelector && this.identifier != null) {
            newValue.append('_');
            newValue.append(this.identifier);
        }
        newValue.append('=');
        newValue.append(URLEncoder.encode(this.getAbsoluteURL(url)));
        return newValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteHtml(InputStream in, String contentType, HttpServletResponse response) throws IOException {
        String encoding = "8859_1";
        int charsetIndex = contentType.indexOf("charset=");
        if (charsetIndex != -1) {
            encoding = contentType.substring(charsetIndex + "charset=".length()).trim();
        } else {
            byte[] buf = new byte[2048];
            int len = this.fillBuffer(in, buf);
            String scanned = EncodingScanner.scan(buf, 0, len);
            if (scanned != null) {
                encoding = scanned;
                contentType = contentType + "; charset=" + encoding;
            }
            PushbackInputStream pb = new PushbackInputStream(in, buf.length);
            pb.unread(buf, 0, len);
            in = pb;
        }
        response.setContentType(contentType);
        PrintWriter writer = response.getWriter();
        this.setWriter(writer);
        HashSet<String> inclusionSet = new HashSet<String>();
        inclusionSet.add("A");
        inclusionSet.add("AREA");
        inclusionSet.add("BASE");
        inclusionSet.add("FORM");
        inclusionSet.add("FRAME");
        inclusionSet.add("IFRAME");
        inclusionSet.add("IMG");
        inclusionSet.add("INPUT");
        inclusionSet.add("LINK");
        inclusionSet.add("SCRIPT");
        inclusionSet.add("TABLE");
        inclusionSet.add("TD");
        inclusionSet.add("TR");
        inclusionSet.add("NOREWRITE");
        HtmlParser parser = new HtmlParser();
        parser.setTagInclusionSet(inclusionSet);
        parser.setDocumentHandler((DocumentHandler)this);
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new InputStreamReader(in, encoding));
            char[] buf = new char[2048];
            while ((len = reader.read(buf)) != -1) {
                parser.update(buf, 0, len);
            }
            parser.finished();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private int fillBuffer(InputStream in, byte[] buf) throws IOException {
        int total;
        int chunk;
        for (total = 0; total < buf.length && (chunk = in.read(buf, total, buf.length - total)) > 0; total += chunk) {
        }
        return total;
    }

    private void setHostPrefix(URI uri) {
        StringBuffer buf = new StringBuffer();
        buf.append(uri.getScheme());
        buf.append("://");
        buf.append(uri.getHost());
        int port = uri.getPort();
        if (port != -1) {
            buf.append(':');
            buf.append(String.valueOf(port));
        }
        buf.append('/');
        this.hostPrefix = buf.toString();
    }

    private boolean sameHost(String ref) {
        if (!ref.startsWith("http:") && !ref.startsWith("https:")) {
            return true;
        }
        return ref.startsWith(this.hostPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrite(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PostMethod httpMethod;
        try {
            this.targetURL = new URI(this.target);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException("Bad URI syntax: " + this.target);
            ioe.initCause(e);
            throw ioe;
        }
        this.setHostPrefix(this.targetURL);
        HttpClient httpClient = new HttpClient();
        HttpState httpState = new HttpState();
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.setHost(this.targetURL.getHost(), this.targetURL.getPort());
        String method = request.getMethod().toUpperCase();
        String urlString = this.targetURL.getPath();
        StringBuffer query = new StringBuffer();
        if (this.targetURL.getQuery() != null) {
            query.append("?");
            query.append(this.targetURL.getQuery());
        }
        if ("GET".equals(method)) {
            for (String name : this.extraParams.keySet()) {
                String value = this.extraParams.get(name);
                if (query.length() == 0) {
                    query.append("?");
                } else {
                    query.append("&");
                }
                query.append(Text.escape((String)name));
                query.append("=");
                query.append(Text.escape((String)value));
            }
            if (this.passInput) {
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    if (this.targetParamName.equals(name)) continue;
                    String[] values = request.getParameterValues(name);
                    for (int i = 0; i < values.length; ++i) {
                        if (query.length() == 0) {
                            query.append("?");
                        } else {
                            query.append("&");
                        }
                        query.append(Text.escape((String)name));
                        query.append("=");
                        query.append(Text.escape((String)values[i]));
                    }
                }
            }
            httpMethod = new GetMethod(urlString + query);
        } else if ("POST".equals(method)) {
            boolean mp;
            PostMethod m;
            httpMethod = m = new PostMethod(urlString + query);
            String contentType = request.getContentType();
            boolean bl = mp = contentType != null && contentType.toLowerCase().startsWith("multipart/");
            if (mp) {
                LinkedList<StringPart> parts = new LinkedList<StringPart>();
                for (String name : this.extraParams.keySet()) {
                    String value = this.extraParams.get(name);
                    parts.add(new StringPart(name, value));
                }
                if (this.passInput) {
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        if (this.targetParamName.equals(name)) continue;
                        String[] values = request.getParameterValues(name);
                        for (int i = 0; i < values.length; ++i) {
                            parts.add(new StringPart(name, values[i]));
                        }
                    }
                }
                m.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), m.getParams()));
            } else {
                for (String name : this.extraParams.keySet()) {
                    String value = this.extraParams.get(name);
                    m.addParameter(name, value);
                }
                if (this.passInput) {
                    Enumeration e = request.getParameterNames();
                    while (e.hasMoreElements()) {
                        String name;
                        name = (String)e.nextElement();
                        if (this.targetParamName.equals(name)) continue;
                        String[] values = request.getParameterValues(name);
                        for (int i = 0; i < values.length; ++i) {
                            m.addParameter(name, values[i]);
                        }
                    }
                }
            }
        } else {
            log.error("Unsupported method ''{0}''", (Object)method);
            throw new IOException("Unsupported http method " + method);
        }
        log.debug("created http connection for method {0} to {1}", (Object)method, (Object)(urlString + query));
        httpMethod.addRequestHeader("User-Agent", request.getHeader("User-Agent"));
        httpMethod.setFollowRedirects(false);
        httpMethod.getParams().setSoTimeout(this.soTimeout);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
        httpClient.executeMethod(hostConfig, (HttpMethod)httpMethod, httpState);
        String contentType = httpMethod.getResponseHeader("Content-Type").getValue();
        log.debug("External app responded: {0}", (Object)httpMethod.getStatusLine());
        log.debug("External app contenttype: {0}", (Object)contentType);
        int statusCode = httpMethod.getStatusCode();
        if (statusCode >= 400) {
            PrintWriter writer = response.getWriter();
            writer.println("External application returned status code: " + statusCode);
            return;
        }
        if (statusCode == 302 || statusCode == 301) {
            String location = httpMethod.getResponseHeader("Location").getValue();
            if (location == null) {
                response.sendError(404);
                return;
            }
            response.sendRedirect(this.rewriteURL(location, false));
            return;
        }
        InputStream in = httpMethod.getResponseBodyAsStream();
        if (contentType != null && contentType.startsWith("text/html")) {
            this.rewriteHtml(in, contentType, response);
        } else {
            if (contentType != null) {
                response.setContentType(contentType);
            }
            ServletOutputStream outs = response.getOutputStream();
            try {
                int len;
                byte[] buf = new byte[8192];
                while ((len = in.read(buf)) != -1) {
                    outs.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }
}

