/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.foundation.Download;
import com.day.cq.wcm.foundation.ImageHelper;
import com.day.cq.wcm.foundation.ImageMap;
import com.day.image.Layer;
import com.day.text.Text;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.sling.api.resource.Resource;

public class Image
extends Download {
    public static final String PN_HTML_WIDTH = "htmlWidth";
    public static final String PN_HTML_HEIGHT = "htmlHeight";
    public static final String PN_WIDTH = "width";
    public static final String PN_HEIGHT = "height";
    public static final String PN_MIN_WIDTH = "minWidth";
    public static final String PN_MIN_HEIGHT = "minHeight";
    public static final String PN_MAX_WIDTH = "maxWidth";
    public static final String PN_MAX_HEIGHT = "maxHeight";
    public static final String PN_ALT = "alt";
    public static final String PN_IMAGE_MAP = "imageMap";
    public static final String PN_IMAGE_CROP = "imageCrop";
    public static final String PN_IMAGE_ROTATE = "imageRotate";
    private String imageMapId;
    private ImageMap imageMap;
    private boolean noPlaceholder;

    public Image(Resource resource) {
        super(resource);
        this.setExtension(".png");
        this.imageMap = null;
        if (this.properties.containsKey((Object)PN_IMAGE_MAP)) {
            try {
                String mapDefinition = (String)this.properties.get(PN_IMAGE_MAP, (Object)"");
                if (mapDefinition.length() > 0) {
                    this.imageMap = ImageMap.fromString(mapDefinition);
                    this.imageMapId = "map_" + Math.round(Math.random() * 2.147483647E9) + "_" + System.currentTimeMillis();
                }
            }
            catch (IllegalArgumentException iae) {
                this.imageMap = null;
                this.imageMapId = null;
            }
        }
        this.setSuffix("");
    }

    public Image(Resource resource, String imageName) {
        this(resource.getResourceResolver().getResource(resource, imageName));
    }

    public String getAlt() {
        String alt = this.get(this.getItemName(PN_ALT));
        if (alt.length() == 0) {
            alt = this.getTitle();
        }
        return alt.length() == 0 ? this.getFileNodePath() : alt;
    }

    public void setDropTargetId(String id, String classifier) {
        if (classifier == null) {
            classifier = "";
        }
        if (!classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        this.addCssClass("cq-dd-" + id + classifier);
    }

    public void setDropTargetId(String id) {
        String classifier = this.resource == null ? String.valueOf(System.currentTimeMillis()) : Text.getName((String)this.resource.getPath());
        this.setDropTargetId(id, classifier);
    }

    public void setAlt(String alt) {
        this.set(PN_ALT, alt);
    }

    public String getSrc() {
        return super.getHref();
    }

    public void setSrc(String src) {
        super.setHref(src);
    }

    public boolean hasNoPlaceholder() {
        return this.noPlaceholder;
    }

    public void setNoPlaceholder(boolean noPlaceholder) {
        this.noPlaceholder = noPlaceholder;
    }

    public void loadStyleData(Style style) {
        if (style != null) {
            this.set(PN_MIN_WIDTH, (String)style.get(PN_MIN_WIDTH, (Object)""));
            this.set(PN_MIN_HEIGHT, (String)style.get(PN_MIN_HEIGHT, (Object)""));
            this.set(PN_MAX_WIDTH, (String)style.get(PN_MAX_WIDTH, (Object)""));
            this.set(PN_MAX_HEIGHT, (String)style.get(PN_MAX_HEIGHT, (Object)""));
        }
    }

    public void draw(Writer w) throws IOException {
        String src;
        if (!this.hasContent() && this.noPlaceholder) {
            return;
        }
        if (this.hasContent()) {
            src = Text.escape((String)this.getSrc(), (char)'%', (boolean)true);
        } else {
            src = "/libs/widgets/0.gif";
            this.addCssClass("cq-image-placeholder");
        }
        PrintWriter out = new PrintWriter(w);
        out.print("<img ");
        if (this.get(this.getItemName(PN_HTML_WIDTH)).length() > 0) {
            out.printf("width=\"%s\" ", this.get(this.getItemName(PN_HTML_WIDTH)));
        }
        if (this.get(this.getItemName(PN_HTML_HEIGHT)).length() > 0) {
            out.printf("height=\"%s\" ", this.get(this.getItemName(PN_HTML_HEIGHT)));
        }
        out.printf("src=\"%s\" ", src);
        out.printf("alt=\"%s\" ", StringEscapeUtils.escapeHtml((String)this.getAlt()));
        out.printf("title=\"%s\" ", StringEscapeUtils.escapeHtml((String)this.getTitle()));
        if (this.attrs != null) {
            for (Map.Entry e : this.attrs.entrySet()) {
                out.printf("%s=\"%s\" ", StringEscapeUtils.escapeHtml((String)e.getKey().toString()), StringEscapeUtils.escapeHtml((String)e.getValue().toString()));
            }
        }
        if (this.imageMap != null) {
            out.printf("usemap=\"#%s\" ", this.imageMapId);
        }
        out.print(">");
        if (this.imageMap != null) {
            out.print(this.imageMap.draw(this.imageMapId));
        }
    }

    public Rectangle getCropRect() {
        String cropData = this.get(this.getItemName(PN_IMAGE_CROP));
        if (cropData.length() > 0) {
            return ImageHelper.getCropRect(cropData, this.resource.getPath());
        }
        return null;
    }

    public int getRotation() {
        String rotation = this.get(this.getItemName(PN_IMAGE_ROTATE));
        if (rotation.length() > 0) {
            try {
                return Integer.parseInt(rotation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public Layer resize(Layer layer) {
        Dimension d = new Dimension(this.get(this.getItemName(PN_WIDTH), 0), this.get(this.getItemName(PN_HEIGHT), 0));
        Dimension min = new Dimension(this.get(this.getItemName(PN_MIN_WIDTH), 0), this.get(this.getItemName(PN_MIN_HEIGHT), 0));
        Dimension max = new Dimension(this.get(this.getItemName(PN_MAX_WIDTH), 0), this.get(this.getItemName(PN_MAX_HEIGHT), 0));
        return ImageHelper.resize(layer, d, min, max);
    }

    public Layer crop(Layer layer) {
        Rectangle rect = this.getCropRect();
        if (rect != null) {
            layer.crop((Rectangle2D)rect);
            return layer;
        }
        return null;
    }

    public Layer rotate(Layer layer) {
        int rotation = this.getRotation();
        if (rotation != 0) {
            layer.rotate((double)rotation);
            return layer;
        }
        return null;
    }

    public Layer getLayer(boolean cropped, boolean resized, boolean rotated) throws IOException, RepositoryException {
        Layer layer = null;
        Property data = this.getData();
        if (data != null) {
            layer = ImageHelper.createLayer((Item)data);
            if (layer != null && cropped) {
                this.crop(layer);
            }
            if (layer != null && resized) {
                this.resize(layer);
            }
            if (layer != null && rotated) {
                this.rotate(layer);
            }
        }
        return layer;
    }
}

