/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.search.Hit;
import com.day.cq.search.Search;
import com.day.cq.search.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.foundation.ParagraphSystem;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List {
    public static final Logger log = LoggerFactory.getLogger(ParagraphSystem.class);
    public static final String DEFAULT_QUERY = "";
    public static final String URL_EXTENSION = ".html";
    public static final String LIST_CHILDREN_PROPERTY_NAME = "listChildren";
    public static final String QUERY_PROPERTY_NAME = "query";
    public static final String START_IN_PROPERTY_NAME = "startIn";
    public static final String LIMIT_PROPERTY_NAME = "limit";
    public static final String ORDERED_PROPERTY_NAME = "ordered";
    private Page page = null;
    private Search search = null;
    private java.util.List<Item> items = null;
    private String query = null;
    private String startIn = "";
    private long limit = 100L;
    private boolean ordered = false;
    private boolean listChildren = false;

    public List(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        this.listChildren = (Boolean)properties.get(LIST_CHILDREN_PROPERTY_NAME, (Object)false);
        if (this.listChildren) {
            String path = (String)properties.get(START_IN_PROPERTY_NAME, (Object)Text.getRelativeParent((String)resource.getPath(), (int)3));
            this.page = (Page)request.getResourceResolver().getResource(path).adaptTo(Page.class);
        } else {
            this.search = (Search)resource.adaptTo(Search.class);
            this.query = (String)properties.get(QUERY_PROPERTY_NAME, (Object)DEFAULT_QUERY);
            this.startIn = (String)properties.get(START_IN_PROPERTY_NAME, (Object)Text.getAbsoluteParent((String)resource.getPath(), (int)1));
            this.limit = ((Integer)properties.get(LIMIT_PROPERTY_NAME, (Object)100)).intValue();
            this.ordered = (Boolean)properties.get(ORDERED_PROPERTY_NAME, (Object)false);
        }
    }

    public Iterator<Item> getItems(String searchQuery) {
        if (this.items == null) {
            ArrayList<Item> tmpItems = new ArrayList<Item>();
            if (this.listChildren) {
                Iterator pages = this.page.listChildren();
                while (pages.hasNext()) {
                    tmpItems.add(new Item((Page)pages.next()));
                }
            } else {
                this.search.setQuery(searchQuery != null ? searchQuery : this.query);
                this.search.setSearchIn(this.startIn);
                this.search.setHitsPerPage(this.limit);
                if (!DEFAULT_QUERY.equals(this.search.getQuery())) {
                    try {
                        SearchResult result = this.search.getResult();
                        for (Hit hit : result.getHits()) {
                            tmpItems.add(new Item(hit));
                        }
                        this.items = Collections.unmodifiableList(tmpItems);
                    }
                    catch (RepositoryException re) {
                        log.error("error building list items", (Throwable)re);
                    }
                }
            }
            this.items = Collections.unmodifiableList(tmpItems);
        }
        return this.items == null || this.items.size() == 0 ? null : this.items.iterator();
    }

    public Iterator<Item> getItems() {
        return this.getItems(null);
    }

    public Iterator<Resource> getItemResources() {
        if (this.items == null) {
            this.getItems();
        }
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (Item item : this.items) {
                resources.add(item.getResource());
            }
            return resources.iterator();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isEmpty() {
        if (this.items == null) {
            this.getItems();
        }
        return this.items == null || this.items.size() == 0;
    }

    public class Item {
        Resource resource = null;
        Page page;
        ValueMap properties = null;
        String path = "";
        String title = "";
        String description = "";
        String icon = null;

        public Item(Page p) {
            this.resource = p.getContentResource();
            this.page = p;
            this.properties = p.getProperties();
            this.path = p.getPath();
            this.title = p.getTitle();
            this.description = p.getDescription();
        }

        public Item(Hit h) {
            try {
                this.resource = h.getResource();
                this.page = (Page)this.resource.adaptTo(Page.class);
                this.properties = this.page.getProperties();
                this.path = h.getPath();
                this.title = this.page.getTitle();
                this.description = this.page.getDescription();
            }
            catch (RepositoryException re) {
                log.error("error building list item", (Throwable)re);
            }
        }

        public Resource getResource() {
            return this.resource;
        }

        public Page getPage() {
            return this.page;
        }

        public ValueMap getProperties() {
            return this.properties;
        }

        public String getUrl() {
            return this.path + List.URL_EXTENSION;
        }

        public String getPath() {
            return this.path;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

