/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public class ValidationInfo {
    private static final String GLOBAL = "";
    private static final String PARAMETER_NAME = "fi";
    private final Map<String, String[]> messages = new HashMap<String, String[]>();
    private final Map<String, String[]> values;
    private final String formId;
    private static final Map<String, TicketInfo> tickets = new HashMap<String, TicketInfo>();

    public ValidationInfo(String formId, Map requestValues) {
        this.formId = formId;
        this.values = new HashMap<String, String[]>();
        for (Map.Entry entry : requestValues.entrySet()) {
            this.values.put(entry.getKey().toString(), (String[])entry.getValue());
        }
    }

    public String[] getValues(String field) {
        return this.values.get(field);
    }

    public void addErrorMessage(String field, String msg) {
        String[] msgs;
        if (field == null) {
            field = GLOBAL;
        }
        if ((msgs = this.messages.get(field)) == null) {
            this.messages.put(field, new String[]{msg});
        } else {
            String[] newMsgs = new String[msgs.length + 1];
            System.arraycopy(msgs, 0, newMsgs, 0, msgs.length);
            newMsgs[msgs.length] = msg;
            this.messages.put(field, newMsgs);
        }
    }

    public String getFormId() {
        return this.formId;
    }

    public String[] getErrorMessages(String field) {
        if (field == null) {
            field = GLOBAL;
        }
        return this.messages.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationInfo getValidationInfo(HttpServletRequest req) {
        String[] ids = req.getParameterValues(PARAMETER_NAME);
        if (ids != null && ids.length > 0) {
            TicketInfo info = null;
            Map<String, TicketInfo> map = tickets;
            synchronized (map) {
                for (String id : ids) {
                    TicketInfo current = tickets.get(id);
                    if (current == null || info != null && info.created >= current.created) continue;
                    info = current;
                }
            }
            if (info != null) {
                return info.info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValidationInfoUri(String uri, ValidationInfo info) {
        StringBuffer buffer = new StringBuffer(uri);
        int pos = uri.indexOf(63);
        if (pos == -1) {
            buffer.append('?');
        } else {
            buffer.append('&');
        }
        buffer.append(PARAMETER_NAME);
        buffer.append('=');
        String id = UUID.randomUUID().toString();
        buffer.append(id);
        Map<String, TicketInfo> map = tickets;
        synchronized (map) {
            tickets.put(id, new TicketInfo(info));
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        long deleteDate = System.currentTimeMillis() - 420000L;
        Map<String, TicketInfo> map = tickets;
        synchronized (map) {
            Iterator<Map.Entry<String, TicketInfo>> iter = tickets.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, TicketInfo> entry = iter.next();
                if (entry.getValue().created >= deleteDate) continue;
                iter.remove();
            }
        }
    }

    protected static final class TicketInfo {
        public final long created = System.currentTimeMillis();
        public final ValidationInfo info;

        public TicketInfo(ValidationInfo i) {
            this.info = i;
        }
    }
}

