/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.cq.wcm.foundation.forms.FormsManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsListServlet
extends AbstractPredicateServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private FormsManager formsManager;

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        try {
            JSONWriter w = new JSONWriter((Writer)resp.getWriter());
            if (req.getRequestURI().contains("/actions")) {
                this.writeActions(w);
            } else if (req.getRequestURI().contains("/constraints")) {
                this.writeConstraints(w);
            } else if (req.getRequestURI().contains("/actiondialog")) {
                String dialogPath = this.formsManager.getDialogPathForAction(req.getParameter("id"));
                if (dialogPath != null) {
                    req.getRequestDispatcher(dialogPath + ".infinity.json").forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    resp.sendError(400);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error while generating JSON list", (Throwable)e);
            resp.sendError(500, e.toString());
            return;
        }
    }

    private void writeJson(Iterator<FormsManager.ComponentDescription> descIter, JSONWriter w, boolean writeEmpty) throws JSONException {
        w.array();
        if (writeEmpty) {
            w.object();
            w.key("value").value((Object)"");
            w.key("text").value((Object)"None");
            w.endObject();
        }
        while (descIter.hasNext()) {
            FormsManager.ComponentDescription desc = descIter.next();
            w.object();
            w.key("value");
            w.value((Object)desc.getResourceType());
            w.key("text");
            w.value((Object)desc.getTitle());
            w.endObject();
        }
        w.endArray();
    }

    private void writeActions(JSONWriter w) throws JSONException {
        this.writeJson(this.formsManager.getActions(), w, false);
    }

    private void writeConstraints(JSONWriter w) throws JSONException {
        this.writeJson(this.formsManager.getConstraints(), w, true);
    }

    protected void bindFormsManager(FormsManager formsManager) {
        this.formsManager = formsManager;
    }

    protected void unbindFormsManager(FormsManager formsManager) {
        if (this.formsManager == formsManager) {
            this.formsManager = null;
        }
    }
}

