/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.search.Predicate;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List {
    public static final Logger log = LoggerFactory.getLogger(List.class);
    public static final String DEFAULT_QUERY = "";
    public static final String URL_EXTENSION = ".html";
    public static final String TYPE_PROPERTY_NAME = "displayAs";
    public static final String SOURCE_PROPERTY_NAME = "listFrom";
    public static final String SOURCE_CHILDREN = "children";
    public static final String SOURCE_STATIC = "static";
    public static final String SOURCE_SEARCH = "search";
    public static final String SOURCE_QUERYBUILDER = "querybuilder";
    public static final String TYPE_DEFAULT = "default";
    public static final String PARENT_PAGE_PROPERTY_NAME = "parentPage";
    public static final String PAGES_PROPERTY_NAME = "pages";
    public static final String QUERY_PROPERTY_NAME = "query";
    public static final String SEARCH_IN_PROPERTY_NAME = "searchIn";
    public static final String LIMIT_PROPERTY_NAME = "limit";
    public static final String PAGE_MAX_PROPERTY_NAME = "pageMax";
    public static final String ORDER_BY_PROPERTY_NAME = "orderBy";
    public static final String ORDERED_PROPERTY_NAME = "ordered";
    public static final String SAVEDQUERY_PROPERTY_NAME = "savedquery";
    public static final String PAGE_START_PARAM_NAME = "start";
    public static final String PAGE_MAX_PARAM_NAME = "max";
    private String id;
    private SlingHttpServletRequest request;
    private java.util.List<Resource> resources;
    private java.util.List<Page> pages;
    private Iterator<Page> pageIterator;
    private Iterator<Node> nodeIterator;
    private boolean inited;
    private boolean ordered;
    private String source;
    private String query;
    private String startIn;
    private String type;
    private String orderBy;
    private Comparator<Page> orderComparator;
    private int limit = -1;
    private int pageMaximum = -1;
    private int pageStart = 0;
    private Resource resource;
    private ValueMap properties;

    public List(SlingHttpServletRequest request) {
        this.request = request;
        this.resource = request.getResource();
        this.generateId();
    }

    private void initConfig() {
        this.properties = (ValueMap)this.resource.adaptTo(ValueMap.class);
        if (this.source == null) {
            try {
                this.source = (String)this.properties.get(SOURCE_PROPERTY_NAME, (Object)SOURCE_STATIC);
            }
            catch (NullPointerException npe) {
                this.source = SOURCE_STATIC;
            }
        }
        if (this.query == null) {
            try {
                this.query = (String)this.properties.get(QUERY_PROPERTY_NAME, (Object)DEFAULT_QUERY);
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        if (this.startIn == null) {
            try {
                this.startIn = (String)this.properties.get(SEARCH_IN_PROPERTY_NAME, (Object)Text.getAbsoluteParent((String)this.resource.getPath(), (int)1));
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        if (this.type == null) {
            try {
                this.type = (String)this.properties.get(TYPE_PROPERTY_NAME, (Object)TYPE_DEFAULT);
            }
            catch (NullPointerException npe) {
                this.type = TYPE_DEFAULT;
            }
        }
        if (this.orderBy == null) {
            try {
                this.orderBy = (String)this.properties.get(ORDER_BY_PROPERTY_NAME, null);
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        if (this.limit < 0) {
            try {
                this.limit = (Integer)this.properties.get(LIMIT_PROPERTY_NAME, (Object)100);
            }
            catch (NullPointerException npe) {
                this.limit = 100;
            }
        }
        if (this.pageMaximum < 0) {
            try {
                this.pageMaximum = (Integer)this.properties.get(PAGE_MAX_PROPERTY_NAME, (Object)-1);
            }
            catch (NullPointerException npe) {
                this.pageMaximum = -1;
            }
        }
        try {
            this.ordered = (Boolean)this.properties.get(ORDERED_PROPERTY_NAME, (Object)this.ordered);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (this.getParameter(PAGE_START_PARAM_NAME) != null) {
            try {
                this.pageStart = Integer.parseInt(this.getParameter(PAGE_START_PARAM_NAME));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.getParameter(PAGE_MAX_PARAM_NAME) != null) {
            try {
                this.pageMaximum = Integer.parseInt(this.getParameter(PAGE_MAX_PARAM_NAME));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean init() {
        if (!this.inited) {
            block23: {
                this.initConfig();
                if (this.pageIterator == null) {
                    try {
                        if (SOURCE_QUERYBUILDER.equals(this.source)) {
                            QueryBuilder queryBuilder = (QueryBuilder)this.resource.getResourceResolver().adaptTo(QueryBuilder.class);
                            Session session = (Session)this.resource.getResourceResolver().adaptTo(Session.class);
                            if (session == null || queryBuilder == null) break block23;
                            try {
                                Query query = queryBuilder.loadQuery(this.resource.getPath() + "/" + SAVEDQUERY_PROPERTY_NAME, session);
                                if (query != null) {
                                    query.setHitsPerPage((long)this.limit);
                                    SearchResult result = query.getResult();
                                    this.pageIterator = new HitBasedPageIterator(result.getHits().iterator());
                                    this.nodeIterator = result.getNodes();
                                }
                                break block23;
                            }
                            catch (Exception e) {
                                log.error("error loading stored querybuilder query from " + this.resource.getPath(), (Throwable)e);
                            }
                            break block23;
                        }
                        if (SOURCE_SEARCH.equals(this.source)) {
                            if (DEFAULT_QUERY.equals(this.query)) {
                                this.pageIterator = EmptyIterator.INSTANCE;
                            }
                            SimpleSearch search = this.getSearch(this.resource.getPath());
                            search.setQuery(this.query);
                            search.setSearchIn(this.startIn);
                            search.addPredicate(new Predicate("type", "type").set("type", "cq:Page"));
                            search.setHitsPerPage(100000L);
                            SearchResult result = search.getResult();
                            this.pageIterator = new HitBasedPageIterator(result.getHits().iterator());
                        } else if (SOURCE_CHILDREN.equals(this.source)) {
                            String path = (String)this.properties.get(PARENT_PAGE_PROPERTY_NAME, (Object)Text.getRelativeParent((String)this.resource.getPath(), (int)3));
                            try {
                                Page startPage = (Page)this.request.getResourceResolver().getResource(path).adaptTo(Page.class);
                                this.pageIterator = startPage.listChildren();
                            }
                            catch (NullPointerException npe) {
                                log.error("error building list from child pages", (Throwable)npe);
                            }
                        } else {
                            ArrayList<Page> staticPages = new ArrayList<Page>();
                            String[] statics = (String[])this.properties.get(PAGES_PROPERTY_NAME, (Object)new String[0]);
                            Resource pr = this.request.getResourceResolver().getResource(Text.getRelativeParent((String)this.resource.getPath(), (int)3));
                            PageManager pm = ((Page)pr.adaptTo(Page.class)).getPageManager();
                            for (int i = 0; i < statics.length; ++i) {
                                Page p = pm.getPage(statics[i]);
                                if (p == null) continue;
                                staticPages.add(p);
                            }
                            this.pageIterator = staticPages.iterator();
                        }
                    }
                    catch (Exception e) {
                        log.error("error creating page iterator", (Throwable)e);
                    }
                }
            }
            this.pages = new ArrayList<Page>();
            this.resources = new ArrayList<Resource>();
            if (this.pageIterator == null) {
                return false;
            }
            while (this.pageIterator.hasNext()) {
                Page page = this.pageIterator.next();
                this.pages.add(page);
            }
            if (this.orderComparator != null) {
                Collections.sort(this.pages, this.orderComparator);
            } else if (this.orderBy != null) {
                Collections.sort(this.pages, new PageComparator(this.orderBy));
            }
            if (this.pages.size() > this.limit) {
                this.pages = this.pages.subList(0, this.limit);
            }
            for (Page p : this.pages) {
                this.resources.add(p.getContentResource());
            }
            this.inited = true;
        }
        return true;
    }

    private void generateId() {
        String rootMarker;
        String path = this.resource.getPath();
        int root = path.indexOf(rootMarker = "jcr:content/");
        if (root >= 0) {
            path = path.substring(root + rootMarker.length());
        }
        this.id = path.replace('/', '_');
    }

    private SimpleSearch getSearch(String path) {
        try {
            Resource res = this.request.getResourceResolver().getResource(path);
            SimpleSearch search = (SimpleSearch)res.adaptTo(SimpleSearch.class);
            if (search != null) {
                return search;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path.lastIndexOf("/") > 0) {
            return this.getSearch(Text.getRelativeParent((String)path, (int)1));
        }
        return null;
    }

    private String getParameter(String name) {
        return this.request.getParameter(this.id + "_" + name);
    }

    public Iterator<Resource> getResources() {
        return this.init() && this.resources.size() > 0 ? this.resources.iterator() : null;
    }

    public Iterator<Page> getPages() {
        if (this.init() && this.pages.size() > 0) {
            ArrayList<Page> plist = new ArrayList<Page>();
            int c = 0;
            for (int i = 0; i < this.pages.size(); ++i) {
                if (i < this.pageStart) continue;
                plist.add(this.pages.get(i));
                if (this.pageMaximum > 0 && ++c == this.pageMaximum) break;
            }
            return plist.iterator();
        }
        return null;
    }

    public Iterator<Node> getNodes() {
        return this.init() ? this.nodeIterator : null;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isEmpty() {
        return this.init() ? this.resources.size() == 0 : true;
    }

    public int size() {
        return this.init() ? this.resources.size() : 0;
    }

    public boolean isPaginating() {
        return this.pageStart > 0 || this.pageMaximum > 0 && this.size() > this.pageMaximum;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public int getPageMaximum() {
        return this.pageMaximum;
    }

    public String getNextPageLink() {
        if (this.isPaginating() && this.pageMaximum > 0 && this.pageStart + this.pageMaximum < this.size()) {
            int start = this.pageStart + this.pageMaximum;
            PageLink link = new PageLink(this.request);
            link.setParameter(PAGE_START_PARAM_NAME, start);
            return link.toString();
        }
        return null;
    }

    public String getPreviousPageLink() {
        if (this.isPaginating() && this.pageStart > 0) {
            int start = this.pageMaximum > 0 && this.pageStart > this.pageMaximum ? this.pageStart - this.pageMaximum : 0;
            PageLink link = new PageLink(this.request);
            link.setParameter(PAGE_START_PARAM_NAME, start);
            return link.toString();
        }
        return null;
    }

    public void setSource(String src) {
        this.source = src;
    }

    public void setQuery(String q) {
        this.query = q;
    }

    public void setStartIn(String start) {
        this.startIn = start;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setOrderComparator(Comparator<Page> obc) {
        this.orderComparator = obc;
    }

    public void setOrderBy(String ob) {
        this.orderBy = ob;
    }

    public void setOrdered(boolean o) {
        this.ordered = o;
    }

    public void setLimit(int l) {
        this.limit = l;
    }

    public void setPageMaximum(int pm) {
        this.pageMaximum = pm;
    }

    public void setPageStart(int psi) {
        this.pageStart = psi;
    }

    public void setPageIterator(Iterator<Page> iter) {
        this.pageIterator = iter;
        this.setSource(SOURCE_STATIC);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HitBasedPageIterator
    implements Iterator<Page> {
        private Iterator<Hit> hits;
        private Page nextPage;

        public HitBasedPageIterator(Iterator<Hit> hits) {
            this.hits = hits;
            this.nextPage = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.nextPage != null;
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Page page = this.nextPage;
            this.nextPage = this.seek();
            return page;
        }

        private Page seek() {
            while (this.hits != null && this.hits.hasNext()) {
                try {
                    return (Page)this.hits.next().getResource().adaptTo(Page.class);
                }
                catch (RepositoryException e) {
                    log.error("Could not get page behind search result hit", (Throwable)e);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PageLink {
        private String path;
        private HashMap<String, Object> params;

        public PageLink(SlingHttpServletRequest request) {
            this.path = request.getPathInfo();
            this.initParams(request.getQueryString());
        }

        public void addParameter(String name, Object value) {
            name = this.prefixName(name);
            this.params.put(name, value);
        }

        public void setParameter(String name, Object value) {
            if (this.params.containsKey(name = this.prefixName(name))) {
                this.params.remove(name);
            }
            this.addParameter(name, value);
        }

        public String toString() {
            String url = this.path;
            for (String param : this.params.keySet()) {
                url = this.appendParam(url, param, this.params.get(param));
            }
            return url;
        }

        private String prefixName(String name) {
            if (!name.startsWith(List.this.id + "_")) {
                name = List.this.id + "_" + name;
            }
            return name;
        }

        private void initParams(String query) {
            String[] pairs;
            this.params = new HashMap();
            for (String pair : pairs = Text.explode((String)query, (int)38)) {
                String[] param = Text.explode((String)pair, (int)61, (boolean)true);
                this.params.put(param[0], param[1]);
            }
        }

        private String appendParam(String url, String name, Object value) {
            char delim = url.indexOf(63) > 0 ? (char)'&' : '?';
            return new StringBuffer(url).append(delim).append(name).append('=').append(value).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PageComparator<P extends Page>
    implements Comparator<P> {
        private String property;
        private boolean isDateProperty;

        public PageComparator(String prop) {
            this.property = prop;
            this.isDateProperty = this.isDate(prop);
        }

        @Override
        public int compare(P p1, P p2) {
            int comp = this.getKey(p1).compareTo(this.getKey(p2));
            return comp != 0 && this.isDateProperty ? -comp : comp;
        }

        private String getKey(P p) {
            return (String)p.getProperties().get(this.property, (Object)List.DEFAULT_QUERY);
        }

        private boolean isDate(String prop) {
            return prop.matches("jcr:created") || prop.matches("cq:lastModified") || prop.matches("cq:lastPublished");
        }
    }
}

