/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.FieldDescription;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import com.day.cq.wcm.foundation.forms.impl.FormsHandlingResponse;
import com.day.cq.wcm.foundation.forms.impl.ResourceWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class FieldHelper {
    private static final String ATTR_CACHE = FieldHelper.class.getName() + "/Cache";
    private static final String ATTR_INIT = FieldHelper.class.getName() + "/Init";
    private static final String ATTR_DESC = FieldHelper.class.getName() + "/CurrentDesc";

    private FieldHelper() {
    }

    private static String getCacheAttrName(Resource rsrc) {
        return ATTR_CACHE + rsrc.getPath();
    }

    private static String getInitAttrName(Resource rsrc) {
        return ATTR_INIT + rsrc.getPath();
    }

    public static FieldDescription createDefaultDescription(SlingHttpServletRequest req, Resource rsrc) {
        FieldDescription desc = new FieldDescription(rsrc);
        desc.update(rsrc);
        FieldHelper.addDescription(req, desc);
        return desc;
    }

    public static void addDescription(SlingHttpServletRequest req, FieldDescription desc) {
        String key = FieldHelper.getCacheAttrName(desc.getFieldResource());
        FieldDescription[] descs = (FieldDescription[])req.getAttribute(key);
        if (descs == null) {
            descs = new FieldDescription[]{desc};
        } else {
            FieldDescription[] newDescs = new FieldDescription[descs.length + 1];
            System.arraycopy(descs, 0, newDescs, 0, descs.length);
            newDescs[descs.length] = desc;
            descs = newDescs;
        }
        req.setAttribute(key, (Object)descs);
    }

    public static FieldDescription[] getFieldDescriptions(SlingHttpServletRequest req, Resource rsrc) {
        String key = FieldHelper.getCacheAttrName(rsrc);
        FieldDescription[] descs = (FieldDescription[])req.getAttribute(key);
        if (descs == null) {
            descs = new FieldDescription[]{FieldHelper.createDefaultDescription(req, rsrc)};
        }
        return descs;
    }

    public static void initializeField(SlingHttpServletRequest req, SlingHttpServletResponse res, Resource rsrc) throws ServletException, IOException {
        FieldHelper.initField(req, res, rsrc);
    }

    public static String getClientFieldQualifier(SlingHttpServletRequest request, FieldDescription desc) {
        String formId = FormsHelper.getFormId(request);
        return "document.forms[\"" + formId + "\"].elements[\"" + desc.getName() + "\"]";
    }

    public static FieldDescription getConstraintFieldDescription(SlingHttpServletRequest req) {
        FieldDescription desc = (FieldDescription)req.getAttribute(ATTR_DESC);
        if (desc == null) {
            desc = new FieldDescription(req.getResource());
            desc.update(req.getResource());
        }
        return desc;
    }

    public static void writeClientRequiredCheck(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc) throws IOException {
        String formId = FormsHelper.getFormId(request);
        if (desc.isRequired()) {
            PrintWriter out = response.getWriter();
            String qualifier = FieldHelper.getClientFieldQualifier(request, desc);
            out.write("if (cq5forms_isEmpty(");
            out.write(qualifier);
            out.write(")) {cq5forms_showMsg('");
            out.write(formId);
            out.write("','");
            out.write(desc.getName());
            out.write("','");
            out.write(desc.getRequiredMessage());
            out.write("'); return false; }\n");
        }
    }

    public static String getConstraintMessage(FieldDescription desc, SlingHttpServletRequest request) {
        String msg = desc.getConstraintMessage();
        if (msg == null) {
            ResourceResolver resourceResolver = request.getResourceResolver();
            String[] paths = resourceResolver.getSearchPath();
            for (int index = 0; index < paths.length && msg == null; ++index) {
                String scriptPath = paths[index] + request.getResource().getResourceType();
                try {
                    Resource scriptResource = resourceResolver.getResource(scriptPath);
                    if (scriptResource == null) continue;
                    ValueMap props = ResourceUtil.getValueMap((Resource)scriptResource);
                    msg = (String)props.get("constraintMessage", String.class);
                    continue;
                }
                catch (SlingException se) {
                    // empty catch block
                }
            }
            if (msg == null) {
                msg = "Field is not valid.";
            }
        }
        return msg;
    }

    public static void writeClientRegexpText(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc, String regexp) throws IOException {
        PrintWriter out = response.getWriter();
        String id = FieldHelper.getClientFieldQualifier(request, desc);
        out.write("{var obj =");
        out.write(id);
        out.write(";if ( cq5forms_isArray(obj)) {for(i=0;i<obj.length;i++) {if (!cq5forms_regcheck(obj[i].value, ");
        out.write(regexp);
        out.write(")) {cq5forms_showMsg('");
        out.write(FormsHelper.getFormId(request));
        out.write("','");
        out.write(desc.getName());
        out.write("','");
        out.write(FieldHelper.getConstraintMessage(desc, request));
        out.write("', i); return false;}}} else {if (!cq5forms_regcheck(obj.value, ");
        out.write(regexp);
        out.write(")) {cq5forms_showMsg('");
        out.write(FormsHelper.getFormId(request));
        out.write("','");
        out.write(desc.getName());
        out.write("','");
        out.write(FieldHelper.getConstraintMessage(desc, request));
        out.write("'); return false;}}}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClientConstraintCheck(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc) throws IOException, ServletException {
        if (desc.getConstraintType() != null) {
            PrintWriter out = response.getWriter();
            String qualifier = FieldHelper.getClientFieldQualifier(request, desc);
            out.write("if (!cq5forms_isEmpty(");
            out.write(qualifier);
            out.write(")){");
            try {
                request.setAttribute(ATTR_DESC, (Object)desc);
                ResourceWrapper includeResource = new ResourceWrapper(desc.getFieldResource(), desc.getConstraintType(), "foundation/components/form/defaults/constraint");
                FormsHelper.includeResource(request, response, includeResource, "clientvalidation");
                out.write("}");
            }
            finally {
                request.removeAttribute(ATTR_DESC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConstraint(SlingHttpServletRequest request, SlingHttpServletResponse response, FieldDescription desc) throws IOException, ServletException {
        boolean isEmpty;
        String value = request.getParameter(desc.getName());
        boolean bl = isEmpty = value == null || value.trim().length() == 0;
        if (!isEmpty && desc.getConstraintType() != null) {
            try {
                request.setAttribute(ATTR_DESC, (Object)desc);
                ResourceWrapper includeResource = new ResourceWrapper(desc.getFieldResource(), desc.getConstraintType(), "foundation/components/form/defaults/constraint");
                FormsHelper.includeResource(request, response, includeResource, "servervalidation");
            }
            finally {
                request.removeAttribute(ATTR_DESC);
            }
        }
    }

    public static boolean checkRequired(SlingHttpServletRequest request, FieldDescription desc) {
        boolean isEmpty;
        String value = request.getParameter(desc.getName());
        boolean bl = isEmpty = value == null || value.trim().length() == 0;
        if (desc.isRequired() && isEmpty) {
            ValidationInfo.createValidationInfo(request).addErrorMessage(desc.getName(), desc.getRequiredMessage());
            return false;
        }
        return true;
    }

    private static void initField(SlingHttpServletRequest req, SlingHttpServletResponse res, Resource rsrc) throws ServletException, IOException {
        String key = FieldHelper.getInitAttrName(rsrc);
        Object flag = req.getAttribute(key);
        if (flag == null) {
            req.setAttribute(key, (Object)Boolean.TRUE);
            FormsHelper.includeResource(req, (SlingHttpServletResponse)new FormsHandlingResponse(res), rsrc, "init");
        }
    }
}

