/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.api.PageEvent;
import com.day.cq.wcm.api.PageModification;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.event.EventUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormParagraphPostProcessor
implements EventHandler {
    private SlingRepository repository;
    private JcrResourceResolverFactory resolverFactory;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        PageEvent pageEvent;
        if (EventUtil.isLocal((Event)event) && (pageEvent = PageEvent.fromEvent((Event)event)) != null) {
            Session session = null;
            ResourceResolver resolver = null;
            Iterator i = pageEvent.getModifications();
            try {
                while (i.hasNext()) {
                    String contentPath;
                    Resource contentResource;
                    PageModification mod = (PageModification)i.next();
                    if (mod.getType() != PageModification.ModificationType.MODIFIED && mod.getType() != PageModification.ModificationType.CREATED) continue;
                    if (session == null) {
                        session = this.repository.loginAdministrative(null);
                        resolver = this.resolverFactory.getResourceResolver(session);
                    }
                    if ((contentResource = resolver.getResource(contentPath = mod.getPath() + '/' + "jcr:content")) == null) continue;
                    this.fixStructure(contentResource);
                }
            }
            catch (RepositoryException re) {
                this.logger.error("Unable to check page structure for form paragraphs: " + re.getMessage(), (Throwable)re);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    private void fixStructure(Resource contentResource) throws RepositoryException {
        Iterator rI = ResourceUtil.listChildren((Resource)contentResource);
        while (rI.hasNext()) {
            Resource res = (Resource)rI.next();
            if (ResourceUtil.isA((Resource)res, (String)"foundation/components/form/start")) {
                FormsHelper.checkFormStructure(res);
                continue;
            }
            if (ResourceUtil.isA((Resource)res, (String)"foundation/components/form/end")) {
                FormsHelper.checkFormStructure(res);
                continue;
            }
            this.fixStructure(res);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

