/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl.contentsync;

import com.day.cq.commons.DownloadResource;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.AbstractSlingResourceUpdateHandler;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.foundation.Download;
import com.day.cq.wcm.foundation.Image;
import com.day.cq.wcm.foundation.WCMRenditionPicker;
import com.day.cq.wcm.foundation.impl.contentsync.ResourceVisitor;
import com.day.text.Text;
import java.io.InputStream;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagesUpdateHandler
extends AbstractSlingResourceUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(PagesUpdateHandler.class);
    private static final String EXTENSION_CONFIG_PROPERTY = "extension";
    private static final String SELECTOR_CONFIG_PROPERTY = "selector";

    public boolean updateCacheEntry(ConfigEntry configEntry, Long lastUpdated, String configCacheRoot, Session admin, Session session) {
        ResourceResolver resolver = this.resolverFactory.getResourceResolver(admin);
        Page rootPage = ((PageManager)resolver.adaptTo(PageManager.class)).getPage(configEntry.getContentPath());
        boolean modified = false;
        boolean deep = (Boolean)((ValueMap)resolver.getResource(configEntry.getPath()).adaptTo(ValueMap.class)).get("deep", (Object)true);
        try {
            String uri = PagesUpdateHandler.buildURI(configEntry, rootPage);
            if (this.isModified(rootPage, uri, lastUpdated, configCacheRoot, admin)) {
                this.renderResource(uri, configCacheRoot, admin, session);
                this.rewritePaths(rootPage, uri, configCacheRoot, admin);
                this.collectImages(rootPage, configCacheRoot, admin);
                modified = true;
            }
            if (deep) {
                modified = this.renderChildren(configEntry, rootPage.listChildren(), lastUpdated, configCacheRoot, admin, session) || modified;
            }
        }
        catch (Exception e) {
            log.error("Rendering page failed: ", (Throwable)e);
        }
        return modified;
    }

    private boolean renderChildren(ConfigEntry configEntry, Iterator<Page> children, Long lastUpdated, String configCacheRoot, Session admin, Session session) throws Exception {
        boolean modified = false;
        while (children.hasNext()) {
            String uri;
            Page childPage = children.next();
            if (this.isModified(childPage, uri = PagesUpdateHandler.buildURI(configEntry, childPage), lastUpdated, configCacheRoot, admin)) {
                this.renderResource(uri, configCacheRoot, admin, session);
                this.rewritePaths(childPage, uri, configCacheRoot, admin);
                this.collectImages(childPage, configCacheRoot, admin);
                modified = true;
            }
            modified = this.renderChildren(configEntry, childPage.listChildren(), lastUpdated, configCacheRoot, admin, session) || modified;
        }
        return modified;
    }

    private boolean isModified(Page page, String uri, Long lastUpdated, String configCacheRoot, Session session) throws RepositoryException {
        long lastModified = page.getLastModified().getTime().getTime();
        return !session.nodeExists(configCacheRoot + uri) || lastUpdated < lastModified || lastModified == -1L;
    }

    private void collectImages(Page page, String configCacheRoot, Session session) throws RepositoryException {
        ComponentVisitor visitor = new ComponentVisitor(configCacheRoot, session);
        visitor.visit(page.getContentResource());
    }

    private static String buildURI(ConfigEntry entry, Page page) {
        String uri = page.getPath();
        if (entry.getValue(SELECTOR_CONFIG_PROPERTY) != null) {
            uri = uri + "." + entry.getValue(SELECTOR_CONFIG_PROPERTY);
        }
        if (entry.getValue(EXTENSION_CONFIG_PROPERTY) != null) {
            uri = uri + "." + entry.getValue(EXTENSION_CONFIG_PROPERTY);
        }
        return uri;
    }

    private void rewritePaths(Page page, String uri, String configCacheRoot, Session session) throws Exception {
        String cachePath = configCacheRoot + this.getTargetPath(uri);
        Property property = session.getProperty(cachePath + "/" + "jcr:content" + "/" + "jcr:data");
        String data = IOUtils.toString((InputStream)property.getBinary().getStream(), (String)"UTF-8");
        String prefix = this.getRelativePathPrefix(page);
        data = data.replaceAll("href=\"", "href=\"" + prefix);
        data = data.replaceAll("src=\"", "src=\"" + prefix);
        property.setValue(session.getValueFactory().createBinary(IOUtils.toInputStream((String)data, (String)"UTF-8")));
        session.save();
    }

    private String getRelativePathPrefix(Page page) {
        String prefix = "";
        try {
            prefix = StringUtils.repeat((String)"../", (int)(page.getDepth() - 1));
            prefix = StringUtils.removeEnd((String)prefix, (String)"/");
        }
        catch (Exception e) {
            prefix = "";
        }
        return prefix;
    }

    private class ComponentVisitor
    extends ResourceVisitor {
        private static final String IMAGE_RESOURCE_TYPE = "foundation/components/image";
        private static final String DOWNLOAD_RESOURCE_TYPE = "foundation/components/download";
        private String configCacheRoot;
        private Session session;
        private ResourceResolver resolver;

        public ComponentVisitor(String configCacheRoot, Session session) {
            this.configCacheRoot = configCacheRoot;
            this.session = session;
            this.resolver = PagesUpdateHandler.this.resolverFactory.getResourceResolver(session);
        }

        protected void accept(Resource res) {
            try {
                if (ResourceUtil.isA((Resource)res, (String)IMAGE_RESOURCE_TYPE)) {
                    Image image = new Image(res);
                    image.setSelector(".img");
                    this.updateDownloadResource((DownloadResource)image);
                } else if (ResourceUtil.isA((Resource)res, (String)DOWNLOAD_RESOURCE_TYPE)) {
                    Download download = new Download(res);
                    this.updateDownloadResource(download);
                }
            }
            catch (RepositoryException e) {
                log.error("Updating page dependencies failed: ", (Throwable)e);
            }
        }

        private void updateDownloadResource(DownloadResource download) throws RepositoryException {
            if (download.hasContent()) {
                String srcPath = download.getFileReference();
                if (!srcPath.equals("")) {
                    Rendition rendition;
                    Resource srcRes = this.resolver.getResource(srcPath);
                    if (srcRes != null && srcRes.adaptTo(Asset.class) != null && (rendition = ((Asset)srcRes.adaptTo(Asset.class)).getRendition((RenditionPicker)new WCMRenditionPicker())) != null && rendition.adaptTo(Node.class) != null) {
                        String cacheParentPath = this.configCacheRoot + Text.getRelativeParent((String)download.getHref(), (int)1);
                        Node parent = JcrUtil.createPath((String)cacheParentPath, (String)"sling:Folder", (Session)this.session);
                        JcrUtil.copy((Node)((Node)rendition.adaptTo(Node.class)), (Node)parent, (String)Text.getName((String)download.getHref()));
                    }
                } else {
                    srcPath = download.getFileNodePath();
                    Resource srcRes = this.resolver.getResource(srcPath);
                    if (srcRes != null) {
                        String cacheParentPath = this.configCacheRoot + Text.getRelativeParent((String)download.getHref(), (int)1);
                        Node parent = JcrUtil.createPath((String)cacheParentPath, (String)"sling:Folder", (Session)this.session);
                        JcrUtil.copy((Node)((Node)srcRes.adaptTo(Node.class)), (Node)parent, (String)Text.getName((String)download.getHref()));
                    }
                }
            }
        }
    }
}

