/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.graphics.Graph;
import com.day.cq.graphics.chart.BarChart;
import com.day.cq.graphics.chart.Data;
import com.day.cq.graphics.chart.Grid;
import com.day.cq.graphics.chart.LineChart;
import com.day.cq.graphics.chart.PieChart;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.foundation.Table;
import com.day.image.Font;
import com.day.image.Layer;
import com.day.image.LineStyle;
import com.day.image.font.AbstractFont;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class Chart {
    public static final String PIE_CHART_TYPE = "pie";
    public static final String BAR_CHART_TYPE = "bar";
    public static final String LINE_CHART_TYPE = "line";
    public static final String PN_TITLE = "jcr:title";
    public static final String PN_CHART_TYPE = "chartType";
    public static final String PN_ALT = "chartAlt";
    public static final String PN_DATA = "chartData";
    public static final String PN_WIDTH = "chartWidth";
    public static final String PN_HEIGHT = "chartHeight";
    public static final String PN_PC_START_ANGLE = "pieStartAngle";
    public static final String PN_LC_LINE_WIDTH = "lineLineWidth";
    public static final String PN_BC_BAR_WIDTH = "barBarWidth";
    public static final String PN_BC_BAR_SPACING = "barBarSpacing";
    public static final String PN_BG_COLOR = "bgColor";
    public static final String PN_LABEL_COLOR = "labelColor";
    public static final String PN_LINE_COLOR = "lineColor";
    public static final String PN_DATA_COLORS = "dataColors";
    public static final Color DEFAULT_DATA_COLOR = Color.BLUE;
    private final ValueMap properties;
    private Map<String, Object> overlaid = new HashMap<String, Object>();
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private Table table;
    private Color bgColor;
    private Color labelColor;
    private Color lineColor;
    private Font labelFont;
    private Font legendFont;
    private Font legendFontBold;
    private LineStyle lineStyle;
    private LineStyle gridLineStyle;
    private Double labelLsDef;
    private int labelLs;
    private double labelCs;
    private Double legendLsDef;
    private int legendLs;
    private double legendCs;
    ArrayList<String> dataColors = new ArrayList();
    private String[] labels;
    private String[] legends;
    private double[][] samples;
    private double maxValue = 0.0;

    public Chart(Resource resource) {
        this.properties = resource == null ? ValueMap.EMPTY : (ValueMap)resource.adaptTo(ValueMap.class);
        this.defaults.put(PN_WIDTH, 400);
        this.defaults.put(PN_HEIGHT, 200);
        this.defaults.put(PN_LINE_COLOR, "808080");
        this.defaults.put(PN_LABEL_COLOR, "808080");
        this.defaults.put(PN_CHART_TYPE, PIE_CHART_TYPE);
        this.defaults.put(PN_PC_START_ANGLE, 0.0);
        this.defaults.put(PN_LC_LINE_WIDTH, Float.valueOf(2.0f));
        this.defaults.put(PN_BC_BAR_WIDTH, 20);
        this.defaults.put(PN_BC_BAR_SPACING, 0);
        this.initChartData();
    }

    public boolean hasData() {
        boolean hasData = false;
        if (this.table != null) {
            for (Table.Row row : this.table.getRows()) {
                for (Table.Cell cell : row.getCells()) {
                    if (cell.getText() == null || cell.getText().equals("")) continue;
                    hasData = true;
                }
            }
        }
        return hasData;
    }

    public String getAlt() {
        return this.getString(PN_ALT);
    }

    public Object get(String name) {
        Object value = this.overlaid.get(name);
        if (value == null) {
            value = this.properties.get((Object)name);
        }
        if (value == null) {
            value = this.defaults.get(name);
        }
        return value;
    }

    public String getString(String name) {
        Object value = this.get(name);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public Integer getInt(String name) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            return (Integer)value;
        }
        return null;
    }

    public Double getDouble(String name) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            return (Double)value;
        }
        return null;
    }

    public Float getFloat(String name) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
            return (Float)value;
        }
        return null;
    }

    public Color getColor(String name) {
        String value = this.getString(name);
        Color color = null;
        if (value != null && !value.equals("")) {
            if (!value.startsWith("#")) {
                value = "#" + value;
            }
            color = Color.decode(value);
        }
        return color;
    }

    public void loadStyleData(Style style) {
        if (style != null) {
            this.overlaid.put(PN_LINE_COLOR, style.get((Object)PN_LINE_COLOR));
            this.overlaid.put(PN_LABEL_COLOR, style.get((Object)PN_LABEL_COLOR));
            this.overlaid.put(PN_BG_COLOR, style.get((Object)PN_BG_COLOR));
            this.overlaid.put(PN_DATA_COLORS, style.get((Object)PN_DATA_COLORS));
            this.overlaid.put(PN_PC_START_ANGLE, style.get((Object)PN_PC_START_ANGLE));
            this.overlaid.put(PN_LC_LINE_WIDTH, style.get((Object)PN_LC_LINE_WIDTH));
            this.overlaid.put(PN_BC_BAR_WIDTH, style.get((Object)PN_BC_BAR_WIDTH));
            this.overlaid.put(PN_BC_BAR_SPACING, style.get((Object)PN_BC_BAR_SPACING));
        }
        this.initStyle();
    }

    public Layer getChartLayer() throws IOException, RepositoryException {
        Graph graph = this.getGraph();
        this.setDataColors(graph);
        Layer layer = graph.draw(true);
        layer.setTransparency(new Color(-1, true));
        return layer;
    }

    public Layer getLegendLayer() throws IOException, RepositoryException {
        Graph graph = this.getGraph();
        this.setDataColors(graph);
        try {
            graph.draw(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        Layer layer = new Layer(1, 1, (Paint)this.bgColor);
        layer.setPaint((Paint)this.labelColor);
        if (this.get(PN_CHART_TYPE).equals(PIE_CHART_TYPE)) {
            int numlines = 0;
            String txt = this.labels[0];
            if (txt != "") {
                numlines = layer.drawText(0, 0, 165, 0, txt, (AbstractFont)this.labelFont, 65568, this.labelCs, this.labelLs);
            }
            layer.drawText(0, 0, 300, 0, "% of Total", (AbstractFont)this.labelFont, 65568, this.labelCs, this.labelLs);
            int y = numlines * (this.legendLs / 16) + this.legendLs / 32;
            ArrayList<Integer> linePos = new ArrayList<Integer>();
            linePos.add(y - 3);
            double sum = 0.0;
            for (int i = 0; i < this.legends.length; ++i) {
                txt = this.legends[i];
                numlines = layer.drawText(17, y, 185, 0, txt, (AbstractFont)this.legendFont, 65536, this.legendCs, this.legendLs);
                layer.drawText(0, y, 165, 0, String.valueOf(this.samples[i][0]), (AbstractFont)this.legendFont, 65568, this.legendCs, this.legendLs);
                txt = String.format("%.02f%%", graph.getYAxis().getTickSample(i));
                layer.drawText(0, y, 300, 0, txt, (AbstractFont)this.legendFont, 65568, this.legendCs, this.legendLs);
                Rectangle rect = new Rectangle(0, y, 15, 11);
                layer.setPaint((Paint)this.getDataColor(i));
                layer.fillRect((Rectangle2D)rect);
                layer.setPaint((Paint)this.labelColor);
                linePos.add(y + 12);
                y += numlines * (this.legendLs / 16) + this.legendLs / 32;
                sum += this.samples[i][0];
            }
            int heigth = layer.getHeight() + 7;
            layer.drawText(0, heigth, 0, 0, "Total", (AbstractFont)this.legendFontBold, 65536, this.labelCs, this.labelLs);
            txt = String.format("%s", sum);
            layer.drawText(0, heigth, 165, 0, txt, (AbstractFont)this.legendFontBold, 65568, this.labelCs, this.labelLs);
            layer.setPaint((Paint)this.lineColor);
            for (Integer ypos : linePos) {
                layer.drawLine(0.0f, (float)ypos.intValue(), 300.0f, (float)ypos.intValue());
            }
        } else {
            int y = 0;
            for (int i = 0; i < this.samples.length; ++i) {
                String txt = this.legends[i];
                int numlines = layer.drawText(20, y, 0, 0, txt, (AbstractFont)this.legendFont, 65536, this.legendCs, this.legendLs);
                Rectangle rect = new Rectangle(0, y, 15, 11);
                layer.setPaint((Paint)this.getDataColor(i));
                layer.fillRect((Rectangle2D)rect);
                layer.setPaint((Paint)this.labelColor);
                y += numlines * (this.legendLs / 16) + this.legendLs / 32;
            }
        }
        layer.setTransparency(new Color(-1, true));
        return layer;
    }

    private void initStyle() {
        this.bgColor = this.getColor(PN_BG_COLOR);
        this.labelColor = this.getColor(PN_LABEL_COLOR);
        this.lineColor = this.getColor(PN_LINE_COLOR);
        this.labelFont = new Font("verdana", 8);
        this.legendFont = new Font("verdana", 8);
        this.legendFontBold = new Font("verdana", 7, 1);
        this.lineStyle = new LineStyle((Paint)this.lineColor);
        this.gridLineStyle = new LineStyle((Paint)this.lineColor, 3.0f, 2.0f, 0.2f);
        this.labelLsDef = new Double(8.0) * 16.0 * 1.3;
        this.labelLs = this.labelLsDef.intValue();
        this.labelCs = 0.0;
        this.legendLsDef = new Double(8.0) * 16.0 * 1.3;
        this.legendLs = this.legendLsDef.intValue();
        this.legendCs = 0.0;
        String dataColorString = this.getString(PN_DATA_COLORS);
        if (dataColorString != null) {
            String[] dataColorValues;
            for (String dataColor : dataColorValues = dataColorString.split(":")) {
                this.dataColors.add("#" + dataColor);
            }
        }
    }

    private Color getDataColor(int index) {
        if (this.dataColors.size() == 0) {
            return DEFAULT_DATA_COLOR;
        }
        return Color.decode(this.dataColors.get(index % this.dataColors.size()));
    }

    private void setDataColors(Graph graph) {
        Data data = graph.getData();
        for (int row = 0; row < data.getNumrows(); ++row) {
            data.getDataRow(row).setColor(this.getDataColor(row));
        }
    }

    private Graph getGraph() {
        String chartType = this.getString(PN_CHART_TYPE);
        Graph graph = new Graph(this.getInt(PN_WIDTH).intValue(), this.getInt(PN_HEIGHT).intValue(), chartType);
        graph.initGraphSamples(this.labels, this.legends, this.samples);
        graph.setBgColor(this.bgColor);
        graph.setGrid(new Grid(graph, this.gridLineStyle));
        int yaWidth = ("" + this.maxValue).length() * 7;
        int xaHeight = 20;
        if (this.get(PN_CHART_TYPE).equals(PIE_CHART_TYPE)) {
            ((PieChart)graph.getChart()).setStart(this.getDouble(PN_PC_START_ANGLE).doubleValue());
            ((PieChart)graph.getChart()).setHeight(this.getInt(PN_HEIGHT).intValue());
            if (this.properties.get((Object)PN_WIDTH) == null) {
                ((PieChart)graph.getChart()).setWidth(this.getInt(PN_HEIGHT).intValue());
            } else {
                ((PieChart)graph.getChart()).setWidth(this.getInt(PN_WIDTH).intValue());
            }
        } else if (this.get(PN_CHART_TYPE).equals(LINE_CHART_TYPE)) {
            ((LineChart)graph.getChart()).setLinewidth(this.getFloat(PN_LC_LINE_WIDTH).floatValue());
            ((LineChart)graph.getChart()).setNumlines(this.getInt(PN_HEIGHT) / 10);
            this.initYAxis(graph, yaWidth, xaHeight);
            int xaWidth = this.initXAxis(graph, yaWidth, xaHeight);
            int xaTickDist = xaWidth / (this.table.getNumCols() - 2);
            graph.getXAxis().setTickdistance(xaTickDist);
        } else if (this.get(PN_CHART_TYPE).equals(BAR_CHART_TYPE)) {
            ((BarChart)graph.getChart()).setBarwidth(this.getInt(PN_BC_BAR_WIDTH).intValue());
            ((BarChart)graph.getChart()).setBarspacing(this.getInt(PN_BC_BAR_SPACING).intValue());
            ((BarChart)graph.getChart()).setStyle(1);
            ((BarChart)graph.getChart()).setNumlines(this.getInt(PN_HEIGHT) / 10);
            this.initYAxis(graph, yaWidth, xaHeight);
            int xaWidth = this.initXAxis(graph, yaWidth, xaHeight);
            int xaTickDist = xaWidth / (this.table.getNumCols() - 1);
            graph.getXAxis().setTickdistance(xaTickDist);
            graph.getXAxis().setRangetype(4);
        }
        return graph;
    }

    private int initXAxis(Graph graph, int yaWidth, int xaHeight) {
        int xaWidth = this.getInt(PN_WIDTH) - yaWidth;
        graph.getXAxis().setWidth(xaWidth);
        graph.getXAxis().setHeight(xaHeight);
        graph.getXAxis().setStyle(this.lineStyle);
        graph.getXAxis().setTickstyle(this.lineStyle);
        graph.getXAxis().setTickfrom(-4);
        graph.getXAxis().setTickto(0);
        graph.getXAxis().setLabelalign(32);
        graph.getXAxis().setLabelfont(this.labelFont);
        graph.getXAxis().setLabelcolor(this.labelColor);
        graph.getXAxis().setLabeltype(0);
        graph.getXAxis().setLabeldx(0);
        graph.getXAxis().setLabeldy(-4);
        return xaWidth;
    }

    private int initYAxis(Graph graph, int yaWidth, int xaHeight) {
        int yaHeight = this.getInt(PN_HEIGHT) - xaHeight;
        graph.getYAxis().setWidth(yaWidth + 5);
        graph.getYAxis().setStyle(this.lineStyle);
        int yaTickDist = this.getInt(PN_HEIGHT) / 10;
        graph.getYAxis().setTickdistance(yaTickDist);
        graph.getYAxis().setTickstyle(this.lineStyle);
        graph.getYAxis().setLabelalign(1);
        graph.getYAxis().setLabelfont(this.labelFont);
        graph.getYAxis().setLabelcolor(this.labelColor);
        graph.getYAxis().setLabeldx(-yaWidth);
        graph.getYAxis().setLabeldy(0);
        return yaHeight;
    }

    private void initChartData() {
        String data = this.getString(PN_DATA);
        if (data != null && !data.equals("")) {
            ArrayList<String> labels = new ArrayList<String>();
            ArrayList<String> legends = new ArrayList<String>();
            ArrayList<Double[]> samples = new ArrayList<Double[]>();
            this.table = Table.fromCSV(data, ',');
            List<Table.Row> rows = this.table.getRows();
            boolean firstRow = true;
            for (int i = 0; i < rows.size(); ++i) {
                List<Table.Cell> cells = rows.get(i).getCells();
                if (firstRow) {
                    firstRow = false;
                    for (int j = 0; j < cells.size(); ++j) {
                        if (cells.get(j).getText() != null) {
                            labels.add(cells.get(j).getText());
                            continue;
                        }
                        labels.add(" ");
                    }
                    continue;
                }
                legends.add(cells.get(0).getText());
                ArrayList<Double> dataRow = new ArrayList<Double>();
                for (int j = 1; j < cells.size(); ++j) {
                    String txt = cells.get(j).getText() != null ? cells.get(j).getText() : "0.0";
                    dataRow.add(Double.valueOf(txt));
                }
                samples.add(dataRow.toArray(new Double[0]));
            }
            int width = 0;
            int height = 0;
            for (Double[] row : samples) {
                if (row.length > width) {
                    width = row.length;
                }
                ++height;
            }
            this.labels = labels.toArray(new String[0]);
            this.legends = legends.toArray(new String[0]);
            this.samples = new double[height][width];
            for (int i = 0; i < samples.size(); ++i) {
                Double[] row = (Double[])samples.get(i);
                for (int j = 0; j < row.length; ++j) {
                    this.samples[i][j] = row[j];
                    if (!(row[j] > this.maxValue)) continue;
                    this.maxValue = row[j];
                }
            }
        }
    }
}

