/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.commons.PathInfo;
import com.day.cq.commons.servlets.NonExistingResourceServlet;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.components.IncludeOptions;
import com.day.cq.wcm.foundation.forms.FormResourceEdit;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.impl.FormsHandlingRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormChooserServlet
extends SlingAllMethodsServlet
implements NonExistingResourceServlet {
    private static final Logger log = LoggerFactory.getLogger(FormChooserServlet.class);
    private QueryBuilder queryBuilder;
    protected static final String SELECTOR = "form";
    protected static final String CREATE_SELECTOR = "create";
    protected static final String READ_ONLY_SELECTOR = "view";
    public static final String REQ_PARAM_PATH = "path";
    public static final String REQ_PARAM_QUERY = "query";
    public static final String PN_FORM_ALIAS = "cq:formAlias";
    public static final String PN_FORM_DEFAULT_RT = "cq:defaultFormFor";
    public static final String CONTENT_PATH = "/content";

    public boolean accepts(SlingHttpServletRequest request) {
        return FormChooserServlet.hasSelector(FormChooserServlet.getPathInfo(request), SELECTOR);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String formPath = this.findForm(request);
        if (formPath != null) {
            log.debug("using form: " + formPath);
            FormResourceEdit.setResources((ServletRequest)request, this.collectResources(request));
            if (this.isReadOnly(request)) {
                FormsHelper.setFormReadOnly(request);
            }
            this.forward(formPath, request, response);
        } else {
            log.debug("no form found");
            response.sendError(404, "No form found");
        }
    }

    protected boolean isReadOnly(SlingHttpServletRequest request) {
        return FormChooserServlet.hasSelector(request.getRequestPathInfo(), READ_ONLY_SELECTOR);
    }

    protected String findForm(SlingHttpServletRequest request) {
        List<String> list;
        RequestPathInfo pathInfo = FormChooserServlet.getPathInfo(request);
        String suffix = pathInfo.getSuffix();
        if (suffix != null) {
            return suffix;
        }
        String[] selectors = pathInfo.getSelectors();
        String formAlias = null;
        if (selectors.length > 1) {
            for (String selector : selectors) {
                if (selector.equals(SELECTOR) || selector.equals(CREATE_SELECTOR)) continue;
                formAlias = selector;
                break;
            }
        }
        if (formAlias != null && (list = this.search(null, PN_FORM_ALIAS, formAlias, request.getResourceResolver())).size() > 0) {
            return list.get(0);
        }
        list = this.search(null, PN_FORM_DEFAULT_RT, request.getResource().getResourceType(), request.getResourceResolver());
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    protected void forward(String path, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(null);
        options.setReplaceSuffix(null);
        StringBuffer includePath = new StringBuffer(path);
        IncludeOptions.getOptions((ServletRequest)request, (boolean)true).forceSameContext(true);
        includePath.append("/jcr:content");
        for (String selector : request.getRequestPathInfo().getSelectors()) {
            if (selector.equals(SELECTOR)) continue;
            includePath.append(".").append(selector);
        }
        includePath.append(".html");
        RequestDispatcher dispatcher = request.getRequestDispatcher(includePath.toString(), options);
        dispatcher.forward((ServletRequest)new FormsHandlingRequest(request), (ServletResponse)response);
    }

    protected List<String> search(String nodeType, String property, String value, ResourceResolver resolver) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        if (nodeType != null) {
            buffer.append("//element(*, ").append(nodeType).append(")");
        } else {
            buffer.append("//*");
        }
        buffer.append("[@");
        buffer.append(property);
        buffer.append("='");
        buffer.append(value);
        buffer.append("']");
        log.debug("Query: {}", (Object)buffer.toString());
        Iterator iter = resolver.findResources(buffer.toString(), "xpath");
        while (iter.hasNext()) {
            result.add(((Resource)iter.next()).getPath());
        }
        Collections.sort(result, new SearchPathComparator(this.getFormSearchPath(resolver)));
        return result;
    }

    protected List<String> getFormSearchPath(ResourceResolver resolver) {
        ArrayList<String> searchPath = new ArrayList<String>();
        searchPath.add(CONTENT_PATH);
        for (String path : resolver.getSearchPath()) {
            searchPath.add(path);
        }
        return searchPath;
    }

    protected List<Resource> collectResources(SlingHttpServletRequest request) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (FormChooserServlet.isNonExistingResource(request.getResource())) {
            String nonExistentPath = new PathInfo(request.getResource().getPath()).getResourcePath();
            resources.add((Resource)new NonExistingResource(request.getResourceResolver(), nonExistentPath));
            return resources;
        }
        if (FormChooserServlet.hasSelector(request.getRequestPathInfo(), CREATE_SELECTOR)) {
            String path = request.getResource().getPath();
            resources.add((Resource)new NonExistingResource(request.getResourceResolver(), path.endsWith("/") ? path : path + "/"));
            return resources;
        }
        String[] paths = request.getParameterValues(":resource");
        ResourceResolver resolver = request.getResourceResolver();
        if (request.getParameter(REQ_PARAM_QUERY) != null) {
            log.debug("resources defined by query");
            HashMap map = new HashMap(request.getParameterMap());
            map.remove(REQ_PARAM_QUERY);
            Session session = (Session)resolver.adaptTo(Session.class);
            if (session != null) {
                Query query = this.queryBuilder.createQuery(PredicateConverter.createPredicates(map), session);
                SearchResult result = query.getResult();
                for (Hit hit : result.getHits()) {
                    try {
                        resources.add(hit.getResource());
                    }
                    catch (RepositoryException e) {
                        log.error("could not get resource from hit", (Throwable)e);
                    }
                }
            } else {
                log.warn("cannot execute query: no session found in request");
            }
        } else if (paths != null && paths.length >= 1) {
            log.debug("multiple resources");
            resources.add(request.getResource());
            String resPath = request.getResource().getPath();
            for (String path : paths) {
                Resource res;
                if (resPath.equals(path) || (res = resolver.resolve(path)) == null) continue;
                resources.add(res);
            }
        } else {
            log.debug("single resource only");
            resources.add(request.getResource());
        }
        if (log.isDebugEnabled()) {
            for (Resource res : resources) {
                log.debug("resource: " + res);
            }
        }
        return resources;
    }

    public static boolean isNonExistingResource(Resource resource) {
        return "sling:nonexisting".equals(resource.getResourceType());
    }

    public static RequestPathInfo getPathInfo(SlingHttpServletRequest request) {
        if (FormChooserServlet.isNonExistingResource(request.getResource())) {
            return new PathInfo(request.getResource().getPath());
        }
        return request.getRequestPathInfo();
    }

    public static boolean hasSelector(RequestPathInfo pathInfo, String selector) {
        for (String s : pathInfo.getSelectors()) {
            if (!s.equals(selector)) continue;
            return true;
        }
        return false;
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchPathComparator
    implements Comparator<String> {
        private List<String> searchPath;

        public SearchPathComparator(List<String> searchPath) {
            this.searchPath = searchPath;
        }

        @Override
        public int compare(String path1, String path2) {
            int index1 = this.getSearchPathIndex(path1);
            int index2 = this.getSearchPathIndex(path2);
            return index2 - index1;
        }

        private int getSearchPathIndex(String path) {
            for (int i = 0; i < this.searchPath.size(); ++i) {
                if (!path.startsWith(this.searchPath.get(i))) continue;
                return i;
            }
            return this.searchPath.size() + 1;
        }
    }
}

