/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import com.day.cq.wcm.foundation.ParagraphSystem;
import com.day.text.Text;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnCtlPostProcessor
implements SlingPostProcessor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private Session adminSession;

    protected void activate(ComponentContext context) {
        try {
            this.adminSession = this.repository.loginAdministrative(null);
        }
        catch (RepositoryException e) {
            this.log.error("unable to initialize session.");
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.adminSession != null) {
            this.adminSession.logout();
            this.adminSession = null;
        }
    }

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        String rt;
        if (this.adminSession == null) {
            return;
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        String prt = request.getParameter("parentResourceType");
        if (prt != null && prt.length() == 0) {
            prt = null;
        }
        HashMap<String, String> parsys = new HashMap<String, String>();
        block9: for (Modification mod : changes) {
            switch (mod.getType()) {
                case DELETE: {
                    try {
                        rt = this.adminSession.getProperty(mod.getSource() + "/sling:resourceType").getString();
                        if (!rt.endsWith("/colctrl")) continue block9;
                        parsys.put(Text.getRelativeParent((String)mod.getSource(), (int)1), "");
                    }
                    catch (RepositoryException e) {}
                    break;
                }
                case ORDER: 
                case MOVE: 
                case COPY: {
                    break;
                }
                case MODIFY: 
                case CREATE: {
                    String path = mod.getSource();
                    if (!path.endsWith("/sling:resourceType")) break;
                    String rt2 = session.getProperty(path).getString();
                    String parSysPath = Text.getRelativeParent((String)path, (int)2);
                    if (rt2.endsWith("/colctrl")) {
                        parsys.put(parSysPath, Text.getRelativeParent((String)rt2, (int)1));
                        break;
                    }
                    if (prt == null) break;
                    try {
                        if (!session.propertyExists(parSysPath + "/sling:resourceType")) {
                            parsys.put(parSysPath, prt);
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                    prt = null;
                }
            }
        }
        for (String path : parsys.keySet()) {
            this.log.info("columns control modified - repairing parsys at {}", (Object)path);
            if (!session.propertyExists(path + "/sling:resourceType") && (rt = (String)parsys.get(path)).length() > 0) {
                session.getNode(path).setProperty("sling:resourceType", rt);
            }
            Resource res = request.getResourceResolver().getResource(path);
            ParagraphSystem p = new ParagraphSystem(res);
            p.repair();
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

