/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import com.day.cq.wcm.foundation.HierarchyModificationListener;
import com.day.text.Text;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyModificationListenerImpl
implements HierarchyModificationListener,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(HierarchyModificationListenerImpl.class);
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    protected Session session;
    private long startTime;
    private SlingRepository repository;
    private final Map<String, Long> modifications = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws RepositoryException {
        this.session = this.repository.loginAdministrative(null);
        this.startTime = System.currentTimeMillis();
        Map<String, Long> map = this.modifications;
        synchronized (map) {
            this.modifications.clear();
        }
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, "/content", true, null, null, true);
        log.info("Hierarchy Modification Listener started.");
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.session != null) {
            try {
                this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
            this.session.logout();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(String path) {
        Long lm;
        Map<String, Long> map = this.modifications;
        synchronized (map) {
            lm = this.modifications.get(path);
        }
        return lm == null ? this.startTime : lm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(EventIterator events) {
        HashSet<String> paths = new HashSet<String>();
        try {
            block9: while (events.hasNext()) {
                Event e = events.nextEvent();
                StringBuilder path = new StringBuilder();
                String aggregatePath = null;
                String[] names = Text.explode((String)e.getPath(), (int)47);
                int pageLevel = 0;
                while (pageLevel < names.length && !names[pageLevel].equals("jcr:content")) {
                    path.append("/").append(names[pageLevel]);
                    if (++pageLevel != 3) continue;
                    aggregatePath = path.toString();
                }
                int relLevel = names.length - pageLevel;
                if (log.isDebugEnabled()) {
                    log.debug("Modification on {}. page={}, pageLevel={}, relLevel={}", new Object[]{e.getPath(), path, pageLevel, relLevel});
                }
                if (aggregatePath == null || pageLevel > 6) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Rejecting {} cause out of scope. level {} not within [3,6]", (Object)path, (Object)pageLevel);
                    continue;
                }
                switch (e.getType()) {
                    case 1: 
                    case 2: 
                    case 32: {
                        if (relLevel <= 0) break;
                        if (!log.isDebugEnabled()) continue block9;
                        log.debug("Rejecting {} cause node modification in jcr:content", (Object)path);
                        continue block9;
                    }
                    case 4: 
                    case 8: 
                    case 16: {
                        if (relLevel > 2) {
                            if (!log.isDebugEnabled()) continue block9;
                            log.debug("Rejecting {} cause property modification not on jcr:content", (Object)path);
                            continue block9;
                        }
                        if (!IGNORED_PROPERTIES.contains(names[names.length - 1])) break;
                        if (!log.isDebugEnabled()) continue block9;
                        log.debug("Rejecting {} cause property is ignored", (Object)path);
                        continue block9;
                    }
                }
                paths.add(aggregatePath);
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while reading event info", (Throwable)e);
        }
        Long lm = System.currentTimeMillis();
        Map<String, Long> map = this.modifications;
        synchronized (map) {
            for (String path : paths) {
                log.debug("Touching {} at {}", (Object)path, (Object)lm);
                this.modifications.put(path, lm);
            }
        }
    }

    static {
        IGNORED_PROPERTIES.add("jcr:lastModified");
        IGNORED_PROPERTIES.add("jcr:lastModifiedBy");
        IGNORED_PROPERTIES.add("cq:lastModified");
        IGNORED_PROPERTIES.add("cq:lastModifiedBy");
        IGNORED_PROPERTIES.add("cq:lastReplicated");
        IGNORED_PROPERTIES.add("cq:lastReplicatedBy");
        IGNORED_PROPERTIES.add("cq:lastReplicationAction");
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

