/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.ValidationInfo;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;

public class LayoutHelper {
    private LayoutHelper() {
    }

    public static void printTitle(String fieldId, String title, boolean required, Writer out) throws IOException {
        LayoutHelper.printTitle(fieldId, title, false, required, out);
    }

    public static void printTitle(String fieldId, String title, boolean required, boolean hideLabel, Writer out) throws IOException {
        out.write("<div class=\"form_leftcol\"");
        if (hideLabel) {
            out.write(" style=\"display: none;\"");
        }
        title = title != null && title.length() > 0 ? Text.encodeIllegalXMLCharacters((String)title) : "&nbsp;";
        out.write(">");
        out.write("<div class=\"form_leftcollabel\">");
        if (fieldId != null) {
            out.write("<label for=\"" + fieldId + "\">" + title + "</label>");
        } else {
            out.write("<span>" + title + "</span>");
        }
        out.write("</div>");
        out.write("<div class=\"form_leftcolmark\">");
        if (!hideLabel) {
            if (required) {
                out.write(" *");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</div>");
        out.write("</div>\n");
    }

    public static void printDescription(String descr, Writer out) throws IOException {
        out.write("<div class=\"form_row_description\">");
        if (descr != null && descr.length() > 0) {
            out.write("<span>" + Text.encodeIllegalXMLCharacters((String)descr) + "</span>");
        }
        out.write("</div>\n");
    }

    public static void printErrors(SlingHttpServletRequest request, String fieldName, Writer out) throws IOException {
        LayoutHelper.printErrors(request, fieldName, false, out);
    }

    public static void printErrors(SlingHttpServletRequest request, String fieldName, Writer out, int valueIndex) throws IOException {
        LayoutHelper.printErrors(request, fieldName, false, out, valueIndex);
    }

    public static void printErrors(SlingHttpServletRequest request, String fieldName, boolean hideLabel, Writer out) throws IOException {
        String[] msgs;
        ValidationInfo info = ValidationInfo.getValidationInfo((HttpServletRequest)request);
        if (info != null && (msgs = info.getErrorMessages(fieldName)) != null) {
            for (String msg : msgs) {
                out.write("<div class=\"form_row\">");
                LayoutHelper.printTitle(null, null, false, hideLabel, out);
                out.write("<div class=\"form_rightcol form_error\">");
                out.write(Text.encodeIllegalXMLCharacters((String)msg));
                out.write("</div>");
                out.write("</div>");
            }
        }
    }

    public static void printErrors(SlingHttpServletRequest request, String fieldName, boolean hideLabel, Writer out, int valueIndex) throws IOException {
        String[] msgs;
        ValidationInfo info = ValidationInfo.getValidationInfo((HttpServletRequest)request);
        if (info != null && (msgs = info.getErrorMessages(fieldName, valueIndex)) != null) {
            for (String msg : msgs) {
                out.write("<div class=\"form_row\">");
                LayoutHelper.printTitle(null, null, false, hideLabel, out);
                out.write("<div class=\"form_rightcol form_error\">");
                out.write(Text.encodeIllegalXMLCharacters((String)msg));
                out.write("</div>");
                out.write("</div>");
            }
        }
    }
}

