/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.ImageResource;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.ImageMap;
import com.day.cq.wcm.foundation.WCMRenditionPicker;
import com.day.text.Text;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
extends ImageResource {
    public static final String PN_IMAGE_MAP = "imageMap";
    private String imageMapId;
    private ImageMap imageMap = null;
    private boolean noPlaceholder;

    public Image(Resource resource) {
        super(resource);
        if (this.properties.containsKey((Object)PN_IMAGE_MAP)) {
            try {
                String mapDefinition = (String)this.properties.get(PN_IMAGE_MAP, (Object)"");
                if (mapDefinition.length() > 0) {
                    this.imageMap = ImageMap.fromString(mapDefinition);
                    this.imageMapId = "map_" + Math.round(Math.random() * 2.147483647E9) + "_" + System.currentTimeMillis();
                }
            }
            catch (IllegalArgumentException iae) {
                this.imageMap = null;
                this.imageMapId = null;
            }
        }
    }

    public Image(Resource resource, String imageName) {
        this(Image.getRelativeResource((Resource)resource, (String)imageName));
    }

    public void setDropTargetId(String id, String classifier) {
        if (classifier == null) {
            classifier = "";
        }
        if (!classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        this.addCssClass("cq-dd-" + id + classifier);
    }

    public void setDropTargetId(String id) {
        String classifier = ResourceUtil.isNonExistingResource((Resource)this) ? String.valueOf(System.currentTimeMillis()) : Text.getName((String)this.getPath());
        this.setDropTargetId(id, classifier);
    }

    public boolean hasNoPlaceholder() {
        return this.noPlaceholder;
    }

    public void setNoPlaceholder(boolean noPlaceholder) {
        this.noPlaceholder = noPlaceholder;
    }

    public void loadStyleData(Style style) {
        if (style != null) {
            this.set("minWidth", (String)style.get("minWidth", (Object)""));
            this.set("minHeight", (String)style.get("minHeight", (Object)""));
            this.set("maxWidth", (String)style.get("maxWidth", (Object)""));
            this.set("maxHeight", (String)style.get("maxHeight", (Object)""));
        }
    }

    protected boolean canDraw() {
        return !this.noPlaceholder || this.hasContent();
    }

    protected Map<String, String> getImageTagAttributes() {
        String src = null;
        if (!this.hasContent()) {
            src = "/etc/designs/default/0.gif";
            this.addCssClass("cq-image-placeholder");
        }
        Map attributes = super.getImageTagAttributes();
        if (src != null) {
            attributes.put("src", src);
        }
        if (this.imageMap != null) {
            attributes.put("usemap", "#" + this.imageMapId);
        }
        return attributes;
    }

    protected void doDraw(PrintWriter w) {
        super.doDraw(w);
        if (this.imageMap != null) {
            w.print(this.imageMap.draw(this.imageMapId));
        }
    }

    public String getIconPath() {
        Component c = WCMUtils.getComponent((Resource)this);
        if (c == null) {
            return null;
        }
        Resource icon = c.getLocalResource("resources/" + this.getIconType() + ".gif");
        if (icon == null) {
            icon = c.getLocalResource("resources/default.gif");
        }
        return icon == null ? null : icon.getPath();
    }

    protected Resource getReferencedResource(String path) {
        Resource res = super.getReferencedResource(path);
        if (res != null && res.adaptTo(Asset.class) != null) {
            Rendition rendition = ((Asset)res.adaptTo(Asset.class)).getRendition((RenditionPicker)new WCMRenditionPicker());
            res = null != rendition ? (Resource)rendition.adaptTo(Resource.class) : null;
        }
        return res;
    }
}

