/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.foundation.impl.Rewriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class External {
    private static final Logger log = LoggerFactory.getLogger(External.class);
    public static final String PN_TARGET = "target";
    public static final String PN_INCLUSION = "inclusion";
    public static final String PN_LIMIT = "limit";
    public static final String PN_PASSPARAMS = "passparams";
    public static final String PN_WIDTH = "width";
    public static final String PN_HEIGHT = "height";
    public static final String PV_FIXED = "fixed";
    protected final Resource resource;
    protected final ValueMap properties;
    protected final Node node;
    protected final String pagePath;
    protected final String resourcePath;
    protected final String postSelector;
    protected final String targetParam;
    protected String target;

    public External(Resource resource, Page page, String spoolSelector, String postSelector, String targetParam) {
        this.resource = resource;
        this.properties = resource == null ? ValueMap.EMPTY : (ValueMap)resource.adaptTo(ValueMap.class);
        this.node = resource == null ? null : (Node)resource.adaptTo(Node.class);
        this.pagePath = page.getPath();
        this.resourcePath = resource.getPath() + "." + spoolSelector;
        this.postSelector = postSelector;
        this.targetParam = targetParam;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean hasContent() {
        return this.getTarget() != null;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return this.getStringProperty(PN_TARGET);
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean passParameters() {
        return "true".equals(this.getStringProperty(PN_PASSPARAMS));
    }

    public boolean isFixed() {
        return PV_FIXED.equals(this.getStringProperty(PN_INCLUSION));
    }

    public String getWidth() {
        return this.getStringProperty(PN_WIDTH, "100%");
    }

    public String getHeight() {
        return this.getStringProperty(PN_HEIGHT, "100%");
    }

    public Limit getLimit() {
        String s = this.getStringProperty(PN_LIMIT);
        if (s != null) {
            try {
                return Limit.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                log.warn("Value of limit illegal: " + s);
            }
        }
        return Limit.NO;
    }

    private String getStringProperty(String name) {
        return this.getStringProperty(name, null);
    }

    private String getStringProperty(String name, String defaultValue) {
        try {
            if (this.node.hasProperty(name)) {
                return this.node.getProperty(name).getString();
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to retrieve property " + name, (Throwable)e);
        }
        return defaultValue;
    }

    public void draw(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String target = this.getTarget();
        if (target == null) {
            return;
        }
        if (this.isFixed()) {
            PrintWriter writer = response.getWriter();
            writer.println("<iframe src=\"");
            writer.println(target);
            writer.println("\" width=\"");
            writer.println(this.getWidth());
            writer.println("\" height=\"");
            writer.println(this.getHeight());
            writer.println("\"></iframe>");
            return;
        }
        Rewriter rewriter = new Rewriter(this.pagePath, this.resourcePath, target, this.postSelector, this.targetParam);
        rewriter.setPassInput(this.passParameters());
        rewriter.setLimit(this.getLimit());
        rewriter.rewrite(request, response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Limit {
        NO("no"),
        HOST("host"),
        OFF("off");

        private final String value;

        private Limit(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

