/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMap {
    private static final Logger log = LoggerFactory.getLogger(ImageMap.class);
    private final List<ImageArea> areas = new ArrayList<ImageArea>(10);

    public static ImageMap fromString(String mapDefinition) throws IllegalArgumentException {
        ImageMap theMap = new ImageMap();
        theMap.createFromString(mapDefinition);
        return theMap;
    }

    private ImageMap() {
    }

    private Object[] decodeFromContainingString(String containingString, int parseStartPos) {
        int quotPos = containingString.indexOf("\"", parseStartPos);
        if (quotPos < 0) {
            throw new IllegalArgumentException("No opening quotation mark found in string.");
        }
        boolean isDone = false;
        int currentCharPos = quotPos + 1;
        StringBuilder text = new StringBuilder(128);
        boolean isEscaped = false;
        while (!isDone) {
            char charToProcess = containingString.charAt(currentCharPos);
            if (charToProcess == '\"' && !isEscaped) {
                isDone = true;
            } else if (charToProcess == '\\') {
                if (isEscaped) {
                    text.append("\\");
                    isEscaped = false;
                } else {
                    isEscaped = true;
                }
            } else if (isEscaped) {
                text.append(charToProcess);
                isEscaped = false;
            } else {
                text.append(charToProcess);
            }
            if (++currentCharPos < containingString.length() || isDone) continue;
            throw new IllegalArgumentException("No final quotation mark found in string.");
        }
        return new Object[]{text.toString(), currentCharPos};
    }

    private Object[] parseAreaDestination(String value, int parseStartPos) throws IllegalArgumentException {
        Object[] parseResult;
        char charToCheck;
        int parsePos = parseStartPos;
        String url = null;
        if (parsePos < value.length()) {
            charToCheck = value.charAt(parsePos);
            if (charToCheck != '|') {
                parseResult = this.decodeFromContainingString(value, parsePos);
                url = (String)parseResult[0];
                parsePos = (Integer)parseResult[1];
            }
            ++parsePos;
        }
        String target = null;
        if (parsePos < value.length()) {
            charToCheck = value.charAt(parsePos);
            if (charToCheck != '|') {
                parseResult = this.decodeFromContainingString(value, parsePos);
                target = (String)parseResult[0];
                parsePos = (Integer)parseResult[1];
            }
            ++parsePos;
        }
        String text = null;
        if (parsePos < value.length() && (charToCheck = value.charAt(parsePos)) != ']') {
            parseResult = this.decodeFromContainingString(value, parsePos);
            if (parseResult == null) {
                return null;
            }
            text = (String)parseResult[0];
            parsePos = (Integer)parseResult[1];
        }
        return new Object[]{url, target, text, parsePos + 1};
    }

    private void createFromString(String strDefinition) throws IllegalArgumentException {
        int coordEndPos;
        int startPos;
        this.areas.clear();
        int processingPos = 0;
        while (processingPos < strDefinition.length() && (startPos = strDefinition.indexOf("[", processingPos)) >= 0 && (coordEndPos = strDefinition.indexOf(")", startPos + 1)) >= 0) {
            String areaDef = strDefinition.substring(startPos + 1, coordEndPos + 1);
            int contentStartPos = areaDef.indexOf("(");
            if (contentStartPos < 0) {
                throw new IllegalArgumentException("Could not create image map; area definition is not in format 'type(coords)...'.");
            }
            String type = areaDef.substring(0, contentStartPos);
            String coords = areaDef.substring(contentStartPos + 1, areaDef.length() - 1);
            Object[] areaDestination = this.parseAreaDestination(strDefinition, coordEndPos + 1);
            processingPos = (Integer)areaDestination[3];
            String url = (String)areaDestination[0];
            String target = (String)areaDestination[1];
            String text = (String)areaDestination[2];
            this.areas.add(new ImageArea(type, coords, url, text, target));
        }
    }

    public String draw(String id) {
        StringBuilder htmlCode = new StringBuilder(128);
        htmlCode.append("<map name=\"").append(id).append("\">");
        for (ImageArea areaToDraw : this.areas) {
            String target;
            String altText;
            htmlCode.append("<area shape=\"").append(areaToDraw.getType()).append("\"");
            String coords = areaToDraw.getCoordinates();
            htmlCode.append(" coords=\"").append(coords).append("\"");
            String href = areaToDraw.getHref();
            if (href != null) {
                if (href.startsWith("/")) {
                    int extensionPos = href.lastIndexOf(".");
                    int slashPos = href.lastIndexOf("/");
                    if (extensionPos < 0 || extensionPos < slashPos) {
                        href = href + ".html";
                    }
                }
                htmlCode.append(" href=\"").append(href).append("\"");
            }
            if ((altText = areaToDraw.getAltText()) != null) {
                htmlCode.append(" alt=\"").append(StringEscapeUtils.escapeHtml4((String)altText)).append("\"");
                htmlCode.append(" title=\"").append(StringEscapeUtils.escapeHtml4((String)altText)).append("\"");
            }
            if ((target = areaToDraw.getTarget()) != null) {
                htmlCode.append(" target=\"").append(target).append("\"");
            }
            htmlCode.append(">");
        }
        htmlCode.append("</map>");
        log.debug("Image map HTML code: {}", (Object)htmlCode);
        return htmlCode.toString();
    }

    public class ImageArea {
        private final String type;
        private final String coordinates;
        private final String href;
        private final String altText;
        private final String target;

        protected ImageArea(String type, String coordinates, String href, String altText, String target) {
            log.debug("Creating image area; destination: {}; altText: {}; target: {}", new Object[]{href, altText, target});
            this.type = type;
            this.coordinates = coordinates;
            this.href = href;
            this.altText = altText;
            this.target = target;
        }

        public String getType() {
            return this.type;
        }

        public String getCoordinates() {
            return this.coordinates;
        }

        public String getHref() {
            return this.href;
        }

        public String getAltText() {
            return this.altText;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

