/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.FieldDescription;
import com.day.cq.wcm.foundation.forms.FieldHelper;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;

public class ValidationInfo {
    private static final String GLOBAL = "";
    private final Map<String, String[]> messages;
    private final Map<String, String[]> values;
    private final String formId;
    private final ResourceBundle resBundle;
    private static final String REQ_ATTR = ValidationInfo.class.getName();

    public ValidationInfo(SlingHttpServletRequest request) {
        this.formId = FormsHelper.getFormId(request);
        this.values = new HashMap<String, String[]>();
        Iterator<String> nameIter = FormsHelper.getContentRequestParameterNames(request);
        while (nameIter.hasNext()) {
            String[] values;
            String name = nameIter.next();
            RequestParameter reqParam = request.getRequestParameter(name);
            if (reqParam == null || !reqParam.isFormField() || (values = request.getParameterValues(name)) == null || values.length <= 0) continue;
            this.values.put(name, values);
        }
        this.messages = new HashMap<String, String[]>();
        Locale locale = FormsHelper.getLocale(request);
        this.resBundle = request.getResourceBundle(locale);
        request.setAttribute(REQ_ATTR, (Object)this);
    }

    public String[] getValues(String field) {
        return this.values.get(field);
    }

    public void addErrorMessage(String field, String msg) {
        if (this.resBundle == null) {
            throw new IllegalStateException("Validation info is not mutable. The ResourceBundle of the request is not defined for the request locale.");
        }
        if (field == null) {
            field = GLOBAL;
        }
        msg = this.resBundle.getString(msg);
        String[] msgs = this.messages.get(field);
        if (msgs == null) {
            this.messages.put(field, new String[]{msg});
        } else {
            String[] newMsgs = new String[msgs.length + 1];
            System.arraycopy(msgs, 0, newMsgs, 0, msgs.length);
            newMsgs[msgs.length] = msg;
            this.messages.put(field, newMsgs);
        }
    }

    public static void addConstraintError(SlingHttpServletRequest request, FieldDescription desc) {
        ValidationInfo.createValidationInfo(request).addErrorMessage(desc.getName(), FieldHelper.getConstraintMessage(desc, request));
    }

    public static void addConstraintError(SlingHttpServletRequest request, FieldDescription desc, int valueIndex) {
        ValidationInfo.createValidationInfo(request).addErrorMessage(desc.getName() + ':' + valueIndex, FieldHelper.getConstraintMessage(desc, request));
    }

    public String getFormId() {
        return this.formId;
    }

    public String[] getErrorMessages(String field) {
        if (field == null) {
            field = GLOBAL;
        }
        return this.messages.get(field);
    }

    public String[] getErrorMessages(String field, int valueIndex) {
        if (field == null) {
            field = GLOBAL;
        }
        return this.messages.get(field + ':' + valueIndex);
    }

    public static ValidationInfo getValidationInfo(HttpServletRequest req) {
        String currentFormId;
        ValidationInfo info = (ValidationInfo)req.getAttribute(REQ_ATTR);
        if (info != null && !(currentFormId = (String)req.getAttribute("cq.form.id")).equals(info.getFormId())) {
            info = null;
        }
        return info;
    }

    public static ValidationInfo createValidationInfo(SlingHttpServletRequest req) {
        ValidationInfo info = ValidationInfo.getValidationInfo((HttpServletRequest)req);
        if (info == null) {
            info = new ValidationInfo(req);
        }
        return info;
    }
}

