/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.mailer.MailService;
import com.day.cq.wcm.foundation.forms.FieldDescription;
import com.day.cq.wcm.foundation.forms.FieldHelper;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.activation.DataSource;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.core.AuthUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServlet
extends SlingAllMethodsServlet
implements OptingServlet {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "mail";
    protected static final String MAILTO_PROPERTY = "mailto";
    protected static final String CC_PROPERTY = "cc";
    protected static final String BCC_PROPERTY = "bcc";
    protected static final String SUBJECT_PROPERTY = "subject";
    protected static final String FROM_PROPERTY = "from";
    protected MailService mailService;

    public boolean accepts(SlingHttpServletRequest request) {
        return EXTENSION.equals(request.getRequestPathInfo().getExtension());
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        MailService localService = this.mailService;
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            this.logger.debug("Received fake request!");
            response.setStatus(500);
            return;
        }
        ResourceBundle resBundle = request.getResourceBundle(null);
        ValueMap values = ResourceUtil.getValueMap((Resource)request.getResource());
        String[] mailTo = (String[])values.get(MAILTO_PROPERTY, String[].class);
        int status = 200;
        if (mailTo == null || mailTo.length == 0 || mailTo[0].length() == 0) {
            this.logger.error("The mailto configuration is missing in the form begin at " + request.getResource().getPath());
            status = 500;
        } else if (localService == null) {
            this.logger.error("The mail service is currently not available! Unable to send form mail.");
            status = 500;
        } else {
            try {
                String[] bccRecs;
                SimpleEmail email;
                StringBuilder builder = new StringBuilder();
                builder.append(request.getScheme());
                builder.append("://");
                builder.append(request.getServerName());
                if (request.getScheme().equals("https") && request.getServerPort() != 443 || request.getScheme().equals("http") && request.getServerPort() != 80) {
                    builder.append(':');
                    builder.append(request.getServerPort());
                }
                builder.append(request.getRequestURI());
                StringBuilder buffer = new StringBuilder();
                String text = resBundle.getString("You've received a new form based mail from {0}.");
                text = text.replace("{0}", builder.toString());
                buffer.append(text);
                buffer.append("\n\n");
                buffer.append(resBundle.getString("Values"));
                buffer.append(":\n\n");
                ArrayList<String> contentNamesList = new ArrayList<String>();
                Iterator<String> names = FormsHelper.getContentRequestParameterNames(request);
                while (names.hasNext()) {
                    String name = names.next();
                    contentNamesList.add(name);
                }
                Collections.sort(contentNamesList);
                ArrayList<String> namesList = new ArrayList<String>();
                Iterator<Resource> fields = FormsHelper.getFormElements(request.getResource());
                while (fields.hasNext()) {
                    Resource field = fields.next();
                    FieldDescription[] descs = FieldHelper.getFieldDescriptions(request, field);
                    for (FieldDescription desc : descs) {
                        contentNamesList.remove(desc.getName());
                        if (desc.isPrivate()) continue;
                        namesList.add(desc.getName());
                    }
                }
                namesList.addAll(contentNamesList);
                ArrayList<RequestParameter> attachments = new ArrayList<RequestParameter>();
                for (String name : namesList) {
                    RequestParameter rp = request.getRequestParameter(name);
                    if (rp == null) {
                        this.logger.debug("skipping form element {} from mail content because it's not in the request", (Object)name);
                        continue;
                    }
                    if (rp.isFormField()) {
                        String[] pValues;
                        buffer.append(name);
                        buffer.append(" : \n");
                        for (String v : pValues = request.getParameterValues(name)) {
                            buffer.append(v);
                            buffer.append("\n");
                        }
                        buffer.append("\n");
                        continue;
                    }
                    if (rp.getSize() <= 0L) continue;
                    attachments.add(rp);
                }
                if (attachments.size() > 0) {
                    buffer.append("\n");
                    buffer.append(resBundle.getString("Attachments"));
                    buffer.append(":\n");
                    MultiPartEmail mpEmail = new MultiPartEmail();
                    email = mpEmail;
                    for (RequestParameter rp : attachments) {
                        ByteArrayDataSource ea = new ByteArrayDataSource(rp.getInputStream(), rp.getContentType());
                        mpEmail.attach((DataSource)ea, rp.getFileName(), rp.getFileName());
                        buffer.append("- ");
                        buffer.append(rp.getFileName());
                        buffer.append("\n");
                    }
                } else {
                    email = new SimpleEmail();
                }
                email.setCharset("utf-8");
                email.setMsg(buffer.toString());
                for (String rec : mailTo) {
                    email.addTo(rec);
                }
                String[] ccRecs = (String[])values.get(CC_PROPERTY, String[].class);
                if (ccRecs != null) {
                    for (String rec : ccRecs) {
                        email.addCc(rec);
                    }
                }
                if ((bccRecs = (String[])values.get(BCC_PROPERTY, String[].class)) != null) {
                    for (String rec : bccRecs) {
                        email.addBcc(rec);
                    }
                }
                String subject = (String)values.get(SUBJECT_PROPERTY, (Object)resBundle.getString("Form Mail"));
                email.setSubject(subject);
                String fromAddress = (String)values.get(FROM_PROPERTY, (Object)"");
                if (fromAddress.length() > 0) {
                    email.setFrom(fromAddress);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Sending form activated mail: fromAddress={}, to={}, subject={}, text={}.", new Object[]{fromAddress, mailTo, subject, buffer});
                }
                localService.sendEmail((Email)email);
            }
            catch (EmailException e) {
                this.logger.error("Error sending email: " + e.getMessage(), (Throwable)e);
                status = 500;
            }
        }
        String redirectTo = request.getParameter(":redirect");
        if (redirectTo != null) {
            if (AuthUtil.isRedirectValid((HttpServletRequest)request, (String)redirectTo) || redirectTo.equals(FormsHelper.getReferrer((HttpServletRequest)request))) {
                int pos = redirectTo.indexOf(63);
                redirectTo = redirectTo + (pos == -1 ? (char)'?' : '&') + "status=" + status;
                response.sendRedirect(redirectTo);
            } else {
                this.logger.error("Invalid redirect specified: {}", new Object[]{redirectTo});
                response.sendError(403);
            }
            return;
        }
        if (FormsHelper.isRedirectToReferrer((ServletRequest)request)) {
            FormsHelper.redirectToReferrer(request, response, Collections.singletonMap("stats", new String[]{String.valueOf(status)}));
            return;
        }
        response.setStatus(status);
    }

    protected void bindMailService(MailService mailService) {
        this.mailService = mailService;
    }

    protected void unbindMailService(MailService mailService) {
        if (this.mailService == mailService) {
            this.mailService = null;
        }
    }
}

