/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.cq.wcm.foundation.forms.FieldDescription;
import com.day.cq.wcm.foundation.forms.FieldHelper;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.FormsManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsListServlet
extends AbstractPredicateServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private FormsManager formsManager;

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        try {
            JSONWriter w = new JSONWriter((Writer)resp.getWriter());
            if (req.getRequestURI().contains("/actions")) {
                resp.setContentType("application/json");
                resp.setCharacterEncoding("utf-8");
                this.writeActions(w);
            } else if (req.getRequestURI().contains("/constraints")) {
                resp.setContentType("application/json");
                resp.setCharacterEncoding("utf-8");
                this.writeConstraints(w);
            } else if (req.getRequestURI().contains("/actiondialog")) {
                String dialogPath = this.formsManager.getDialogPathForAction(req.getParameter("id"));
                if (dialogPath != null) {
                    req.getRequestDispatcher(dialogPath + ".infinity.json").forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    resp.setContentType("application/json");
                    resp.setCharacterEncoding("utf-8");
                    resp.getWriter().write("{jcr:primaryType:\"cq:WidgetCollection\"}");
                }
            } else if (req.getRequestURI().contains("/report")) {
                String path = req.getParameter("path");
                if (path == null || path.trim().length() == 0) {
                    resp.sendError(404, "Path parameter is missing.");
                    return;
                }
                Resource formStartResource = req.getResourceResolver().getResource(path);
                if (formStartResource == null) {
                    resp.sendError(404, "Resource not found.");
                    return;
                }
                ValueMap vm = ResourceUtil.getValueMap((Resource)formStartResource);
                StringBuilder sb = new StringBuilder();
                sb.append(req.getContextPath());
                sb.append("/etc/importers/bulkeditor.html?rootPath=");
                String actionPath = (String)vm.get("action", (Object)"");
                if (actionPath == null || actionPath.trim().length() == 0) {
                    resp.sendError(400, "Missing 'action' property on node " + formStartResource.getPath());
                }
                if (actionPath.endsWith("*")) {
                    actionPath = actionPath.substring(0, actionPath.length() - 1);
                }
                if (actionPath.endsWith("/")) {
                    actionPath = actionPath.substring(0, actionPath.length() - 1);
                }
                sb.append(FormsHelper.encodeValue(actionPath));
                sb.append("&initialSearch=true&contentMode=false&spc=true");
                Iterator<Resource> elements = FormsHelper.getFormElements(formStartResource);
                while (elements.hasNext()) {
                    FieldDescription[] descs;
                    Resource element = elements.next();
                    FieldHelper.initializeField(req, resp, element);
                    for (FieldDescription desc : descs = FieldHelper.getFieldDescriptions(req, element)) {
                        if (desc.isPrivate()) continue;
                        String name = FormsHelper.encodeValue(desc.getName());
                        sb.append("&cs=");
                        sb.append(name);
                        sb.append("&cv=");
                        sb.append(name);
                    }
                }
                resp.sendRedirect(sb.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("Error while generating JSON list", (Throwable)e);
            resp.sendError(500, e.toString());
            return;
        }
    }

    private void writeJson(Iterator<FormsManager.ComponentDescription> descIter, JSONWriter w, boolean writeEmpty) throws JSONException {
        w.array();
        if (writeEmpty) {
            w.object();
            w.key("value").value((Object)"");
            w.key("text").value((Object)"None");
            w.endObject();
        }
        while (descIter.hasNext()) {
            FormsManager.ComponentDescription desc = descIter.next();
            w.object();
            w.key("value");
            w.value((Object)desc.getResourceType());
            w.key("text");
            w.value((Object)desc.getTitle());
            if (desc.getHint() != null) {
                w.key("qtip");
                w.value((Object)desc.getHint());
            }
            w.endObject();
        }
        w.endArray();
    }

    private void writeActions(JSONWriter w) throws JSONException {
        this.writeJson(this.formsManager.getActions(), w, false);
    }

    private void writeConstraints(JSONWriter w) throws JSONException {
        this.writeJson(this.formsManager.getConstraints(), w, true);
    }

    protected void bindFormsManager(FormsManager formsManager) {
        this.formsManager = formsManager;
    }

    protected void unbindFormsManager(FormsManager formsManager) {
        if (this.formsManager == formsManager) {
            this.formsManager = null;
        }
    }
}

