/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartWorkflowPostProcessor
implements SlingPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private WorkflowService workflowService;
    private SlingRepository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SlingHttpServletRequest request, List<Modification> mods) throws Exception {
        String workflowModelPath = this.getStringAttr(request, "Forms.workflow.path");
        String payloadPath = this.getStringAttr(request, "Forms.workflow.payloadPath");
        if (workflowModelPath == null) {
            this.log.debug("No workflow model path supplied, not starting workflow");
        } else {
            this.log.info("Starting workflow {} on path {}", (Object)workflowModelPath, (Object)payloadPath);
            Session s = this.repository.loginAdministrative(null);
            try {
                WorkflowSession wfs = this.workflowService.getWorkflowSession(s);
                WorkflowModel model = wfs.getModel(workflowModelPath);
                if (model == null) {
                    throw new WorkflowException("Workflow Model with ID '" + workflowModelPath + "' not found");
                }
                WorkflowData data = wfs.newWorkflowData("JCR_PATH", (Object)payloadPath);
                wfs.startWorkflow(model, data);
            }
            finally {
                s.logout();
            }
        }
    }

    private String getStringAttr(SlingHttpServletRequest request, String name) {
        Object obj = request.getAttribute(name);
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

