/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%forms.formparagraphpostprocessor.name", description="%forms.formparagraphpostprocessor.description")
@Service(value={SlingPostProcessor.class})
public class FormParagraphPostProcessor
implements SlingPostProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Property(boolValue={true})
    public static final String ENABLED = "forms.formparagraphpostprocessor.enabled";
    private final String PAGE_MARKER = "/jcr:content/";
    private boolean enabled;

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if (this.enabled) {
            HashSet<String> fixPaths = new HashSet<String>();
            for (Modification mod : changes) {
                switch (mod.getType()) {
                    case ORDER: 
                    case MOVE: 
                    case COPY: {
                        break;
                    }
                    case MODIFY: 
                    case CREATE: 
                    case DELETE: {
                        int pageEndPos = mod.getSource().indexOf("/jcr:content/");
                        if (pageEndPos == -1) break;
                        String pagePath = mod.getSource().substring(0, pageEndPos);
                        fixPaths.add(pagePath);
                    }
                }
            }
            ResourceResolver resolver = request.getResourceResolver();
            for (String pagePath : fixPaths) {
                this.logger.debug("Checking if resource '{}' is a page", (Object)pagePath);
                if (resolver.getResource(pagePath).adaptTo(Page.class) == null) {
                    this.logger.debug("resource is not adaptable to Page, skipping");
                    continue;
                }
                String contentPath = pagePath + '/' + "jcr:content";
                this.logger.debug("Checking page for form paragraphs {}", (Object)pagePath);
                Resource contentResource = resolver.getResource(contentPath);
                if (contentResource == null) continue;
                this.fixStructure(contentResource);
            }
        }
    }

    private void fixStructure(Resource contentResource) throws RepositoryException {
        Iterator rI = ResourceUtil.listChildren((Resource)contentResource);
        while (rI.hasNext()) {
            Resource res = (Resource)rI.next();
            if (ResourceUtil.isA((Resource)res, (String)"foundation/components/form/start") || ResourceUtil.isA((Resource)res, (String)"foundation/components/form/end")) {
                if (FormsHelper.checkFormStructure(res) == null) continue;
                this.logger.debug("Fixed forms structure at {}", (Object)contentResource.getPath());
                continue;
            }
            this.fixStructure(res);
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        Dictionary configuration = context.getProperties();
        this.enabled = (Boolean)configuration.get(ENABLED);
        this.logger.debug("Activated, enabled={}", (Object)this.enabled);
    }
}

