/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FormsManager;
import com.day.cq.widget.HtmlLibraryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service(value={FormsManager.class})
public class FormsManagerImpl
implements FormsManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<EventListenerWrapper> listeners = new ArrayList<EventListenerWrapper>();
    private String[] searchPaths;
    @Reference
    private SlingRepository repository;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    @Reference
    private JcrResourceResolverFactory resolverFactory;
    private Collection<FormsManager.ComponentDescription> actions;
    private Collection<FormsManager.ComponentDescription> constraints;
    private Session session;
    public static volatile HtmlLibraryManager HTML_LIBRARY_MANAGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<FormsManager.ComponentDescription> getActions() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            if (this.actions == null) {
                this.searchFormElements();
            }
            return this.actions.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<FormsManager.ComponentDescription> getConstraints() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            if (this.constraints == null) {
                this.searchFormElements();
            }
            return this.constraints.iterator();
        }
    }

    @Override
    public String getDialogPathForAction(String resourceType) {
        if (resourceType == null) {
            return null;
        }
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        for (String path : this.searchPaths) {
            String dialogPath = path + '/' + resourceType + "/dialog";
            if (resourceResolver.getResource(dialogPath) == null) continue;
            return dialogPath;
        }
        return null;
    }

    protected void activate(ComponentContext componentContext) throws RepositoryException {
        this.session = this.repository.loginAdministrative(null);
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        this.searchPaths = resourceResolver.getSearchPath();
        for (int i = 0; i < this.searchPaths.length; ++i) {
            this.searchPaths[i] = this.searchPaths[i].substring(0, this.searchPaths[i].length() - 1);
        }
        for (String path : this.searchPaths) {
            EventListenerWrapper wrapper = new EventListenerWrapper(this);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)wrapper, 31, path, true, null, null, true);
            this.listeners.add(wrapper);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.session != null) {
            for (EventListener eventListener : this.listeners) {
                try {
                    this.session.getWorkspace().getObservationManager().removeEventListener(eventListener);
                }
                catch (RepositoryException e) {}
            }
            this.listeners.clear();
            this.session.logout();
            this.session = null;
        }
        this.actions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearActions() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.actions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearConstraints() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.constraints = null;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager manager) {
        this.htmlLibraryManager = manager;
        HTML_LIBRARY_MANAGER = manager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager manager) {
        if (this.htmlLibraryManager == manager) {
            this.htmlLibraryManager = null;
            HTML_LIBRARY_MANAGER = null;
        }
    }

    private Collection<FormsManager.ComponentDescription> search(String type) {
        HashMap<String, ComponentDescriptionImpl> map = new HashMap<String, ComponentDescriptionImpl>();
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        ArrayList<String> disabledComponents = new ArrayList<String>();
        for (String path : this.searchPaths) {
            StringBuilder buffer = new StringBuilder("/jcr:root");
            buffer.append(path);
            buffer.append("//* [@");
            buffer.append("sling:resourceType");
            buffer.append("='");
            buffer.append(type);
            buffer.append("']");
            this.logger.debug("Query: {}", (Object)buffer.toString());
            Iterator i = resourceResolver.findResources(buffer.toString(), "xpath");
            while (i.hasNext()) {
                Resource rsrc = (Resource)i.next();
                ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
                String rt = rsrc.getPath().substring(path.length() + 1);
                if (((Boolean)properties.get("enabled", (Object)Boolean.TRUE)).booleanValue()) {
                    if (map.containsKey(rt) || disabledComponents.contains(rt)) continue;
                    map.put(rt, new ComponentDescriptionImpl(rt, ResourceUtil.getName((Resource)rsrc), properties));
                    continue;
                }
                disabledComponents.add(rt);
            }
        }
        ArrayList<FormsManager.ComponentDescription> entries = new ArrayList<FormsManager.ComponentDescription>(map.values());
        Collections.sort(entries);
        return entries;
    }

    private void searchFormElements() {
        if (this.actions == null) {
            this.actions = this.search("foundation/components/form/action");
        }
        if (this.constraints == null) {
            this.constraints = this.search("foundation/components/form/constraint");
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ComponentDescriptionImpl
    implements FormsManager.ComponentDescription,
    Comparable<FormsManager.ComponentDescription> {
        private final String resourceType;
        private final String title;
        private final String hint;
        private final int order;

        public ComponentDescriptionImpl(String rt, String defaultName, ValueMap props) {
            this.resourceType = rt;
            this.title = (String)props.get("jcr:title", (Object)defaultName);
            this.order = (Integer)props.get("order", (Object)0);
            this.hint = (String)props.get("hint", String.class);
        }

        @Override
        public String getResourceType() {
            return this.resourceType;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public String getHint() {
            return this.hint;
        }

        @Override
        public int compareTo(FormsManager.ComponentDescription o) {
            ComponentDescriptionImpl obj = (ComponentDescriptionImpl)o;
            if (this.order < obj.order) {
                return -1;
            }
            if (this.order == obj.order) {
                return this.title.compareTo(obj.title);
            }
            return 1;
        }
    }

    public static final class EventListenerWrapper
    implements EventListener {
        private final FormsManagerImpl delegatee;

        public EventListenerWrapper(FormsManagerImpl listener) {
            this.delegatee = listener;
        }

        public void onEvent(EventIterator i) {
            this.delegatee.clearActions();
            this.delegatee.clearConstraints();
        }
    }
}

