/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class AutoAssignRule {
    public static final String GLOBBING = "globbing";
    public static final String WORKFLOW_MODEL = "workflowModel";
    public static final String TEMPLATE_PATH = "templatePath";
    public static final String TEMPLATE_RESOURCE_TYPE = "templResourceType";
    private Node node;
    private WorkflowSession session;

    public AutoAssignRule(Node node, WorkflowSession session) {
        this.session = session;
        this.node = node;
    }

    public WorkflowModel getWorkflowModel() {
        try {
            String modelId = this.node.getProperty(WORKFLOW_MODEL).getString();
            return this.session.getModel(modelId);
        }
        catch (RepositoryException re) {
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        return null;
    }

    public String getTemplatePath() {
        try {
            return this.node.getParent().getProperty(TEMPLATE_PATH).getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public String getTemplResourceType() {
        try {
            return this.node.getParent().getProperty(TEMPLATE_RESOURCE_TYPE).getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public String getGlobbing() {
        try {
            return this.node.getProperty(GLOBBING).getString();
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    public Node getNode() {
        return this.node;
    }
}

