/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageEvent;
import com.day.cq.wcm.api.PageModification;
import com.day.cq.wcm.workflow.api.WcmWorkflowService;
import com.day.cq.wcm.workflow.impl.WorkflowAutoAssignAllocator;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobProcessor;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WcmWorkflowServiceImpl
implements WcmWorkflowService,
EventHandler,
JobProcessor {
    private static final Logger log = LoggerFactory.getLogger(WcmWorkflowServiceImpl.class);
    public static final String WORKSPACE = "cq.workflow.workspace";
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    public static final String TYPE_JCR_UUID = "JCR_UUID";
    private static final String WORKFLOWNODE_TYPE_END = "END";
    private static final String WORKFLOWNODE_TYPE_PROCESS = "PROCESS";
    public static final String REQUEST_FOR_ACTIVATION_MODEL = "cq.wcm.workflow.req.activate";
    public static final String REQUEST_FOR_DEACTIVATION_MODEL = "cq.wcm.workflow.req.deactivate";
    private WorkflowService workflowService;
    private SlingRepository repository;
    private PayloadMap payloadMap;
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    private boolean isInitialized;
    Dictionary config;
    private WorkflowAutoAssignAllocator wfAutoAssignAllocator;
    private WorkflowSession adminWfSession;

    public boolean isInWorkflow(String pagePath) {
        return this.payloadMap.isInWorkflow(pagePath, true);
    }

    public WorkflowModel getRequestForReplicationWorkflowModel(ReplicationActionType replicationType) {
        String type = replicationType.toString().toLowerCase();
        String modelId = (String)this.config.get("cq.wcm.workflow.req." + type);
        try {
            return this.adminWfSession.getModel(modelId);
        }
        catch (WorkflowException we) {
            log.warn("Cannot load workflow model " + modelId + "specified in " + "cq.wcm.workflow.req." + type, (Throwable)we);
            return null;
        }
    }

    public Workflow getWorkflowInstance(String pagePath) {
        List instances = this.payloadMap.getWorkflowInstances(pagePath, true);
        if (instances.size() > 0) {
            return (Workflow)instances.get(0);
        }
        return null;
    }

    public String getWcmConfigPath() {
        return "/etc/workflow/wcm";
    }

    public void handleEvent(Event event) {
        EventUtil.processJob((Event)event, (JobProcessor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Event event) {
        block21: {
            log.debug("Received event of topic: " + event.getTopic());
            String topic = event.getTopic();
            WorkflowSession adminWfSession = this.getWorkflowSession(null);
            ResourceResolver resourceResolver = this.jcrResourceResolverFactory.getResourceResolver(adminWfSession.getSession());
            try {
                String path;
                Workflow instance;
                ReplicationAction re;
                if (topic.equals("com/day/cq/wcm/core/page") && EventUtil.isLocal((Event)event)) {
                    PageEvent pageEvent = PageEvent.fromEvent((Event)event);
                    Iterator pI = pageEvent.getModifications();
                    while (pI.hasNext()) {
                        PageModification pm = (PageModification)pI.next();
                        PageModification.ModificationType eventType = pm.getType();
                        if (eventType.equals((Object)PageModification.ModificationType.CREATED) && !this.isInWorkflow(pm.getPath())) {
                            Page page;
                            Resource res = resourceResolver.getResource(pm.getPath());
                            if (res == null || (page = (Page)res.adaptTo(Page.class)) == null) continue;
                            this.autoAssignWorkflow(page, adminWfSession, pm.getUserId());
                            continue;
                        }
                        if (eventType.equals((Object)PageModification.ModificationType.DELETED) && EventUtil.isLocal((Event)event)) {
                            Workflow instance2 = this.getWorkflowInstance(pm.getPath());
                            if (instance2 == null) continue;
                            try {
                                adminWfSession.terminateWorkflow(instance2);
                                log.debug("Terminated workflow " + instance2.getId() + "for deleted page " + pm.getPath());
                            }
                            catch (WorkflowException we) {
                                log.warn("Unable to terminate workflow " + instance2.getId() + " for " + "deleted page " + pm.getPath());
                            }
                            continue;
                        }
                        if (!eventType.equals((Object)PageModification.ModificationType.MODIFIED) || !EventUtil.isLocal((Event)event)) continue;
                        this.autoSubmitPageAfterModification(pm, adminWfSession, pm.getUserId());
                    }
                    break block21;
                }
                if (topic.equals("com/day/cq/wcm/workflow/req/for/activation") && EventUtil.isLocal((Event)event)) {
                    String path2 = (String)event.getProperty("path");
                    log.debug("Request for de/activation event received for " + path2);
                    ReplicationActionType type = (ReplicationActionType)event.getProperty("replicationType");
                    WorkflowModel model = this.getRequestForReplicationWorkflowModel(type);
                    if (model == null) {
                        log.warn("No valid workflow model specified for request for de/activation");
                        break block21;
                    }
                    WorkflowSession userWfSession = this.getWorkflowSession((String)event.getProperty("userId"));
                    WorkflowData wfData = userWfSession.newWorkflowData(TYPE_JCR_PATH, (Object)path2);
                    try {
                        userWfSession.startWorkflow(model, wfData);
                        break block21;
                    }
                    catch (WorkflowException we) {
                        log.warn("Cannot start request for de/activation workflow " + model.getTitle() + " for " + path2 + ": " + we.getMessage());
                        break block21;
                    }
                    finally {
                        userWfSession.logout();
                    }
                }
                if (topic.equals("com/day/cq/replication") && EventUtil.isLocal((Event)event) && (re = ReplicationAction.fromEvent((Event)event)) != null && (instance = this.getWorkflowInstance(path = re.getPath())) != null) {
                    List items = instance.getWorkItems();
                    if (items.size() > 0 && !((WorkItem)items.get(0)).getNode().getType().equals(WORKFLOWNODE_TYPE_END) && !((WorkItem)items.get(0)).getNode().getType().equals(WORKFLOWNODE_TYPE_PROCESS)) {
                        try {
                            adminWfSession.terminateWorkflow(instance);
                            log.debug("Terminated workflow " + instance.getId() + "for replicated page " + path);
                        }
                        catch (WorkflowException we) {
                            log.warn("Unable to terminate workflow " + instance.getId() + " for " + "replicated page " + path);
                        }
                    } else {
                        log.debug("Not going to terminate workflow instance for " + path);
                    }
                }
            }
            finally {
                adminWfSession.logout();
            }
        }
        return true;
    }

    protected void activate(ComponentContext context) throws RepositoryException {
        this.adminWfSession = this.getWorkflowSession(null);
        this.isInitialized = false;
        this.config = context.getProperties();
        this.wfAutoAssignAllocator = new WorkflowAutoAssignAllocator(this.adminWfSession, this.getWcmConfigPath() + "/templates");
    }

    protected void deactivate(ComponentContext context) {
        if (this.adminWfSession != null) {
            this.adminWfSession.logout();
            this.adminWfSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoAssignWorkflow(Page page, WorkflowSession wfSession, String userId) {
        WorkflowModel model = this.wfAutoAssignAllocator.getAutoAssignWorkflowModel(page);
        if (model != null) {
            log.debug("Auto assign workflow: found model (" + model.getTitle() + ") for " + page.getPath());
            WorkflowData wfData = wfSession.newWorkflowData(TYPE_JCR_PATH, (Object)page.getPath());
            try {
                boolean impersonate = false;
                if (userId != null && !userId.equals(wfSession.getSession().getUserID())) {
                    WorkflowSession userWfSession = null;
                    try {
                        Session us = wfSession.getSession().impersonate((Credentials)new SimpleCredentials(userId, new char[0]));
                        userWfSession = this.workflowService.getWorkflowSession(us);
                        userWfSession.startWorkflow(model, wfData);
                        impersonate = true;
                    }
                    catch (RepositoryException re) {
                        log.warn("autoAssignWorkflow: Cannot impersonate user " + userId + ". will start workflow with admin user session");
                        impersonate = false;
                    }
                    catch (WorkflowException we) {
                        log.warn("autoAssignWorkflow: Cannot start workflow with given user " + userId + ". will start workflow with admin user session");
                        impersonate = false;
                    }
                    finally {
                        if (userWfSession != null) {
                            userWfSession.logout();
                        }
                    }
                }
                if (!impersonate) {
                    wfSession.startWorkflow(model, wfData);
                }
            }
            catch (WorkflowException we) {
                log.warn("Cannot start workflow " + model.getTitle() + " for " + page.getPath() + ": " + we.getMessage());
            }
        }
    }

    private void autoSubmitPageAfterModification(PageModification pm, WorkflowSession wfSession, String modifierUID) {
        ReplicationStatus repStatus;
        Resource res = this.jcrResourceResolverFactory.getResourceResolver(wfSession.getSession()).getResource(pm.getPath());
        Page page = (Page)res.adaptTo(Page.class);
        if (page != null && !this.isInWorkflow(pm.getPath()) && (repStatus = (ReplicationStatus)res.adaptTo(ReplicationStatus.class)) != null && repStatus.isActivated()) {
            Calendar lastModified = page.getLastModified();
            Calendar lastActivated = repStatus.getLastPublished();
            if (lastModified != null && lastActivated != null && lastModified.getTimeInMillis() > lastActivated.getTimeInMillis()) {
                this.autoAssignWorkflow(page, wfSession, modifierUID);
            }
        }
    }

    private WorkflowSession getWorkflowSession(String userId) {
        try {
            if (null == userId) {
                return this.workflowService.getWorkflowSession(this.repository.loginAdministrative(null));
            }
            Session userSession = this.adminWfSession.getSession().impersonate((Credentials)new SimpleCredentials(userId, new char[0]));
            return this.workflowService.getWorkflowSession(userSession);
        }
        catch (RepositoryException re) {
            log.error("Cannot login into repository", (Throwable)re);
            return null;
        }
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

