/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.workflow.impl.AutoAssignRule;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowAutoAssignAllocator {
    private static final Logger log = LoggerFactory.getLogger(WorkflowAutoAssignAllocator.class);
    WorkflowSession wfSession;
    Session session;
    String configPath;

    public WorkflowAutoAssignAllocator(WorkflowSession wfSession, String configPath) {
        this.wfSession = wfSession;
        this.session = wfSession.getSession();
        this.configPath = configPath;
    }

    public WorkflowModel getAutoAssignWorkflowModel(Page page) {
        Template template = page.getTemplate();
        String path = page.getPath();
        if (this.getAllRules() != null) {
            List<AutoAssignRule> rules = null;
            Set<String> set = this.getAllRules().keySet();
            for (String key : set) {
                String label = key.substring(key.lastIndexOf("/") + 1);
                if (!(label = JcrUtil.unescapeIllegalJcrChars((String)label)).equals(template.getPath())) continue;
                rules = this.getAllRules().get(key);
                break;
            }
            if (rules != null) {
                AutoAssignRule bestMatch = null;
                for (AutoAssignRule rule : rules) {
                    String globbing = rule.getGlobbing();
                    if (!path.startsWith(globbing)) continue;
                    if (bestMatch == null) {
                        bestMatch = rule;
                        continue;
                    }
                    if (bestMatch.getGlobbing() == null) continue;
                    String bmGlobbing = bestMatch.getGlobbing();
                    if (globbing.length() <= bmGlobbing.length()) continue;
                    bestMatch = rule;
                }
                if (bestMatch != null) {
                    return bestMatch.getWorkflowModel();
                }
            }
        }
        return null;
    }

    public AutoAssignRule addRule(String templatePath, WorkflowModel model, String globbing) throws RepositoryException {
        Node node = this.getTemplateConfigNode(templatePath);
        Node newRule = node.addNode(JcrUtil.escapeIllegalJcrChars((String)globbing), "nt:unstructured");
        newRule.setProperty("globbing", globbing);
        newRule.setProperty("workflowModel", model.getId());
        this.session.save();
        return this.loadRule(newRule);
    }

    public AutoAssignRule loadRule(Node rule) {
        return new AutoAssignRule(rule, this.wfSession);
    }

    public void removeRule(AutoAssignRule rule) throws RepositoryException {
        rule.getNode().remove();
        this.session.save();
    }

    private Node getTemplateConfigNode(String templatePath) throws RepositoryException {
        String name;
        Node configNode = (Node)this.session.getItem(this.configPath);
        if (configNode.hasNode(name = JcrUtil.escapeIllegalJcrChars((String)templatePath))) {
            return configNode.getNode(name);
        }
        Node tNode = configNode.addNode(name, "nt:unstructured");
        tNode.setProperty("templatePath", templatePath);
        String resourceType = ((Node)this.session.getItem(templatePath)).getNode("jcr:content").getProperty("sling:resourceType").getString();
        tNode.setProperty("templResourceType", resourceType);
        this.session.save();
        return tNode;
    }

    public List<AutoAssignRule> getTemplateRules(Node node) {
        ArrayList<AutoAssignRule> rules = new ArrayList<AutoAssignRule>();
        try {
            NodeIterator itr = node.getNodes();
            while (itr.hasNext()) {
                Node n = itr.nextNode();
                AutoAssignRule rule = new AutoAssignRule(n, this.wfSession);
                rules.add(rule);
            }
            return rules;
        }
        catch (RepositoryException re) {
            log.error("Cannot read rules: " + re.getMessage());
            return null;
        }
    }

    public List<AutoAssignRule> getTemplateRules(String templatePath) throws RepositoryException {
        Node confNode = this.getTemplateConfigNode(templatePath);
        return this.getTemplateRules(confNode);
    }

    public Map<String, List<AutoAssignRule>> getAllRules() {
        HashMap<String, List<AutoAssignRule>> map = new HashMap<String, List<AutoAssignRule>>();
        try {
            Node configNode = (Node)this.session.getItem(this.configPath);
            NodeIterator itr = configNode.getNodes();
            while (itr.hasNext()) {
                Node n = itr.nextNode();
                List<AutoAssignRule> rules = this.getTemplateRules(n);
                if (rules == null) continue;
                map.put(n.getPath(), rules);
            }
        }
        catch (RepositoryException re) {
            log.error("Unable to read all workflow auto assign rules: " + re.getMessage());
        }
        return map;
    }

    public AutoAssignRule editRule(String rulePath, WorkflowModel model, String globbing) throws RepositoryException {
        Node ruleNode = (Node)this.session.getItem(rulePath);
        ruleNode.setProperty("globbing", globbing);
        ruleNode.setProperty("workflowModel", model.getId());
        this.session.save();
        return this.loadRule(ruleNode);
    }
}

