/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.impl;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageInfoProvider;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.collection.ResourceCollection;
import com.day.cq.workflow.collection.ResourceCollectionManager;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowPackageInfoProvider
implements PageInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(WorkflowPackageInfoProvider.class);
    private SlingRepository repository;
    private ResourceCollectionManager resourceCollectionManager;
    private PayloadMap payloadMap;
    private Session admin;

    public void updatePageInfo(SlingHttpServletRequest request, JSONObject info, Resource resource) throws JSONException {
        JSONObject workflowPackage = new JSONObject();
        ResourceResolver resourceResolver = resource.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        JSONArray selectedWorkflowPackages = new JSONArray();
        JSONArray runningSelectedWorkflowPackages = new JSONArray();
        List wpList = this.resourceCollectionManager.getCollections(this.admin);
        JSONArray wpArray = new JSONArray();
        if (wpList != null) {
            for (int i = 0; i < wpList.size(); ++i) {
                ResourceCollection wp = (ResourceCollection)wpList.get(i);
                try {
                    Node wpNode = this.admin.getNode(wp.getPath());
                    Page wpPage = pageManager.getPage(wpNode.getPath());
                    List instances = this.payloadMap.getWorkflowInstances(wpNode.getPath(), false);
                    boolean isInCurrentWorkflowPackage = false;
                    JSONArray wpContentArray = new JSONArray();
                    for (Node wpContentNode : wp.list(new String[]{"cq:Page"})) {
                        if (wpContentNode.getPath().equals(resource.getPath())) {
                            isInCurrentWorkflowPackage = true;
                        }
                        wpContentArray.put((Object)wpContentNode.getPath());
                    }
                    JSONObject obj = new JSONObject();
                    obj.put("path", (Object)wp.getPath());
                    obj.put("title", (Object)wpPage.getTitle());
                    obj.put("isInWorkflowPackage", isInCurrentWorkflowPackage);
                    boolean isRunning = instances.size() > 0;
                    obj.put("isRunning", isRunning);
                    obj.put("packageContent", (Object)wpContentArray);
                    wpArray.put((Object)obj);
                    if (!isInCurrentWorkflowPackage) continue;
                    selectedWorkflowPackages.put(i);
                    if (!isRunning) continue;
                    runningSelectedWorkflowPackages.put(i);
                    continue;
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get information for workflow package: " + wp.getPath(), (Throwable)e);
                }
            }
        }
        workflowPackage.put("workflowPackages", (Object)wpArray);
        workflowPackage.put("selectedWorkflowPackages", (Object)selectedWorkflowPackages);
        workflowPackage.put("runningSelectedWorkflowPackages", (Object)runningSelectedWorkflowPackages);
        info.put("workflowPackageInfo", (Object)workflowPackage);
    }

    protected void activate(ComponentContext context) throws WorkflowException, RepositoryException {
        this.admin = this.repository.loginAdministrative(null);
    }

    protected void deactivate(ComponentContext context) {
        if (this.admin != null) {
            this.admin.logout();
            this.admin = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceCollectionManager(ResourceCollectionManager resourceCollectionManager) {
        this.resourceCollectionManager = resourceCollectionManager;
    }

    protected void unbindResourceCollectionManager(ResourceCollectionManager resourceCollectionManager) {
        if (this.resourceCollectionManager == resourceCollectionManager) {
            this.resourceCollectionManager = null;
        }
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }
}

