/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.name;

import com.day.crx.name.IllegalNameException;
import com.day.crx.name.NameCache;
import com.day.crx.name.NamespaceResolver;
import com.day.crx.name.NoPrefixDeclaredException;
import com.day.crx.name.QName;
import com.day.crx.name.UnknownPrefixException;
import javax.jcr.NamespaceException;

public class NameFormat {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/crx/tags/crx-1.4.0/repository/crx-api/src/main/java/com/day/crx/name/NameFormat.java $ $Rev: 33007 $ $Date: 2008-02-01 14:22:04 +0100 (Fri, 01 Feb 2008) $";
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;

    public static QName parse(String jcrName, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        if (resolver instanceof NameCache) {
            QName name = ((NameCache)((Object)resolver)).retrieveName(jcrName);
            if (name == null) {
                name = NameFormat.parseNoCache(jcrName, resolver);
                ((NameCache)((Object)resolver)).cacheName(jcrName, name);
            }
            return name;
        }
        return NameFormat.parseNoCache(jcrName, resolver);
    }

    public static QName[] parse(String[] jcrNames, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        QName[] ret = new QName[jcrNames.length];
        if (resolver instanceof NameCache) {
            for (int i = 0; i < ret.length; ++i) {
                QName name = ((NameCache)((Object)resolver)).retrieveName(jcrNames[i]);
                if (name == null) {
                    name = NameFormat.parseNoCache(jcrNames[i], resolver);
                    ((NameCache)((Object)resolver)).cacheName(jcrNames[i], name);
                }
                ret[i] = name;
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = NameFormat.parseNoCache(jcrNames[i], resolver);
            }
        }
        return ret;
    }

    private static QName parseNoCache(String jcrName, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        String uri;
        int len;
        int n = len = jcrName == null ? 0 : jcrName.length();
        if (len == 0) {
            throw new IllegalNameException("empty name");
        }
        String prefix = "";
        int nameStart = 0;
        int state = 0;
        boolean trailingSpaces = false;
        for (int i = 0; i < len; ++i) {
            char c = jcrName.charAt(i);
            if (c == ':') {
                if (state == 0) {
                    throw new IllegalNameException("Prefix must not be empty");
                }
                if (state == 1) {
                    if (trailingSpaces) {
                        throw new IllegalNameException("Trailing spaces not allowed");
                    }
                } else {
                    throw new IllegalNameException("'" + c + "' not allowed in name");
                }
                prefix = jcrName.substring(0, i);
                state = 2;
                trailingSpaces = false;
                continue;
            }
            if (c == ' ') {
                if (state == 0 || state == 2) {
                    throw new IllegalNameException("'" + c + "' not valid name start");
                }
                trailingSpaces = true;
                continue;
            }
            if (Character.isWhitespace(c) || c == '/' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"') {
                throw new IllegalNameException("'" + c + "' not allowed in name");
            }
            if (state == 0) {
                state = 1;
            } else if (state == 2) {
                state = 3;
                nameStart = i;
            }
            trailingSpaces = false;
        }
        if (nameStart == len) {
            throw new IllegalNameException("Local name must not be empty");
        }
        if (trailingSpaces) {
            throw new IllegalNameException("Trailing spaces not allowed");
        }
        if (resolver == null) {
            return null;
        }
        try {
            uri = resolver.getURI(prefix);
        }
        catch (NamespaceException nse) {
            throw new UnknownPrefixException(prefix);
        }
        return new QName(uri, nameStart == 0 ? jcrName : jcrName.substring(nameStart, len));
    }

    public static void checkFormat(String jcrName) throws IllegalNameException {
        try {
            NameFormat.parse(jcrName, null);
        }
        catch (UnknownPrefixException unknownPrefixException) {
            // empty catch block
        }
    }

    public static String format(QName qName, NamespaceResolver resolver) throws NoPrefixDeclaredException {
        if (resolver instanceof NameCache) {
            String jcrName = ((NameCache)((Object)resolver)).retrieveName(qName);
            if (jcrName == null) {
                StringBuffer buf = new StringBuffer();
                NameFormat.formatNoCache(qName, resolver, buf);
                jcrName = buf.toString();
                ((NameCache)((Object)resolver)).cacheName(jcrName, qName);
            }
            return jcrName;
        }
        StringBuffer buf = new StringBuffer();
        NameFormat.formatNoCache(qName, resolver, buf);
        return buf.toString();
    }

    public static String[] format(QName[] qNames, NamespaceResolver resolver) throws NoPrefixDeclaredException {
        String[] ret = new String[qNames.length];
        if (resolver instanceof NameCache) {
            for (int i = 0; i < ret.length; ++i) {
                String jcrName = ((NameCache)((Object)resolver)).retrieveName(qNames[i]);
                if (jcrName == null) {
                    StringBuffer buf = new StringBuffer();
                    NameFormat.formatNoCache(qNames[i], resolver, buf);
                    jcrName = buf.toString();
                    ((NameCache)((Object)resolver)).cacheName(jcrName, qNames[i]);
                }
                ret[i] = jcrName;
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                StringBuffer buf = new StringBuffer();
                NameFormat.formatNoCache(qNames[i], resolver, buf);
                ret[i] = buf.toString();
            }
        }
        return ret;
    }

    public static void format(QName qName, NamespaceResolver resolver, StringBuffer buffer) throws NoPrefixDeclaredException {
        if (resolver instanceof NameCache) {
            String jcrName = ((NameCache)((Object)resolver)).retrieveName(qName);
            if (jcrName == null) {
                int l = buffer.length();
                NameFormat.formatNoCache(qName, resolver, buffer);
                ((NameCache)((Object)resolver)).cacheName(buffer.substring(l), qName);
            } else {
                buffer.append(jcrName);
            }
        } else {
            NameFormat.formatNoCache(qName, resolver, buffer);
        }
    }

    private static void formatNoCache(QName qName, NamespaceResolver resolver, StringBuffer buffer) throws NoPrefixDeclaredException {
        String prefix;
        try {
            prefix = resolver.getPrefix(qName.getNamespaceURI());
        }
        catch (NamespaceException nse) {
            throw new NoPrefixDeclaredException("no prefix declared for URI: " + qName.getNamespaceURI());
        }
        if (prefix.length() != 0) {
            buffer.append(prefix);
            buffer.append(':');
        }
        buffer.append(qName.getLocalName());
    }
}

