/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.name;

import com.day.crx.name.MalformedPathException;
import com.day.crx.name.NameFormat;
import com.day.crx.name.NamespaceResolver;
import com.day.crx.name.NoPrefixDeclaredException;
import com.day.crx.name.Path;
import com.day.crx.name.QName;
import javax.jcr.NamespaceException;

public class PathFormat {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/crx/tags/crx-1.4.0/repository/crx-api/src/main/java/com/day/crx/name/PathFormat.java $ $Rev: 33007 $ $Date: 2008-02-01 14:22:04 +0100 (Fri, 01 Feb 2008) $";
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;
    private static final int STATE_INDEX = 4;
    private static final int STATE_INDEX_END = 5;
    private static final int STATE_DOT = 6;
    private static final int STATE_DOTDOT = 7;

    public static Path parse(String jcrPath, NamespaceResolver resolver) throws MalformedPathException {
        return PathFormat.parse(null, jcrPath, resolver);
    }

    public static Path parse(Path parent, String jcrPath, NamespaceResolver resolver) throws MalformedPathException {
        int len;
        int EOF = 65535;
        int n = len = jcrPath == null ? 0 : jcrPath.length();
        if (len == 1 && jcrPath.charAt(0) == '/') {
            return Path.ROOT;
        }
        if (len == 0) {
            throw new MalformedPathException("empty path");
        }
        Path.PathBuilder builder = new Path.PathBuilder();
        int pos = 0;
        if (jcrPath.charAt(0) == '/') {
            if (parent != null) {
                throw new MalformedPathException("'" + jcrPath + "' is not a relative path");
            }
            builder.addRoot();
            ++pos;
        }
        if (parent != null) {
            builder.addAll(parent.getElements());
        }
        int state = 0;
        int lastPos = pos;
        String prefix = "";
        String localName = null;
        int index = 0;
        boolean wasSlash = false;
        while (pos <= len) {
            char c = pos == len ? (char)'\uffff' : (char)jcrPath.charAt(pos);
            ++pos;
            if (c != ' ' && Character.isWhitespace(c)) {
                c = '\t';
            }
            switch (c) {
                case '/': {
                    if (state == 0) {
                        throw new MalformedPathException("'" + jcrPath + "' is not a valid path. double slash '//' not allowed.");
                    }
                }
                case '\uffff': {
                    if (state == 1 || state == 3 || state == 5) {
                        if (localName == null) {
                            if (wasSlash) {
                                throw new MalformedPathException("'" + jcrPath + "' is not a valid path: Trailing slashes not allowed in prefixes and names.");
                            }
                            localName = jcrPath.substring(lastPos, pos - 1);
                        }
                        if (resolver != null) {
                            String nsURI;
                            try {
                                nsURI = resolver.getURI(prefix);
                            }
                            catch (NamespaceException nse) {
                                throw new MalformedPathException("'" + jcrPath + "' is not a valid path: '" + prefix + "' specifies an unmapped namespace prefix");
                            }
                            if (index == 0) {
                                builder.addLast(new QName(nsURI, localName));
                            } else {
                                builder.addLast(new QName(nsURI, localName), index);
                            }
                        }
                        state = 0;
                        lastPos = pos;
                        prefix = "";
                        localName = null;
                        index = 0;
                        break;
                    }
                    if (state == 6) {
                        builder.addLast(Path.CURRENT_ELEMENT);
                        lastPos = pos;
                        state = 0;
                        break;
                    }
                    if (state == 7) {
                        builder.addLast(Path.PARENT_ELEMENT);
                        lastPos = pos;
                        state = 0;
                        break;
                    }
                    if (state == 0 && c == '\uffff') break;
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                }
                case '.': {
                    if (state == 0) {
                        state = 6;
                        break;
                    }
                    if (state == 6) {
                        state = 7;
                        break;
                    }
                    if (state == 7) {
                        state = 1;
                        break;
                    }
                    if (state != 5) break;
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not valid after index. '/' expected.");
                }
                case ':': {
                    if (state == 0) {
                        throw new MalformedPathException("'" + jcrPath + "' is not a valid path. Prefix must not be empty");
                    }
                    if (state == 1) {
                        if (wasSlash) {
                            throw new MalformedPathException("'" + jcrPath + "' is not a valid path: Trailing slashes not allowed in prefixes and names.");
                        }
                        prefix = jcrPath.substring(lastPos, pos - 1);
                        state = 2;
                        lastPos = pos;
                        break;
                    }
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not valid name character");
                }
                case '[': {
                    if (state == 1 || state == 3) {
                        if (wasSlash) {
                            throw new MalformedPathException("'" + jcrPath + "' is not a valid path: Trailing slashes not allowed in prefixes and names.");
                        }
                        localName = jcrPath.substring(lastPos, pos - 1);
                        state = 4;
                        lastPos = pos;
                        break;
                    }
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                }
                case ']': {
                    if (state == 4) {
                        try {
                            index = Integer.parseInt(jcrPath.substring(lastPos, pos - 1));
                        }
                        catch (NumberFormatException e) {
                            throw new MalformedPathException("'" + jcrPath + "' is not a valid path. NumberFormatException in index: " + jcrPath.substring(lastPos, pos - 1));
                        }
                        if (index < 1) {
                            throw new MalformedPathException("'" + jcrPath + "' is not a valid path. Index number invalid: " + index);
                        }
                        state = 5;
                        break;
                    }
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                }
                case ' ': {
                    if (state == 0 || state == 2) {
                        throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not valid name start");
                    }
                    if (state == 5) {
                        throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not valid after index. '/' expected.");
                    }
                    if (state == 6 || state == 7) {
                        state = 1;
                        break;
                    }
                    if (state != 5) break;
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not valid after index. '/' expected.");
                }
                case '\t': {
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. Whitespace not a allowed in name.");
                }
                case '\"': 
                case '\'': 
                case '*': {
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                }
                default: {
                    if (state == 0 || state == 6 || state == 7) {
                        state = 1;
                        break;
                    }
                    if (state == 2) {
                        state = 3;
                        break;
                    }
                    if (state != 5) break;
                    throw new MalformedPathException("'" + jcrPath + "' is not a valid path. '" + c + "' not valid after index. '/' expected.");
                }
            }
            wasSlash = c == ' ';
        }
        if (resolver == null) {
            return null;
        }
        return builder.getPath();
    }

    public static void checkFormat(String jcrPath) throws MalformedPathException {
        PathFormat.parse(null, jcrPath, null);
    }

    public static String format(Path path, NamespaceResolver resolver) throws NoPrefixDeclaredException {
        if (path.denotesRoot()) {
            return "/";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.getLength(); ++i) {
            if (i > 0) {
                sb.append('/');
            }
            PathFormat.format(path.getElement(i), resolver, sb);
        }
        return sb.toString();
    }

    private static void format(Path.PathElement element, NamespaceResolver resolver, StringBuffer buf) throws NoPrefixDeclaredException {
        NameFormat.format(element.getName(), resolver, buf);
        int index = element.getIndex();
        if (index > 1) {
            buf.append('[');
            buf.append(index);
            buf.append(']');
        }
    }
}

