/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.name;

import com.day.crx.name.IllegalNameException;
import com.day.crx.name.NameFormat;
import com.day.crx.name.NamespaceResolver;
import com.day.crx.name.NoPrefixDeclaredException;
import com.day.crx.name.UnknownPrefixException;
import java.io.Serializable;

public final class QName
implements Cloneable,
Comparable,
Serializable {
    public static final String NS_EMPTY_PREFIX = "";
    public static final String NS_DEFAULT_URI = "";
    public static final String NS_REP_PREFIX = "rep";
    public static final String NS_REP_URI = "internal";
    public static final String NS_JCR_PREFIX = "jcr";
    public static final String NS_JCR_URI = "http://www.jcp.org/jcr/1.0";
    public static final String NS_NT_PREFIX = "nt";
    public static final String NS_NT_URI = "http://www.jcp.org/jcr/nt/1.0";
    public static final String NS_MIX_PREFIX = "mix";
    public static final String NS_MIX_URI = "http://www.jcp.org/jcr/mix/1.0";
    public static final String NS_SV_PREFIX = "sv";
    public static final String NS_SV_URI = "http://www.jcp.org/jcr/sv/1.0";
    public static final String NS_XML_PREFIX = "xml";
    public static final String NS_XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String NS_XMLNS_PREFIX = "xmlns";
    public static final String NS_XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final QName ROOT = new QName("", "");
    public static final QName JCR_SYSTEM = new QName("http://www.jcp.org/jcr/1.0", "system");
    public static final QName JCR_NODETYPES = new QName("http://www.jcp.org/jcr/1.0", "nodeTypes");
    public static final QName JCR_UUID = new QName("http://www.jcp.org/jcr/1.0", "uuid");
    public static final QName JCR_PRIMARYTYPE = new QName("http://www.jcp.org/jcr/1.0", "primaryType");
    public static final QName JCR_MIXINTYPES = new QName("http://www.jcp.org/jcr/1.0", "mixinTypes");
    public static final QName JCR_CREATED = new QName("http://www.jcp.org/jcr/1.0", "created");
    public static final QName JCR_LASTMODIFIED = new QName("http://www.jcp.org/jcr/1.0", "lastModified");
    public static final QName JCR_ENCODING = new QName("http://www.jcp.org/jcr/1.0", "encoding");
    public static final QName JCR_MIMETYPE = new QName("http://www.jcp.org/jcr/1.0", "mimeType");
    public static final QName JCR_DATA = new QName("http://www.jcp.org/jcr/1.0", "data");
    public static final QName JCR_CONTENT = new QName("http://www.jcp.org/jcr/1.0", "content");
    public static final QName JCR_ROOT = new QName("http://www.jcp.org/jcr/1.0", "root");
    public static final QName JCR_XMLTEXT = new QName("http://www.jcp.org/jcr/1.0", "xmltext");
    public static final QName JCR_XMLCHARACTERS = new QName("http://www.jcp.org/jcr/1.0", "xmlcharacters");
    public static final QName JCR_SCORE = new QName("http://www.jcp.org/jcr/1.0", "score");
    public static final QName JCR_PATH = new QName("http://www.jcp.org/jcr/1.0", "path");
    public static final QName JCR_STATEMENT = new QName("http://www.jcp.org/jcr/1.0", "statement");
    public static final QName JCR_LANGUAGE = new QName("http://www.jcp.org/jcr/1.0", "language");
    public static final QName JCR_LOCKOWNER = new QName("http://www.jcp.org/jcr/1.0", "lockOwner");
    public static final QName JCR_LOCKISDEEP = new QName("http://www.jcp.org/jcr/1.0", "lockIsDeep");
    public static final QName JCR_VERSIONSTORAGE = new QName("http://www.jcp.org/jcr/1.0", "versionStorage");
    public static final QName JCR_MERGEFAILED = new QName("http://www.jcp.org/jcr/1.0", "mergeFailed");
    public static final QName JCR_FROZENNODE = new QName("http://www.jcp.org/jcr/1.0", "frozenNode");
    public static final QName JCR_FROZENUUID = new QName("http://www.jcp.org/jcr/1.0", "frozenUuid");
    public static final QName JCR_FROZENPRIMARYTYPE = new QName("http://www.jcp.org/jcr/1.0", "frozenPrimaryType");
    public static final QName JCR_FROZENMIXINTYPES = new QName("http://www.jcp.org/jcr/1.0", "frozenMixinTypes");
    public static final QName JCR_PREDECESSORS = new QName("http://www.jcp.org/jcr/1.0", "predecessors");
    public static final QName JCR_VERSIONLABELS = new QName("http://www.jcp.org/jcr/1.0", "versionLabels");
    public static final QName JCR_SUCCESSORS = new QName("http://www.jcp.org/jcr/1.0", "successors");
    public static final QName JCR_ISCHECKEDOUT = new QName("http://www.jcp.org/jcr/1.0", "isCheckedOut");
    public static final QName JCR_VERSIONHISTORY = new QName("http://www.jcp.org/jcr/1.0", "versionHistory");
    public static final QName JCR_BASEVERSION = new QName("http://www.jcp.org/jcr/1.0", "baseVersion");
    public static final QName JCR_CHILDVERSIONHISTORY = new QName("http://www.jcp.org/jcr/1.0", "childVersionHistory");
    public static final QName JCR_ROOTVERSION = new QName("http://www.jcp.org/jcr/1.0", "rootVersion");
    public static final QName JCR_VERSIONABLEUUID = new QName("http://www.jcp.org/jcr/1.0", "versionableUuid");
    public static final QName JCR_NODETYPENAME = new QName("http://www.jcp.org/jcr/1.0", "nodeTypeName");
    public static final QName JCR_HASORDERABLECHILDNODES = new QName("http://www.jcp.org/jcr/1.0", "hasOrderableChildNodes");
    public static final QName JCR_ISMIXIN = new QName("http://www.jcp.org/jcr/1.0", "isMixin");
    public static final QName JCR_SUPERTYPES = new QName("http://www.jcp.org/jcr/1.0", "supertypes");
    public static final QName JCR_PROPERTYDEFINITION = new QName("http://www.jcp.org/jcr/1.0", "propertyDefinition");
    public static final QName JCR_NAME = new QName("http://www.jcp.org/jcr/1.0", "name");
    public static final QName JCR_MANDATORY = new QName("http://www.jcp.org/jcr/1.0", "mandatory");
    public static final QName JCR_PROTECTED = new QName("http://www.jcp.org/jcr/1.0", "protected");
    public static final QName JCR_REQUIREDTYPE = new QName("http://www.jcp.org/jcr/1.0", "requiredType");
    public static final QName JCR_ONPARENTVERSION = new QName("http://www.jcp.org/jcr/1.0", "onParentVersion");
    public static final QName JCR_PRIMARYITEMNAME = new QName("http://www.jcp.org/jcr/1.0", "primaryItemName");
    public static final QName JCR_MULTIPLE = new QName("http://www.jcp.org/jcr/1.0", "multiple");
    public static final QName JCR_VALUECONSTRAINTS = new QName("http://www.jcp.org/jcr/1.0", "valueConstraints");
    public static final QName JCR_DEFAULTVALUES = new QName("http://www.jcp.org/jcr/1.0", "defaultValues");
    public static final QName JCR_AUTOCREATED = new QName("http://www.jcp.org/jcr/1.0", "autoCreated");
    public static final QName JCR_CHILDNODEDEFINITION = new QName("http://www.jcp.org/jcr/1.0", "childNodeDefinition");
    public static final QName JCR_SAMENAMESIBLINGS = new QName("http://www.jcp.org/jcr/1.0", "sameNameSiblings");
    public static final QName JCR_DEFAULTPRIMARYTYPE = new QName("http://www.jcp.org/jcr/1.0", "defaultPrimaryType");
    public static final QName JCR_REQUIREDPRIMARYTYPES = new QName("http://www.jcp.org/jcr/1.0", "requiredPrimaryTypes");
    public static final QName REP_ROOT = new QName("internal", "root");
    public static final QName REP_SYSTEM = new QName("internal", "system");
    public static final QName REP_VERSIONSTORAGE = new QName("internal", "versionStorage");
    public static final QName REP_NODETYPES = new QName("internal", "nodeTypes");
    public static final QName NT_UNSTRUCTURED = new QName("http://www.jcp.org/jcr/nt/1.0", "unstructured");
    public static final QName NT_BASE = new QName("http://www.jcp.org/jcr/nt/1.0", "base");
    public static final QName NT_HIERARCHYNODE = new QName("http://www.jcp.org/jcr/nt/1.0", "hierarchyNode");
    public static final QName NT_RESOURCE = new QName("http://www.jcp.org/jcr/nt/1.0", "resource");
    public static final QName NT_FILE = new QName("http://www.jcp.org/jcr/nt/1.0", "file");
    public static final QName NT_FOLDER = new QName("http://www.jcp.org/jcr/nt/1.0", "folder");
    public static final QName NT_QUERY = new QName("http://www.jcp.org/jcr/nt/1.0", "query");
    public static final QName MIX_REFERENCEABLE = new QName("http://www.jcp.org/jcr/mix/1.0", "referenceable");
    public static final QName MIX_LOCKABLE = new QName("http://www.jcp.org/jcr/mix/1.0", "lockable");
    public static final QName MIX_VERSIONABLE = new QName("http://www.jcp.org/jcr/mix/1.0", "versionable");
    public static final QName NT_VERSIONHISTORY = new QName("http://www.jcp.org/jcr/nt/1.0", "versionHistory");
    public static final QName NT_VERSION = new QName("http://www.jcp.org/jcr/nt/1.0", "version");
    public static final QName NT_VERSIONLABELS = new QName("http://www.jcp.org/jcr/nt/1.0", "versionLabels");
    public static final QName NT_VERSIONEDCHILD = new QName("http://www.jcp.org/jcr/nt/1.0", "versionedChild");
    public static final QName NT_FROZENNODE = new QName("http://www.jcp.org/jcr/nt/1.0", "frozenNode");
    public static final QName NT_NODETYPE = new QName("http://www.jcp.org/jcr/nt/1.0", "nodeType");
    public static final QName NT_PROPERTYDEFINITION = new QName("http://www.jcp.org/jcr/nt/1.0", "propertyDefinition");
    public static final QName NT_CHILDNODEDEFINITION = new QName("http://www.jcp.org/jcr/nt/1.0", "childNodeDefinition");
    public static final QName SV_NODE = new QName("http://www.jcp.org/jcr/sv/1.0", "node");
    public static final QName SV_PROPERTY = new QName("http://www.jcp.org/jcr/sv/1.0", "property");
    public static final QName SV_VALUE = new QName("http://www.jcp.org/jcr/sv/1.0", "value");
    public static final QName SV_TYPE = new QName("http://www.jcp.org/jcr/sv/1.0", "type");
    public static final QName SV_NAME = new QName("http://www.jcp.org/jcr/sv/1.0", "name");
    static final long serialVersionUID = -2712313010017755368L;
    public static final QName[] EMPTY_ARRAY = new QName[0];
    private transient int hash;
    private transient String string;
    private final String namespaceURI;
    private final String localName;

    public QName(String namespaceURI, String localName) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("invalid namespaceURI specified");
        }
        if (localName == null) {
            throw new IllegalArgumentException("invalid localName specified");
        }
        this.namespaceURI = namespaceURI.intern();
        this.localName = localName;
        this.hash = 0;
    }

    public static QName fromJCRName(String rawName, NamespaceResolver resolver) throws IllegalNameException, UnknownPrefixException {
        return NameFormat.parse(rawName, resolver);
    }

    public static QName valueOf(String s) throws IllegalArgumentException {
        if ("".equals(s) || s == null) {
            throw new IllegalArgumentException("invalid QName literal");
        }
        if (s.charAt(0) == '{') {
            int i = s.indexOf(125);
            if (i == -1) {
                throw new IllegalArgumentException("invalid QName literal");
            }
            if (i == s.length() - 1) {
                throw new IllegalArgumentException("invalid QName literal");
            }
            return new QName(s.substring(1, i), s.substring(i + 1));
        }
        throw new IllegalArgumentException("invalid QName literal");
    }

    public static void checkFormat(String jcrName) throws IllegalNameException {
        NameFormat.checkFormat(jcrName);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String toJCRName(NamespaceResolver resolver) throws NoPrefixDeclaredException {
        return NameFormat.format(this, resolver);
    }

    public void toJCRName(NamespaceResolver resolver, StringBuffer buf) throws NoPrefixDeclaredException {
        NameFormat.format(this, resolver, buf);
    }

    public String toString() {
        if (this.string == null) {
            this.string = '{' + this.namespaceURI + '}' + this.localName;
        }
        return this.string;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QName) {
            QName other = (QName)obj;
            return this.namespaceURI == other.namespaceURI && this.localName.equals(other.localName);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = 17;
            h = 37 * h + this.namespaceURI.hashCode();
            this.hash = h = 37 * h + this.localName.hashCode();
        }
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        QName other = (QName)o;
        if (this.namespaceURI == other.namespaceURI) {
            return this.localName.compareTo(other.localName);
        }
        return this.namespaceURI.compareTo(other.namespaceURI);
    }

    private Object readResolve() {
        return new QName(this.namespaceURI, this.localName);
    }
}

