/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.nodetype;

import com.day.crx.name.IllegalNameException;
import com.day.crx.name.NameFormat;
import com.day.crx.name.NamespaceResolver;
import com.day.crx.name.NoPrefixDeclaredException;
import com.day.crx.name.QName;
import com.day.crx.name.SessionNamespaceResolver;
import com.day.crx.name.UnknownPrefixException;
import com.day.crx.nodetype.InvalidConstraintException;
import com.day.crx.nodetype.NodeDef;
import com.day.crx.nodetype.NodeDefBuilder;
import com.day.crx.nodetype.NodeTypeBuilder;
import com.day.crx.nodetype.NodeTypeDef;
import com.day.crx.nodetype.NodeTypeRegistry;
import com.day.crx.nodetype.PropDef;
import com.day.crx.nodetype.PropDefBuilder;
import com.day.crx.nodetype.ValueConstraint;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;

public class NodeTypeMapping {
    private final NodeTypeRegistry ntReg;
    private final NamespaceResolver nsResolver;

    public NodeTypeMapping(NodeTypeRegistry ntReg, NamespaceResolver nsResolver) {
        this.ntReg = ntReg;
        this.nsResolver = nsResolver;
    }

    public NodeTypeDef createNodeTypeDef(Node node) throws RepositoryException, InvalidConstraintException {
        try {
            if (node == null || !node.isNodeType(NameFormat.format(QName.NT_NODETYPE, this.nsResolver))) {
                throw new RepositoryException("Node of type 'nt:nodeType' expected.");
            }
            NodeTypeBuilder def = this.ntReg.createNodeTypeBuilder();
            QName ntName = NameFormat.parse(node.getProperty(NameFormat.format(QName.JCR_NODETYPENAME, this.nsResolver)).getString(), this.nsResolver);
            def.setName(ntName);
            def.setMixin(node.getProperty(NameFormat.format(QName.JCR_ISMIXIN, this.nsResolver)).getBoolean());
            def.setOrderableChildNodes(node.getProperty(NameFormat.format(QName.JCR_HASORDERABLECHILDNODES, this.nsResolver)).getBoolean());
            ArrayList<Object> list = new ArrayList<Object>();
            if (node.hasProperty(NameFormat.format(QName.JCR_SUPERTYPES, this.nsResolver))) {
                Property supertypeProp = node.getProperty(NameFormat.format(QName.JCR_SUPERTYPES, this.nsResolver));
                Value[] values = supertypeProp.getValues();
                for (int i = 0; i < values.length; ++i) {
                    String stName = values[i].getString();
                    list.add(NameFormat.parse(stName, this.nsResolver));
                }
            }
            def.setSupertypes(list.toArray(new QName[list.size()]));
            NodeIterator ni = node.getNodes(NameFormat.format(QName.JCR_CHILDNODEDEFINITION, this.nsResolver));
            list = new ArrayList();
            while (ni.hasNext()) {
                Node childNode = ni.nextNode();
                NodeDef childDef = this.createChildNodeDef(childNode, ntName);
                list.add(childDef);
            }
            def.setChildNodeDefs(list.toArray(new NodeDef[list.size()]));
            ni = node.getNodes(NameFormat.format(QName.JCR_PROPERTYDEFINITION, this.nsResolver));
            list = new ArrayList();
            while (ni.hasNext()) {
                Node propNode = ni.nextNode();
                PropDef propDef = this.createPropDef(propNode, ntName);
                list.add(propDef);
            }
            def.setPropertyDefs(list.toArray(new PropDef[list.size()]));
            if (node.hasProperty(NameFormat.format(QName.JCR_PRIMARYITEMNAME, this.nsResolver))) {
                Value val = node.getProperty(NameFormat.format(QName.JCR_PRIMARYITEMNAME, this.nsResolver)).getValue();
                def.setPrimaryItemName(NameFormat.parse(val.getString(), this.nsResolver));
            }
            return def.build();
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("internal error: failed to resolve namespace prefix", (Throwable)upe);
        }
        catch (NoPrefixDeclaredException npde) {
            throw new RepositoryException("internal error: unknown namespace", (Throwable)npde);
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("internal error: illegal name", (Throwable)ine);
        }
    }

    public PropDef createPropDef(Node propertyDef, QName declaringNodeType) throws RepositoryException, InvalidConstraintException {
        try {
            String typeProp;
            if (propertyDef == null || !propertyDef.isNodeType(NameFormat.format(QName.NT_PROPERTYDEFINITION, this.nsResolver))) {
                throw new RepositoryException("Node of type 'nt:propertyDef' expected.");
            }
            PropDefBuilder def = this.ntReg.createPropDefBuilder();
            def.setDeclaringNodeType(declaringNodeType);
            if (propertyDef.hasProperty(NameFormat.format(QName.JCR_NAME, this.nsResolver))) {
                def.setName(NameFormat.parse(propertyDef.getProperty(NameFormat.format(QName.JCR_NAME, this.nsResolver)).getString(), this.nsResolver));
            }
            def.setAutoCreated(propertyDef.getProperty(NameFormat.format(QName.JCR_AUTOCREATED, this.nsResolver)).getBoolean());
            def.setMandatory(propertyDef.getProperty(NameFormat.format(QName.JCR_MANDATORY, this.nsResolver)).getBoolean());
            if (propertyDef.hasProperty(NameFormat.format(QName.JCR_ONPARENTVERSION, this.nsResolver))) {
                Property onVersion = propertyDef.getProperty(NameFormat.format(QName.JCR_ONPARENTVERSION, this.nsResolver));
                def.setOnParentVersion(OnParentVersionAction.valueFromName((String)onVersion.getString()));
            }
            def.setProtected(propertyDef.getProperty(NameFormat.format(QName.JCR_PROTECTED, this.nsResolver)).getBoolean());
            def.setMultiple(propertyDef.getProperty(NameFormat.format(QName.JCR_MULTIPLE, this.nsResolver)).getBoolean());
            int type = 0;
            if (propertyDef.hasProperty(NameFormat.format(QName.JCR_REQUIREDTYPE, this.nsResolver)) && !(typeProp = propertyDef.getProperty(NameFormat.format(QName.JCR_REQUIREDTYPE, this.nsResolver)).getString()).equalsIgnoreCase("undefined")) {
                try {
                    type = PropertyType.valueFromName((String)typeProp);
                }
                catch (IllegalArgumentException e) {
                    typeProp = typeProp.substring(0, 1).toUpperCase() + typeProp.substring(1).toLowerCase();
                    type = PropertyType.valueFromName((String)typeProp);
                }
            }
            def.setRequiredType(type);
            Property constr = propertyDef.getProperty(NameFormat.format(QName.JCR_VALUECONSTRAINTS, this.nsResolver));
            Value[] vals = constr.getValues();
            ValueConstraint[] vca = new ValueConstraint[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                vca[i] = this.ntReg.createValueConstraint(type, vals[i].getString(), this.nsResolver);
            }
            def.setValueConstraints(vca);
            Property defValue = propertyDef.getProperty(NameFormat.format(QName.JCR_DEFAULTVALUES, this.nsResolver));
            vals = defValue.getValues();
            def.setDefaultValues(vals, this.nsResolver);
            return def.build();
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("internal error: failed to resolve namespace prefix", (Throwable)upe);
        }
        catch (NoPrefixDeclaredException npde) {
            throw new RepositoryException("internal error: unknown namespace", (Throwable)npde);
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("internal error: illegal name", (Throwable)ine);
        }
    }

    public NodeDef createChildNodeDef(Node childNodeDef, QName declaringNodeType) throws RepositoryException {
        try {
            Property defaultPrimaryType;
            String dpt;
            if (childNodeDef == null || !childNodeDef.isNodeType(NameFormat.format(QName.NT_CHILDNODEDEFINITION, this.nsResolver))) {
                throw new RepositoryException("Node of type 'nt:childNodeDef' expected.");
            }
            NodeDefBuilder def = this.ntReg.createNodeDefBuilder();
            def.setDeclaringNodeType(declaringNodeType);
            if (childNodeDef.hasProperty(NameFormat.format(QName.JCR_NAME, this.nsResolver))) {
                Value nameVal = childNodeDef.getProperty(NameFormat.format(QName.JCR_NAME, this.nsResolver)).getValue();
                def.setName(NameFormat.parse(nameVal.getString(), this.nsResolver));
            }
            def.setAutoCreated(childNodeDef.getProperty(NameFormat.format(QName.JCR_AUTOCREATED, this.nsResolver)).getBoolean());
            def.setMandatory(childNodeDef.getProperty(NameFormat.format(QName.JCR_MANDATORY, this.nsResolver)).getBoolean());
            if (childNodeDef.hasProperty(NameFormat.format(QName.JCR_ONPARENTVERSION, this.nsResolver))) {
                Property onVersion = childNodeDef.getProperty(NameFormat.format(QName.JCR_ONPARENTVERSION, this.nsResolver));
                def.setOnParentVersion(OnParentVersionAction.valueFromName((String)onVersion.getString()));
            }
            def.setProtected(childNodeDef.getProperty(NameFormat.format(QName.JCR_PROTECTED, this.nsResolver)).getBoolean());
            def.setAllowsSameNameSiblings(childNodeDef.getProperty(NameFormat.format(QName.JCR_SAMENAMESIBLINGS, this.nsResolver)).getBoolean());
            if (childNodeDef.hasProperty(NameFormat.format(QName.JCR_DEFAULTPRIMARYTYPE, this.nsResolver)) && !"".equals(dpt = (defaultPrimaryType = childNodeDef.getProperty(NameFormat.format(QName.JCR_DEFAULTPRIMARYTYPE, this.nsResolver))).getString())) {
                def.setDefaultPrimaryType(NameFormat.parse(dpt, this.nsResolver));
            }
            if (childNodeDef.hasProperty(NameFormat.format(QName.JCR_REQUIREDPRIMARYTYPES, this.nsResolver))) {
                Property rptProp = childNodeDef.getProperty(NameFormat.format(QName.JCR_REQUIREDPRIMARYTYPES, this.nsResolver));
                Value[] values = rptProp.getValues();
                QName[] requiredPrimaryTypes = new QName[values.length];
                for (int i = 0; i < values.length; ++i) {
                    requiredPrimaryTypes[i] = NameFormat.parse(values[i].getString(), this.nsResolver);
                }
                def.setRequiredPrimaryTypes(requiredPrimaryTypes);
            }
            return def.build();
        }
        catch (UnknownPrefixException upe) {
            throw new RepositoryException("internal error: failed to resolve namespace prefix", (Throwable)upe);
        }
        catch (NoPrefixDeclaredException npde) {
            throw new RepositoryException("internal error: unknown namespace", (Throwable)npde);
        }
        catch (IllegalNameException ine) {
            throw new RepositoryException("internal error: illegal name", (Throwable)ine);
        }
    }

    public static Node mapNodeType(Node parentNode, NodeType nt) throws RepositoryException {
        return NodeTypeMapping.mapNodeType(parentNode, nt, nt.getName());
    }

    public static Node mapNodeType(Node parentNode, NodeTypeDef nt) throws RepositoryException, NoPrefixDeclaredException {
        SessionNamespaceResolver resolver = new SessionNamespaceResolver(parentNode.getSession());
        return NodeTypeMapping.mapNodeType(parentNode, nt, NameFormat.format(nt.getName(), (NamespaceResolver)resolver));
    }

    public static Node mapNodeType(Node parentNode, NodeTypeDef nt, String nodeName) throws RepositoryException, NoPrefixDeclaredException {
        if (parentNode.hasNode(nodeName)) {
            return parentNode.getNode(nodeName);
        }
        SessionNamespaceResolver resolver = new SessionNamespaceResolver(parentNode.getSession());
        Node node = parentNode.addNode(nodeName, "nt:nodeType");
        node.setProperty("jcr:nodeTypeName", NameFormat.format(nt.getName(), (NamespaceResolver)resolver));
        node.setProperty("jcr:supertypes", NodeTypeMapping.getNames(nt.getSupertypes(), resolver));
        node.setProperty("jcr:isMixin", nt.isMixin());
        node.setProperty("jcr:hasOrderableChildNodes", nt.hasOrderableChildNodes());
        if (nt.getPrimaryItemName() != null) {
            node.setProperty("jcr:primaryItemName", NameFormat.format(nt.getPrimaryItemName(), (NamespaceResolver)resolver));
        }
        PropDef[] pdefs = nt.getPropertyDefs();
        for (int i = 0; i < pdefs.length; ++i) {
            NodeTypeMapping.mapPropertyDef(node, pdefs[i]);
        }
        NodeDef[] cdefs = nt.getChildNodeDefs();
        for (int i = 0; i < cdefs.length; ++i) {
            NodeTypeMapping.mapNodeDef(node, cdefs[i]);
        }
        return node;
    }

    public static Node mapNodeType(Node parentNode, NodeType nt, String nodeName) throws RepositoryException {
        if (parentNode.hasNode(nodeName)) {
            return parentNode.getNode(nodeName);
        }
        Node node = parentNode.addNode(nodeName, "nt:nodeType");
        node.setProperty("jcr:nodeTypeName", nt.getName());
        node.setProperty("jcr:supertypes", NodeTypeMapping.getNames(nt.getDeclaredSupertypes()));
        node.setProperty("jcr:isMixin", nt.isMixin());
        node.setProperty("jcr:hasOrderableChildNodes", nt.hasOrderableChildNodes());
        node.setProperty("jcr:primaryItemName", nt.getPrimaryItemName());
        PropertyDefinition[] pdefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < pdefs.length; ++i) {
            NodeTypeMapping.mapPropertyDef(node, pdefs[i]);
        }
        NodeDefinition[] cdefs = nt.getDeclaredChildNodeDefinitions();
        for (int i = 0; i < cdefs.length; ++i) {
            NodeTypeMapping.mapNodeDef(node, cdefs[i]);
        }
        return node;
    }

    public static Node mapPropertyDef(Node ntNode, PropDef pdef) throws RepositoryException, NoPrefixDeclaredException {
        SessionNamespaceResolver resolver = new SessionNamespaceResolver(ntNode.getSession());
        Node node = ntNode.addNode("jcr:propertyDefinition", "nt:propertyDefinition");
        if (!pdef.definesResidual()) {
            node.setProperty("jcr:name", NameFormat.format(pdef.getName(), (NamespaceResolver)resolver));
        }
        node.setProperty("jcr:autoCreated", pdef.isAutoCreated());
        node.setProperty("jcr:mandatory", pdef.isMandatory());
        node.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)pdef.getOnParentVersion()));
        node.setProperty("jcr:protected", pdef.isProtected());
        node.setProperty("jcr:requiredType", PropertyType.nameFromValue((int)pdef.getRequiredType()).toUpperCase());
        ValueConstraint[] cs = pdef.getValueConstraints();
        String[] cons = new String[cs.length];
        for (int i = 0; i < cs.length; ++i) {
            cons[i] = cs[i].getDefinition(resolver);
        }
        node.setProperty("jcr:valueConstraints", cons);
        node.setProperty("jcr:defaultValues", pdef.getDefaultValues(resolver));
        node.setProperty("jcr:multiple", pdef.isMultiple());
        return node;
    }

    public static Node mapPropertyDef(Node ntNode, PropertyDefinition pdef) throws RepositoryException {
        Node node = ntNode.addNode("jcr:propertyDefinition", "nt:propertyDefinition");
        if (!pdef.getName().equals("*")) {
            node.setProperty("jcr:name", pdef.getName());
        }
        node.setProperty("jcr:autoCreated", pdef.isAutoCreated());
        node.setProperty("jcr:mandatory", pdef.isMandatory());
        node.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)pdef.getOnParentVersion()));
        node.setProperty("jcr:protected", pdef.isProtected());
        node.setProperty("jcr:requiredType", PropertyType.nameFromValue((int)pdef.getRequiredType()).toUpperCase());
        node.setProperty("jcr:valueConstraints", pdef.getValueConstraints());
        node.setProperty("jcr:defaultValues", pdef.getDefaultValues());
        node.setProperty("jcr:multiple", pdef.isMultiple());
        return node;
    }

    public static Node mapNodeDef(Node ntNode, NodeDefinition ndef) throws RepositoryException {
        Node node = ntNode.addNode("jcr:childNodeDefinition", "nt:childNodeDefinition");
        if (!ndef.getName().equals("*")) {
            node.setProperty("jcr:name", ndef.getName());
        }
        node.setProperty("jcr:autoCreated", ndef.isAutoCreated());
        node.setProperty("jcr:mandatory", ndef.isMandatory());
        node.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)ndef.getOnParentVersion()));
        node.setProperty("jcr:protected", ndef.isProtected());
        node.setProperty("jcr:requiredPrimaryTypes", NodeTypeMapping.getNames(ndef.getRequiredPrimaryTypes()));
        if (ndef.getDefaultPrimaryType() != null) {
            node.setProperty("jcr:defaultPrimaryType", ndef.getDefaultPrimaryType().getName());
        }
        node.setProperty("jcr:sameNameSiblings", ndef.allowsSameNameSiblings());
        return node;
    }

    public static Node mapNodeDef(Node ntNode, NodeDef ndef) throws RepositoryException, NoPrefixDeclaredException {
        SessionNamespaceResolver resolver = new SessionNamespaceResolver(ntNode.getSession());
        Node node = ntNode.addNode("jcr:childNodeDefinition", "nt:childNodeDefinition");
        if (!ndef.definesResidual()) {
            node.setProperty("jcr:name", NameFormat.format(ndef.getName(), (NamespaceResolver)resolver));
        }
        node.setProperty("jcr:autoCreated", ndef.isAutoCreated());
        node.setProperty("jcr:mandatory", ndef.isMandatory());
        node.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)ndef.getOnParentVersion()));
        node.setProperty("jcr:protected", ndef.isProtected());
        node.setProperty("jcr:requiredPrimaryTypes", NodeTypeMapping.getNames(ndef.getRequiredPrimaryTypes(), resolver));
        if (ndef.getDefaultPrimaryType() != null) {
            node.setProperty("jcr:defaultPrimaryType", NameFormat.format(ndef.getDefaultPrimaryType(), (NamespaceResolver)resolver));
        }
        node.setProperty("jcr:sameNameSiblings", ndef.allowsSameNameSiblings());
        return node;
    }

    private static String[] getNames(NodeType[] nodeTypes) {
        String[] ret = new String[nodeTypes.length];
        for (int i = 0; i < nodeTypes.length; ++i) {
            ret[i] = nodeTypes[i].getName();
        }
        return ret;
    }

    private static String[] getNames(QName[] names, NamespaceResolver res) throws NoPrefixDeclaredException {
        String[] ret = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            ret[i] = NameFormat.format(names[i], res);
        }
        return ret;
    }
}

