/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.uuid;

import com.day.crx.uuid.Constants;
import com.day.crx.uuid.VersionFourGenerator;
import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;

public class UUID
implements Constants,
Serializable,
Comparable {
    static final long serialVersionUID = 2526142433736157231L;
    private final long lsb;
    private final long msb;
    private static VersionFourGenerator versionFourGenereator = new VersionFourGenerator();

    public UUID(byte[] b) throws IllegalArgumentException {
        if (b.length != 16) {
            throw new IllegalArgumentException("UUID must be contructed using a 16 byte array.");
        }
        this.msb = ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
        this.lsb = ((long)b[15] & 0xFFL) + (((long)b[14] & 0xFFL) << 8) + (((long)b[13] & 0xFFL) << 16) + (((long)b[12] & 0xFFL) << 24) + (((long)b[11] & 0xFFL) << 32) + (((long)b[10] & 0xFFL) << 40) + (((long)b[9] & 0xFFL) << 48) + (((long)b[8] & 0xFFL) << 56);
    }

    public UUID(DataInput input) throws IOException {
        this.msb = input.readLong();
        this.lsb = input.readLong();
    }

    public UUID(long mostSignificant, long leastSignificant) {
        this.msb = mostSignificant;
        this.lsb = leastSignificant;
    }

    public UUID(String uuidString) throws IllegalArgumentException {
        int len = uuidString.length();
        if (len != 36) {
            throw new IllegalArgumentException();
        }
        long[] words = new long[2];
        int b = 0;
        for (int i = 0; i < 36; ++i) {
            int c = uuidString.charAt(i) | 0x20;
            if (i == 8 || i == 13 || i == 23) {
                if (c == 45) continue;
                throw new IllegalArgumentException(String.valueOf(i));
            }
            if (i == 18) {
                if (c != 45) {
                    throw new IllegalArgumentException(String.valueOf(i));
                }
                b = 1;
                continue;
            }
            byte h = (byte)(c & 0xF);
            if (c >= 97 && c <= 102) {
                h = (byte)(h + 9);
            } else if (c < 48 || c > 57) {
                throw new IllegalArgumentException();
            }
            words[b] = words[b] << 4 | (long)h;
        }
        this.msb = words[0];
        this.lsb = words[1];
    }

    public static UUID fromString(String uuidString) throws IllegalArgumentException {
        return new UUID(uuidString);
    }

    public String toString() {
        int i;
        char[] chars = new char[36];
        int j = 0;
        for (i = 60; i >= 0; i -= 4) {
            chars[j++] = hexDigits[(int)(this.msb >> i) & 0xF];
            if (j != 8 && j != 13 && j != 18) continue;
            chars[j++] = 45;
        }
        j = 19;
        for (i = 60; i >= 0; i -= 4) {
            chars[j++] = hexDigits[(int)(this.lsb >> i) & 0xF];
            if (j != 23) continue;
            chars[j++] = 45;
        }
        return new String(chars);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UUID) {
            UUID o = (UUID)obj;
            return o.msb == this.msb && o.lsb == this.lsb;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.msb >>> 32 ^ this.msb ^ this.lsb >>> 32 ^ this.lsb);
    }

    public int compareTo(Object compareTo) throws ClassCastException {
        UUID u = (UUID)compareTo;
        if (this.msb == u.msb) {
            if (this.lsb == u.lsb) {
                return 0;
            }
            return this.lsb > u.lsb ? 1 : -1;
        }
        return this.msb > u.msb ? 1 : -1;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public byte[] getRawBytes() {
        byte[] b = new byte[16];
        long n = this.msb;
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        n = this.lsb;
        b[15] = (byte)n;
        b[14] = (byte)(n >>>= 8);
        b[13] = (byte)(n >>>= 8);
        b[12] = (byte)(n >>>= 8);
        b[11] = (byte)(n >>>= 8);
        b[10] = (byte)(n >>>= 8);
        b[9] = (byte)(n >>>= 8);
        b[8] = (byte)(n >>>= 8);
        return b;
    }

    public static UUID randomUUID() {
        return (UUID)versionFourGenereator.nextIdentifier();
    }
}

